/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.upload.service;

import com.vmware.ph.client.extension.ExtensionUtil;
import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.common.net.SingleProxySettingsProvider;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.extension.ProxyAutodiscoveryExtension;
import com.vmware.ph.upload.UploaderAbstractFactory;
import com.vmware.ph.upload.rest.PhRestClientImpl;
import com.vmware.ph.upload.service.UploadService;
import com.vmware.ph.upload.service.UploadServiceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadServiceBuilder {
    private static final Logger log = LoggerFactory.getLogger(UploadServiceBuilder.class);
    private int maxRetries = 3;
    private int maxConnectionsTotal = 30;
    private int maxConnectionsPerRoute = 10;
    private int connectionTimeout = 60000;
    private static String CLIENT_CONFIG_PROPERTIES = "client-config.properties";
    private static PropertiesLoader propertiesLoader = new PropertiesLoader();
    private final HttpConnectionConfigInstantiator httpConnectionConfigInstantiator;
    static final String PH_PRODUCTION_SERVER_URL_KEY = "ph-prod-server.url";
    static final String PH_TEST_SERVER_URL_KEY = "ph-test-server.url";
    private final String phServerUrl;
    private ExtensionUtil extensionUtil = ExtensionUtil.getInstance();
    private ProxySettingsProvider proxySettingsProvider = null;
    private ProxySettings customProxySettings;
    private final UploaderAbstractFactory uploaderFactory;
    private TrustManager[] trustManagers = null;

    private UploadServiceBuilder(String phServerUrl, UploaderAbstractFactory uploaderFactory) {
        this.phServerUrl = phServerUrl;
        this.uploaderFactory = uploaderFactory;
        this.httpConnectionConfigInstantiator = new HttpConnectionConfigInstantiator();
    }

    public UploadServiceBuilder withProxyProvider(ProxySettingsProvider proxySettingsProvider) {
        this.proxySettingsProvider = proxySettingsProvider;
        return this;
    }

    public UploadServiceBuilder withProxySettings(ProxySettings proxySettings) {
        Validate.notNull(proxySettings);
        this.customProxySettings = proxySettings;
        return this.withProxyProvider(new SingleProxySettingsProvider(proxySettings));
    }

    public UploadServiceBuilder withMaxRetries(int maxRetries) {
        Validate.isTrue(maxRetries > 0, "The maxRetries argument must be a non-zero, positive interger.");
        this.maxRetries = maxRetries;
        return this;
    }

    public UploadServiceBuilder withMaxConnectionsTotal(int maxConnectionsTotal) {
        this.maxConnectionsTotal = maxConnectionsTotal;
        return this;
    }

    public UploadServiceBuilder withMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        return this;
    }

    public UploadServiceBuilder withConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public UploadServiceBuilder withTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
        return this;
    }

    public static UploadServiceBuilder create(Environment env, UploaderAbstractFactory uploaderFactory) {
        Properties props = propertiesLoader.loadDefaultConfigProps();
        String serverUrl = null;
        serverUrl = Environment.PRODUCTION.equals((Object)env) ? props.getProperty(PH_PRODUCTION_SERVER_URL_KEY) : props.getProperty(PH_TEST_SERVER_URL_KEY);
        if (serverUrl == null) {
            throw new RuntimeException("The UploadServiceBuilder is configured with empty serverUrl property. This is not programatically recoverable error and the program cannot continue. This issue may occur if the configuration file " + CLIENT_CONFIG_PROPERTIES + " is missing from the classpath, or if its content is incorrectly changed." + " Please contact the PH library dev team.");
        }
        return new UploadServiceBuilder(serverUrl, uploaderFactory);
    }

    public static UploadServiceBuilder createForCustomServer(String serverUrl, UploaderAbstractFactory uploaderFactory) {
        return new UploadServiceBuilder(serverUrl, uploaderFactory);
    }

    public UploadService build() {
        this.initProxySettingsProvider();
        ProxySettings ps = this.customProxySettings == null ? ProxySettings.NO_PROXY : this.customProxySettings;
        HttpConnectionConfig connConfig = this.httpConnectionConfigInstantiator.create(this.maxConnectionsPerRoute, this.maxConnectionsTotal, this.connectionTimeout, this.trustManagers);
        PhRestClientImpl phRestServerClient = new PhRestClientImpl(this.phServerUrl, ps, connConfig);
        UploadServiceImpl.UploadFacility uploadFacility = new UploadServiceImpl.UploadFacility(this.uploaderFactory, ps, connConfig);
        UploadServiceImpl uploadService = new UploadServiceImpl(uploadFacility, this.maxRetries, this.proxySettingsProvider, phRestServerClient, connConfig);
        return uploadService;
    }

    private void initProxySettingsProvider() {
        if (this.proxySettingsProvider == null) {
            ProxyAutodiscoveryExtension extension = this.extensionUtil.loadExtension(ProxyAutodiscoveryExtension.class);
            if (extension == null) {
                log.debug("No ProxyAutodiscoveryExtension loaded. Proxy autodiscovery is disabled - using ProxySettingsProvider.NO_PROXY_SETTINGS.");
                this.proxySettingsProvider = ProxySettingsProvider.NO_PROXY_SETTINGS;
            } else {
                String phServerTimeUri = this.phServerUrl + "server_time";
                extension.setProxyConnectionTestUri(URI.create(phServerTimeUri));
                log.debug("ProxyAutodiscoveryExtension successfully loaded. Setting phServerTimeUri = {}", (Object)phServerTimeUri);
                this.proxySettingsProvider = extension;
            }
        }
    }

    static class HttpConnectionConfigInstantiator {
        HttpConnectionConfigInstantiator() {
        }

        public HttpConnectionConfig create(int maxConnectionsPerRoute, int maxConnectionsTotal, int connectionTimeout, TrustManager[] trustManagers) {
            return new HttpConnectionConfig(maxConnectionsPerRoute, maxConnectionsTotal, connectionTimeout, trustManagers);
        }
    }

    static class PropertiesLoader {
        private final ClassLoader classLoader = UploadServiceBuilder.class.getClassLoader();

        PropertiesLoader() {
        }

        public Properties loadDefaultConfigProps() {
            Properties props = new Properties(System.getProperties());
            try (InputStream inputStream = this.classLoader.getResourceAsStream(CLIENT_CONFIG_PROPERTIES);){
                props.load(inputStream);
            }
            catch (IOException | NullPointerException e) {
                log.error(e.toString(), (Throwable)e);
                throw new Bug(String.format("Failed to load the default config '%s'", CLIENT_CONFIG_PROPERTIES), e);
            }
            return props;
        }
    }

    public static enum Environment {
        PRODUCTION,
        TESTING;

    }
}

