/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.util;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;

public class ObjectNamesRetriever {
    private static final String DATACENTER_TYPE = Datacenter.class.getSimpleName();
    private static final String DATASTORE_TYPE = Datastore.class.getSimpleName();
    private static final String DS_CLUSTER_TYPE = StoragePod.class.getSimpleName();
    private static final String CLUSTER_TYPE = ClusterComputeResource.class.getSimpleName();
    private static final String VM_TYPE = VirtualMachine.class.getSimpleName();
    private static final String VAPP_TYPE = VirtualApp.class.getSimpleName();
    private static final String RESOURCEPOOL_TYPE = ResourcePool.class.getSimpleName();
    private static final String FOLDER_TYPE = "Folder";
    private static final String UNIVERSAL_DC_RELATION = "dc";
    private static final String UNIVERSAL_VC_RELATION = "rootFolder";
    private static final String ALL_DATACENTERS_IN_VC_RELATION = "childrenDCs";
    private static final String ALL_DATASTORES_OF_DC_RELATION = "datastore";
    private static final String ALL_DS_CLUSTERS_OF_DC_RELATION = "storagePod";
    private static final String ALL_CLUSTERS_OF_DC_RELATION = "cluster";
    private static final String ALL_RESOURCE_POOLS_OF_DC_RELATION = "rp";
    private static final String ALL_VAPPS_OF_DC_RELATION = "vApp";
    private static final String ALL_VMS_OF_DC_RELATION = "vm";
    private static final String NAME_PROPERTY = "name";

    public static ArrayList<String> getNamesOfAllObjectsWithinDatacenter(DataService dataService, ManagedObjectReference managedObjectReference, String string, String string2) throws Exception {
        RelationalConstraint relationalConstraint;
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)managedObjectReference);
        RelationalConstraint relationalConstraint2 = null;
        String string3 = ObjectNamesRetriever.getObjectToDcRelation(string);
        if (DATACENTER_TYPE.equals(managedObjectReference.getType())) {
            relationalConstraint2 = QueryUtil.createRelationalConstraint((String)string3, (Constraint)objectIdentityConstraint, (Boolean)true, (String)string);
        } else {
            relationalConstraint = QueryUtil.createRelationalConstraint((String)UNIVERSAL_DC_RELATION, (Constraint)objectIdentityConstraint, (Boolean)true, (String)DATACENTER_TYPE);
            relationalConstraint2 = QueryUtil.createRelationalConstraint((String)string3, (Constraint)relationalConstraint, (Boolean)true, (String)string);
        }
        relationalConstraint = QueryUtil.buildQuerySpec((Constraint)relationalConstraint2, (String[])new String[]{NAME_PROPERTY});
        ResultSet resultSet = QueryUtil.getData((DataService)dataService, (QuerySpec)relationalConstraint);
        for (ResultItem resultItem : resultSet.items) {
            arrayList.add((String)resultItem.properties[0].value);
        }
        return arrayList;
    }

    private static String getObjectToDcRelation(String string) {
        if (DATASTORE_TYPE.equals(string)) {
            return ALL_DATASTORES_OF_DC_RELATION;
        }
        if (DS_CLUSTER_TYPE.equals(string)) {
            return ALL_DS_CLUSTERS_OF_DC_RELATION;
        }
        if (CLUSTER_TYPE.equals(string)) {
            return ALL_CLUSTERS_OF_DC_RELATION;
        }
        if (VM_TYPE.equals(string)) {
            return ALL_VMS_OF_DC_RELATION;
        }
        if (VAPP_TYPE.equals(string)) {
            return ALL_VAPPS_OF_DC_RELATION;
        }
        if (RESOURCEPOOL_TYPE.equals(string)) {
            return ALL_RESOURCE_POOLS_OF_DC_RELATION;
        }
        throw new IllegalArgumentException("Datacenters has no relation to the targeted type - " + string);
    }

    public static ArrayList<String> getNamesOfAllObjectsWithinVC(DataService dataService, ManagedObjectReference managedObjectReference, String string, String string2) throws Exception {
        ResultSet resultSet;
        RelationalConstraint relationalConstraint;
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)managedObjectReference);
        RelationalConstraint relationalConstraint2 = null;
        String string3 = ObjectNamesRetriever.getObjectToVCRelation(string);
        if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference)) {
            relationalConstraint2 = QueryUtil.createRelationalConstraint((String)string3, (Constraint)objectIdentityConstraint, (Boolean)true, (String)string);
        } else if (ManagedObjectUtil.isDatacenterFolder((ManagedObjectReference)managedObjectReference) || DATACENTER_TYPE.equals(managedObjectReference.getType())) {
            relationalConstraint = QueryUtil.createRelationalConstraint((String)UNIVERSAL_VC_RELATION, (Constraint)objectIdentityConstraint, (Boolean)true, (String)FOLDER_TYPE);
            relationalConstraint2 = QueryUtil.createRelationalConstraint((String)string3, (Constraint)relationalConstraint, (Boolean)true, (String)string);
        } else {
            relationalConstraint = QueryUtil.createRelationalConstraint((String)UNIVERSAL_DC_RELATION, (Constraint)objectIdentityConstraint, (Boolean)true, (String)DATACENTER_TYPE);
            resultSet = QueryUtil.createRelationalConstraint((String)UNIVERSAL_VC_RELATION, (Constraint)relationalConstraint, (Boolean)true, (String)FOLDER_TYPE);
            relationalConstraint2 = QueryUtil.createRelationalConstraint((String)string3, (Constraint)resultSet, (Boolean)true, (String)string);
        }
        relationalConstraint = QueryUtil.buildQuerySpec((Constraint)relationalConstraint2, (String[])new String[]{NAME_PROPERTY});
        resultSet = QueryUtil.getData((DataService)dataService, (QuerySpec)relationalConstraint);
        for (ResultItem resultItem : resultSet.items) {
            arrayList.add((String)resultItem.properties[0].value);
        }
        return arrayList;
    }

    private static String getObjectToVCRelation(String string) {
        if (DATACENTER_TYPE.equals(string)) {
            return ALL_DATACENTERS_IN_VC_RELATION;
        }
        throw new IllegalArgumentException("VC has no relation to the targeted type - " + string);
    }
}

