/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.util;

import com.vmware.vim.binding.impl.vmodl.MethodNameImpl;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.action.MethodActionArgument;
import com.vmware.vim.binding.vim.scheduler.AfterStartupTaskScheduler;
import com.vmware.vim.binding.vim.scheduler.DailyTaskScheduler;
import com.vmware.vim.binding.vim.scheduler.HourlyTaskScheduler;
import com.vmware.vim.binding.vim.scheduler.MonthlyByDayTaskScheduler;
import com.vmware.vim.binding.vim.scheduler.MonthlyByWeekdayTaskScheduler;
import com.vmware.vim.binding.vim.scheduler.OnceTaskScheduler;
import com.vmware.vim.binding.vim.scheduler.ScheduledTask;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskManager;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vim.scheduler.TaskScheduler;
import com.vmware.vim.binding.vim.scheduler.WeeklyTaskScheduler;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodName;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.core.model.scheduler.AfterStartupScheduler;
import com.vmware.vise.core.model.scheduler.DailyScheduler;
import com.vmware.vise.core.model.scheduler.DayOfWeek;
import com.vmware.vise.core.model.scheduler.HourlyScheduler;
import com.vmware.vise.core.model.scheduler.MonthlyByDayScheduler;
import com.vmware.vise.core.model.scheduler.MonthlyByWeekdayScheduler;
import com.vmware.vise.core.model.scheduler.OnceScheduler;
import com.vmware.vise.core.model.scheduler.Scheduler;
import com.vmware.vise.core.model.scheduler.WeekOfMonth;
import com.vmware.vise.core.model.scheduler.WeeklyScheduler;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.TypeUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.Calendar;

public class SchedulingUtil {
    private static final String RESOURCE_BUNDLE_NAME = "servercommon";
    private static String taskNameForBatchFormat;

    public static TaskState toExecutionState(TaskInfo.State state) {
        if (state.equals((Object)TaskInfo.State.running)) {
            return TaskState.RUNNING;
        }
        if (state.equals((Object)TaskInfo.State.error)) {
            return TaskState.ERROR;
        }
        if (state.equals((Object)TaskInfo.State.queued)) {
            return TaskState.QUEUED;
        }
        return TaskState.SUCCESS;
    }

    public static Scheduler toPlatformScheduler(TaskScheduler taskScheduler) {
        AfterStartupScheduler afterStartupScheduler = null;
        if (TypeUtil.isOfType((Object)taskScheduler, AfterStartupTaskScheduler.class)) {
            AfterStartupTaskScheduler afterStartupTaskScheduler = (AfterStartupTaskScheduler)taskScheduler;
            AfterStartupScheduler afterStartupScheduler2 = new AfterStartupScheduler();
            afterStartupScheduler2.minute = afterStartupTaskScheduler.minute;
            afterStartupScheduler = afterStartupScheduler2;
        } else if (TypeUtil.isOfType((Object)taskScheduler, OnceTaskScheduler.class)) {
            OnceTaskScheduler onceTaskScheduler = (OnceTaskScheduler)taskScheduler;
            OnceScheduler onceScheduler = new OnceScheduler();
            onceScheduler.runAt = onceTaskScheduler.runAt != null ? onceTaskScheduler.runAt.getTime() : null;
            afterStartupScheduler = onceScheduler;
        } else if (TypeUtil.isOfType((Object)taskScheduler, HourlyTaskScheduler.class)) {
            HourlyTaskScheduler hourlyTaskScheduler = (HourlyTaskScheduler)taskScheduler;
            HourlyScheduler hourlyScheduler = new HourlyScheduler();
            hourlyScheduler.interval = hourlyTaskScheduler.interval;
            hourlyScheduler.minute = hourlyTaskScheduler.minute;
            afterStartupScheduler = hourlyScheduler;
        } else if (TypeUtil.isOfType((Object)taskScheduler, MonthlyByDayTaskScheduler.class)) {
            MonthlyByDayTaskScheduler monthlyByDayTaskScheduler = (MonthlyByDayTaskScheduler)taskScheduler;
            MonthlyByDayScheduler monthlyByDayScheduler = new MonthlyByDayScheduler();
            monthlyByDayScheduler.interval = monthlyByDayTaskScheduler.interval;
            monthlyByDayScheduler.hour = monthlyByDayTaskScheduler.hour;
            monthlyByDayScheduler.minute = monthlyByDayTaskScheduler.minute;
            monthlyByDayScheduler.day = monthlyByDayTaskScheduler.day;
            afterStartupScheduler = monthlyByDayScheduler;
        } else if (TypeUtil.isOfType((Object)taskScheduler, MonthlyByWeekdayTaskScheduler.class)) {
            MonthlyByWeekdayTaskScheduler monthlyByWeekdayTaskScheduler = (MonthlyByWeekdayTaskScheduler)taskScheduler;
            MonthlyByWeekdayScheduler monthlyByWeekdayScheduler = new MonthlyByWeekdayScheduler();
            monthlyByWeekdayScheduler.interval = monthlyByWeekdayTaskScheduler.interval;
            monthlyByWeekdayScheduler.hour = monthlyByWeekdayTaskScheduler.hour;
            monthlyByWeekdayScheduler.minute = monthlyByWeekdayTaskScheduler.minute;
            monthlyByWeekdayScheduler.offset = SchedulingUtil.toPlatformWeekOfMonth(monthlyByWeekdayTaskScheduler.offset);
            monthlyByWeekdayScheduler.weekday = SchedulingUtil.toPlatformDayOfWeek(monthlyByWeekdayTaskScheduler.weekday);
            afterStartupScheduler = monthlyByWeekdayScheduler;
        } else if (TypeUtil.isOfType((Object)taskScheduler, WeeklyTaskScheduler.class)) {
            WeeklyTaskScheduler weeklyTaskScheduler = (WeeklyTaskScheduler)taskScheduler;
            WeeklyScheduler weeklyScheduler = new WeeklyScheduler();
            weeklyScheduler.interval = weeklyTaskScheduler.interval;
            weeklyScheduler.hour = weeklyTaskScheduler.hour;
            weeklyScheduler.minute = weeklyTaskScheduler.minute;
            weeklyScheduler.monday = weeklyTaskScheduler.monday;
            weeklyScheduler.tuesday = weeklyTaskScheduler.tuesday;
            weeklyScheduler.wednesday = weeklyTaskScheduler.wednesday;
            weeklyScheduler.thursday = weeklyTaskScheduler.thursday;
            weeklyScheduler.friday = weeklyTaskScheduler.friday;
            weeklyScheduler.saturday = weeklyTaskScheduler.saturday;
            weeklyScheduler.sunday = weeklyTaskScheduler.sunday;
            afterStartupScheduler = weeklyScheduler;
        } else if (TypeUtil.isOfType((Object)taskScheduler, DailyTaskScheduler.class)) {
            DailyTaskScheduler dailyTaskScheduler = (DailyTaskScheduler)taskScheduler;
            DailyScheduler dailyScheduler = new DailyScheduler();
            dailyScheduler.interval = dailyTaskScheduler.interval;
            dailyScheduler.hour = dailyTaskScheduler.hour;
            dailyScheduler.minute = dailyTaskScheduler.minute;
            afterStartupScheduler = dailyScheduler;
        }
        if (afterStartupScheduler != null) {
            afterStartupScheduler.activeTime = taskScheduler.activeTime != null ? taskScheduler.activeTime.getTime() : null;
            afterStartupScheduler.expireTime = taskScheduler.expireTime != null ? taskScheduler.expireTime.getTime() : null;
        }
        return afterStartupScheduler;
    }

    public static WeekOfMonth toPlatformWeekOfMonth(MonthlyByWeekdayTaskScheduler.WeekOfMonth weekOfMonth) {
        switch (weekOfMonth) {
            case first: {
                return WeekOfMonth.first;
            }
            case second: {
                return WeekOfMonth.second;
            }
            case third: {
                return WeekOfMonth.third;
            }
            case fourth: {
                return WeekOfMonth.fourth;
            }
            case last: {
                return WeekOfMonth.last;
            }
        }
        return WeekOfMonth.first;
    }

    public static DayOfWeek toPlatformDayOfWeek(MonthlyByWeekdayTaskScheduler.DayOfWeek dayOfWeek) {
        switch (dayOfWeek) {
            case monday: {
                return DayOfWeek.monday;
            }
            case tuesday: {
                return DayOfWeek.tuesday;
            }
            case wednesday: {
                return DayOfWeek.wednesday;
            }
            case thursday: {
                return DayOfWeek.thursday;
            }
            case friday: {
                return DayOfWeek.friday;
            }
            case saturday: {
                return DayOfWeek.saturday;
            }
            case sunday: {
                return DayOfWeek.sunday;
            }
        }
        return DayOfWeek.monday;
    }

    public static TaskScheduler toVcScheduler(Scheduler scheduler) {
        AfterStartupTaskScheduler afterStartupTaskScheduler = null;
        if (TypeUtil.isOfType((Object)scheduler, AfterStartupScheduler.class)) {
            AfterStartupScheduler afterStartupScheduler = (AfterStartupScheduler)scheduler;
            AfterStartupTaskScheduler afterStartupTaskScheduler2 = new AfterStartupTaskScheduler();
            afterStartupTaskScheduler2.minute = afterStartupScheduler.minute;
            afterStartupTaskScheduler = afterStartupTaskScheduler2;
        } else if (TypeUtil.isOfType((Object)scheduler, OnceScheduler.class)) {
            OnceScheduler onceScheduler = (OnceScheduler)scheduler;
            OnceTaskScheduler onceTaskScheduler = new OnceTaskScheduler();
            if (onceScheduler.runAt != null) {
                onceTaskScheduler.runAt = Calendar.getInstance();
                onceTaskScheduler.runAt.setTime(onceScheduler.runAt);
            }
            afterStartupTaskScheduler = onceTaskScheduler;
        } else if (TypeUtil.isOfType((Object)scheduler, HourlyScheduler.class)) {
            HourlyScheduler hourlyScheduler = (HourlyScheduler)scheduler;
            HourlyTaskScheduler hourlyTaskScheduler = new HourlyTaskScheduler();
            hourlyTaskScheduler.interval = hourlyScheduler.interval;
            hourlyTaskScheduler.minute = hourlyScheduler.minute;
            afterStartupTaskScheduler = hourlyTaskScheduler;
        } else if (TypeUtil.isOfType((Object)scheduler, MonthlyByDayScheduler.class)) {
            MonthlyByDayScheduler monthlyByDayScheduler = (MonthlyByDayScheduler)scheduler;
            MonthlyByDayTaskScheduler monthlyByDayTaskScheduler = new MonthlyByDayTaskScheduler();
            monthlyByDayTaskScheduler.interval = monthlyByDayScheduler.interval;
            monthlyByDayTaskScheduler.hour = monthlyByDayScheduler.hour;
            monthlyByDayTaskScheduler.minute = monthlyByDayScheduler.minute;
            monthlyByDayTaskScheduler.day = monthlyByDayScheduler.day;
            afterStartupTaskScheduler = monthlyByDayTaskScheduler;
        } else if (TypeUtil.isOfType((Object)scheduler, MonthlyByWeekdayScheduler.class)) {
            MonthlyByWeekdayScheduler monthlyByWeekdayScheduler = (MonthlyByWeekdayScheduler)scheduler;
            MonthlyByWeekdayTaskScheduler monthlyByWeekdayTaskScheduler = new MonthlyByWeekdayTaskScheduler();
            monthlyByWeekdayTaskScheduler.interval = monthlyByWeekdayScheduler.interval;
            monthlyByWeekdayTaskScheduler.hour = monthlyByWeekdayScheduler.hour;
            monthlyByWeekdayTaskScheduler.minute = monthlyByWeekdayScheduler.minute;
            monthlyByWeekdayTaskScheduler.offset = SchedulingUtil.toVcWeekOfMonth(monthlyByWeekdayScheduler.offset);
            monthlyByWeekdayTaskScheduler.weekday = SchedulingUtil.toVcDayOfWeek(monthlyByWeekdayScheduler.weekday);
            afterStartupTaskScheduler = monthlyByWeekdayTaskScheduler;
        } else if (TypeUtil.isOfType((Object)scheduler, WeeklyScheduler.class)) {
            WeeklyScheduler weeklyScheduler = (WeeklyScheduler)scheduler;
            WeeklyTaskScheduler weeklyTaskScheduler = new WeeklyTaskScheduler();
            weeklyTaskScheduler.interval = weeklyScheduler.interval;
            weeklyTaskScheduler.hour = weeklyScheduler.hour;
            weeklyTaskScheduler.minute = weeklyScheduler.minute;
            weeklyTaskScheduler.monday = weeklyScheduler.monday;
            weeklyTaskScheduler.tuesday = weeklyScheduler.tuesday;
            weeklyTaskScheduler.wednesday = weeklyScheduler.wednesday;
            weeklyTaskScheduler.thursday = weeklyScheduler.thursday;
            weeklyTaskScheduler.friday = weeklyScheduler.friday;
            weeklyTaskScheduler.saturday = weeklyScheduler.saturday;
            weeklyTaskScheduler.sunday = weeklyScheduler.sunday;
            afterStartupTaskScheduler = weeklyTaskScheduler;
        } else if (TypeUtil.isOfType((Object)scheduler, DailyScheduler.class)) {
            DailyScheduler dailyScheduler = (DailyScheduler)scheduler;
            DailyTaskScheduler dailyTaskScheduler = new DailyTaskScheduler();
            dailyTaskScheduler.interval = dailyScheduler.interval;
            dailyTaskScheduler.hour = dailyScheduler.hour;
            dailyTaskScheduler.minute = dailyScheduler.minute;
            afterStartupTaskScheduler = dailyTaskScheduler;
        }
        if (afterStartupTaskScheduler != null) {
            if (scheduler.activeTime != null) {
                afterStartupTaskScheduler.activeTime = Calendar.getInstance();
                afterStartupTaskScheduler.activeTime.setTime(scheduler.activeTime);
            }
            if (scheduler.expireTime != null) {
                afterStartupTaskScheduler.expireTime = Calendar.getInstance();
                afterStartupTaskScheduler.expireTime.setTime(scheduler.expireTime);
            }
        }
        return afterStartupTaskScheduler;
    }

    public static MonthlyByWeekdayTaskScheduler.WeekOfMonth toVcWeekOfMonth(WeekOfMonth weekOfMonth) {
        switch (weekOfMonth) {
            case first: {
                return MonthlyByWeekdayTaskScheduler.WeekOfMonth.first;
            }
            case second: {
                return MonthlyByWeekdayTaskScheduler.WeekOfMonth.second;
            }
            case third: {
                return MonthlyByWeekdayTaskScheduler.WeekOfMonth.third;
            }
            case fourth: {
                return MonthlyByWeekdayTaskScheduler.WeekOfMonth.fourth;
            }
            case last: {
                return MonthlyByWeekdayTaskScheduler.WeekOfMonth.last;
            }
        }
        return MonthlyByWeekdayTaskScheduler.WeekOfMonth.first;
    }

    public static MonthlyByWeekdayTaskScheduler.DayOfWeek toVcDayOfWeek(DayOfWeek dayOfWeek) {
        switch (dayOfWeek) {
            case monday: {
                return MonthlyByWeekdayTaskScheduler.DayOfWeek.monday;
            }
            case tuesday: {
                return MonthlyByWeekdayTaskScheduler.DayOfWeek.tuesday;
            }
            case wednesday: {
                return MonthlyByWeekdayTaskScheduler.DayOfWeek.wednesday;
            }
            case thursday: {
                return MonthlyByWeekdayTaskScheduler.DayOfWeek.thursday;
            }
            case friday: {
                return MonthlyByWeekdayTaskScheduler.DayOfWeek.friday;
            }
            case saturday: {
                return MonthlyByWeekdayTaskScheduler.DayOfWeek.saturday;
            }
            case sunday: {
                return MonthlyByWeekdayTaskScheduler.DayOfWeek.sunday;
            }
        }
        return MonthlyByWeekdayTaskScheduler.DayOfWeek.monday;
    }

    public static ScheduledTaskSpec newVcScheduledTaskSpec(com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduledTaskSpec) {
        ScheduledTaskSpec scheduledTaskSpec2 = new ScheduledTaskSpec();
        scheduledTaskSpec2.name = MixedUtil.escapeVimEntityNameSpecialChars((String)scheduledTaskSpec.name);
        scheduledTaskSpec2.enabled = scheduledTaskSpec.enabled;
        scheduledTaskSpec2.notification = scheduledTaskSpec.notification;
        scheduledTaskSpec2.description = scheduledTaskSpec.description != null ? scheduledTaskSpec.description : "";
        scheduledTaskSpec2.scheduler = SchedulingUtil.toVcScheduler((Scheduler)scheduledTaskSpec.recurrence);
        return scheduledTaskSpec2;
    }

    public static MethodAction newMethodAction(String string, Object ... objectArray) {
        MethodAction methodAction = new MethodAction();
        methodAction.setName((MethodName)new MethodNameImpl(string));
        if (objectArray == null || objectArray.length == 0) {
            return methodAction;
        }
        MethodActionArgument[] methodActionArgumentArray = new MethodActionArgument[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            methodActionArgumentArray[i] = new MethodActionArgument(objectArray[i]);
        }
        methodAction.setArgument(methodActionArgumentArray);
        return methodAction;
    }

    public static ManagedObjectReference createVcScheduledTask(DataService dataService, ManagedObjectReference managedObjectReference, ScheduledTaskSpec scheduledTaskSpec) throws Exception {
        ScheduledTaskManager scheduledTaskManager = SchedulingUtil.getScheduledTaskManager(managedObjectReference);
        ManagedObjectReference managedObjectReference2 = scheduledTaskManager.create(managedObjectReference, scheduledTaskSpec);
        QueryUtil.waitUntilSearchable((DataService)dataService, (Object)managedObjectReference2, (String[])new String[]{"info"});
        return managedObjectReference2;
    }

    public static ManagedObjectReference createVcScheduledTaskForObject(DataService dataService, ManagedObjectReference managedObjectReference, ScheduledTaskSpec scheduledTaskSpec) throws Exception {
        ScheduledTaskManager scheduledTaskManager = SchedulingUtil.getScheduledTaskManager(managedObjectReference);
        ManagedObjectReference managedObjectReference2 = scheduledTaskManager.createObjectScheduledTask(managedObjectReference, scheduledTaskSpec);
        QueryUtil.waitUntilSearchable((DataService)dataService, (Object)managedObjectReference2, (String[])new String[]{"info"});
        return managedObjectReference2;
    }

    private static ScheduledTaskManager getScheduledTaskManager(ManagedObjectReference managedObjectReference) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)managedObjectReference.getServerGuid());
        ManagedObjectReference managedObjectReference2 = vcService.getServiceInstance().getContent().scheduledTaskManager;
        return (ScheduledTaskManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference2);
    }

    public static String formatTaskNameForBatch(String string, int n, int n2) {
        if (n < 0 || n2 <= 1) {
            return string;
        }
        if (taskNameForBatchFormat == null) {
            taskNameForBatchFormat = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)"scheduling.taskNameFormatForBatch", (ClassLoader)SchedulingUtil.class.getClassLoader());
        }
        return String.format(taskNameForBatchFormat, string, n + 1);
    }

    public static ManagedObjectReference updateVcScheduledTask(com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduledTaskSpec, ScheduledTaskSpec scheduledTaskSpec2) throws Exception {
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)scheduledTaskSpec.scheduledTask;
        ScheduledTask scheduledTask = (ScheduledTask)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        scheduledTask.reconfigure(scheduledTaskSpec2);
        return managedObjectReference;
    }
}

