/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.reporting;

import com.vmware.vise.reporting.DataSource;
import com.vmware.vise.reporting.ReportDef;
import com.vmware.vise.reporting.ReportGenerator;
import com.vmware.vise.reporting.ReportingException;
import com.vmware.vise.reporting.SubReport;
import com.vmware.vise.reporting.util.Logger;
import com.vmware.vise.reporting.util.Utils;
import com.vmware.vise.util.io.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.logging.Log;

public class ReportGeneratorImpl
implements ReportGenerator {
    private static final String COMPILED_SUBREPORTS_PREFIX = "SUBREPORT_";
    private static final String SUBREPORT_DATASOURCE_PREFIX = "SUB_DATASOURCE_";
    private static final String SUBREPORT_CONNECTION_PREFIX = "SUB_CONNECTION_";
    private static final String JRXML_FORMAT = "jrxml";
    private static final String JASPER_DESIGN_FORMAT = "jasperdesign";
    private static Log _log = Logger.getLog(ReportGeneratorImpl.class);

    @Override
    public File generate(ReportDef reportDef, Map<String, Object> map) {
        Serializable serializable;
        Properties properties;
        String string;
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("Report: " + reportDef.getName() + ", with parameters:\n" + Logger.dump(map)));
        }
        if ((string = (properties = reportDef.getManifest()).getProperty("DataSource")) != null) {
            try {
                serializable = Class.forName(string);
                map.put("REPORT_DATA_SOURCE", ((Class)serializable).newInstance());
            }
            catch (Exception exception) {
                throw new ReportingException("Could not instantiate the DataSource object: " + string);
            }
        }
        JasperPrint jasperPrint = this.createJasperPrint(reportDef, map);
        String string2 = (String)map.get("com_vmware_reporting_FORMAT");
        assert (string2 != null) : "FORMAT parameter must be passed";
        JRExporter jRExporter = this.getExporter(string2);
        serializable = this.doGenerateFile(jasperPrint, jRExporter, (Map)map.get("com_vmware_reporting_EXPORTER_PARAMS"));
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("File: " + ((File)serializable).getAbsolutePath()));
        }
        return serializable;
    }

    @Override
    public String[] getSupportedReportingFormats() {
        return new String[]{JRXML_FORMAT, JASPER_DESIGN_FORMAT};
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File doGenerateFile(JasperPrint jasperPrint, JRExporter jRExporter, Map<String, Object> map) {
        Object object;
        block9: {
            FileOutputStream fileOutputStream = null;
            try {
                File file = File.createTempFile(UUID.randomUUID().toString(), this.getSuffix(jRExporter));
                if (map != null) {
                    jRExporter.setParameters(map);
                }
                jRExporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                if (jRExporter instanceof JRCsvExporter) {
                    fileOutputStream = new FileOutputStream(file);
                    object = new byte[]{-17, -69, -65};
                    fileOutputStream.write((byte[])object);
                    jRExporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)fileOutputStream);
                    jRExporter.exportReport();
                } else {
                    jRExporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)file);
                    jRExporter.exportReport();
                }
                object = file;
                if (fileOutputStream == null) break block9;
            }
            catch (IOException iOException) {
                try {
                    _log.fatal((Object)"I/O problem: possibly unable to create temporary file", (Throwable)iOException);
                    throw new ReportingException(iOException);
                    catch (JRException jRException) {
                        _log.fatal((Object)"Unable to export the JasperPrint object.", (Throwable)jRException);
                        throw new ReportingException((Exception)((Object)jRException));
                    }
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        StreamUtil.close(fileOutputStream);
                    }
                    throw throwable;
                }
            }
            StreamUtil.close((Closeable)fileOutputStream);
        }
        return object;
    }

    private JasperPrint createJasperPrint(ReportDef reportDef, Map<String, Object> map) {
        try {
            JasperPrint jasperPrint;
            JasperDesign jasperDesign;
            boolean bl = map.containsKey("REPORT_DATA_SOURCE");
            boolean bl2 = map.containsKey("REPORT_CONNECTION");
            assert (map.containsKey("com_vmware_reporting_FORMAT")) : "No FORMAT is provided.";
            String string = reportDef.getManifest().getProperty("REPORTING_DEFINITION_FORMAT");
            if (JASPER_DESIGN_FORMAT.equals(string)) {
                jasperDesign = this.inputStreamToJasperDesign(reportDef.getReportDefinition());
            } else if (JRXML_FORMAT.equals(string)) {
                jasperDesign = JRXmlLoader.load((InputStream)reportDef.getReportDefinition());
            } else {
                throw new ReportingException(String.format("The format:%s is not supported.", string));
            }
            this.transform(jasperDesign, reportDef, map);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            if (bl) {
                Object object = map.get("REPORT_DATA_SOURCE");
                JRDataSource jRDataSource = null;
                if (object instanceof JRDataSource) {
                    jRDataSource = (JRDataSource)object;
                } else if (object instanceof DataSource) {
                    jRDataSource = Utils.fromDataSource((DataSource)object);
                } else {
                    throw new IllegalArgumentException("The data source parameter is of unsupported type: " + object.toString());
                }
                jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)jRDataSource);
            } else if (bl2) {
                Connection connection = (Connection)map.get("REPORT_CONNECTION");
                jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (Connection)connection);
            } else {
                jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map);
            }
            return jasperPrint;
        }
        catch (JRException jRException) {
            _log.fatal((Object)"Unable to fill the JasperPrint object.", (Throwable)jRException);
            throw new ReportingException((Exception)((Object)jRException));
        }
    }

    private JasperDesign inputStreamToJasperDesign(InputStream inputStream) {
        JasperDesign jasperDesign = null;
        try {
            jasperDesign = (JasperDesign)JRLoader.loadObject((InputStream)inputStream);
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
        }
        return jasperDesign;
    }

    private void transform(JasperDesign jasperDesign, ReportDef reportDef, Map<String, Object> map) throws JRException {
        Object object;
        Object object2;
        String string;
        String string2;
        if (jasperDesign.getResourceBundle() != null) {
            _log.info((Object)"The use of 'resourceBundle' instruction is not allowed with vireporting-lib, and will be removed.");
            jasperDesign.setResourceBundle(null);
        }
        jasperDesign.setWhenResourceMissingType((byte)3);
        for (JRDesignElement jRDesignElement : Utils.findElementsByType(jasperDesign, JRDesignImage.class)) {
            JRDesignImage jRDesignImage = (JRDesignImage)jRDesignElement;
            JRDesignExpression jRDesignExpression = (JRDesignExpression)jRDesignImage.getExpression();
            if (!jRDesignExpression.getValueClassName().equals("java.io.InputStream")) continue;
            string2 = UUID.randomUUID().toString();
            string = jRDesignExpression.getText();
            try {
                object2 = reportDef.getResource(string);
                map.put(string2, object2);
                object = "$P{REPORT_PARAMETERS_MAP}.get(\"" + string2 + "\")";
                jRDesignExpression.setText((String)object);
            }
            catch (IOException iOException) {
                throw new ReportingException("Could not load image resource for: " + string);
            }
        }
        boolean bl = map.containsKey("com_vmware_reporting_SUBREPORT_DATA_SOURCE");
        boolean bl2 = map.containsKey("REPORT_CONNECTION");
        for (JRDesignElement jRDesignElement : Utils.findElementsByType(jasperDesign, JRDesignSubreport.class)) {
            String string3;
            Object object3;
            string2 = (JRDesignSubreport)jRDesignElement;
            string = (JRDesignExpression)string2.getExpression();
            if (!string.getValueClassName().equals("net.sf.jasperreports.engine.JasperReport")) continue;
            object2 = string.getText();
            object = new SubReport(reportDef, (String)object2);
            JasperDesign jasperDesign2 = JRXmlLoader.load((InputStream)((SubReport)object).getReportDefinition());
            this.transform(jasperDesign2, reportDef, map);
            JRDesignExpression jRDesignExpression = new JRDesignExpression();
            jRDesignExpression.setText("new HashMap($P{REPORT_PARAMETERS_MAP})");
            jRDesignExpression.setValueClassName("java.util.Map");
            string2.setParametersMapExpression((JRExpression)jRDesignExpression);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign2);
            _log.debug((Object)("Subreport '" + (String)object2 + "' added to internal subreports map"));
            String string4 = COMPILED_SUBREPORTS_PREFIX + (String)object2;
            string.setText("$P{REPORT_PARAMETERS_MAP}.get(\"" + string4 + "\")");
            map.put(string4, jasperReport);
            JRDesignExpression jRDesignExpression2 = (JRDesignExpression)string2.getDataSourceExpression();
            if (jRDesignExpression2 != null) {
                object3 = "com.vmware.vim.reporting.util.Utils.ensureJRDataSource(" + jRDesignExpression2.getText().trim() + ")";
                jRDesignExpression2.setText((String)object3);
                continue;
            }
            if (bl) {
                object3 = (DataSource)((Map)map.get("com_vmware_reporting_SUBREPORT_DATA_SOURCE")).get(object2);
                assert (object3 != null) : "No datasource for Subreport '" + (String)object2 + "' has been provided";
                string3 = SUBREPORT_DATASOURCE_PREFIX + (String)object2;
                map.put(string3, Utils.fromDataSource((DataSource)object3));
                jRDesignExpression2 = new JRDesignExpression();
                jRDesignExpression2.setText("$P{REPORT_PARAMETERS_MAP}.get(\"" + string3 + "\")");
                jRDesignExpression2.setValueClass(JRDataSource.class);
                string2.setDataSourceExpression((JRExpression)jRDesignExpression2);
                continue;
            }
            if (string2.getConnectionExpression() != null || !bl2) continue;
            object3 = (Connection)map.get("REPORT_CONNECTION");
            string3 = SUBREPORT_CONNECTION_PREFIX + (String)object2;
            map.put(string3, object3);
            JRDesignExpression jRDesignExpression3 = new JRDesignExpression();
            jRDesignExpression3.setText("$P{REPORT_PARAMETERS_MAP}.get(\"" + string3 + "\")");
            jRDesignExpression3.setValueClass(Connection.class);
            string2.setConnectionExpression((JRExpression)jRDesignExpression3);
        }
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("JRXML for '" + jasperDesign.getName() + "' after all transforms:"));
            _log.trace((Object)JRXmlWriter.writeReport((JRReport)jasperDesign, (String)"UTF-8"));
        }
    }

    private JRExporter getExporter(String string) {
        if ((string = string.toUpperCase(Locale.ENGLISH)).equals("PDF")) {
            return new JRPdfExporter();
        }
        if (string.equals("XLS")) {
            return new JRXlsExporter();
        }
        if (string.equals("CSV")) {
            return new JRCsvExporter();
        }
        if (string.equals("XML")) {
            return new JRXmlExporter();
        }
        if (string.equals("HTML")) {
            return new JRHtmlExporter();
        }
        _log.fatal((Object)"Input error: unexpected format value.");
        throw new ReportingException("Unsupported output format '" + string + "'");
    }

    private String getSuffix(JRExporter jRExporter) {
        if (jRExporter instanceof JRPdfExporter) {
            return ".pdf";
        }
        if (jRExporter instanceof JRXlsExporter) {
            return ".xls";
        }
        if (jRExporter instanceof JRCsvExporter) {
            return ".csv";
        }
        if (jRExporter instanceof JRXmlExporter) {
            return ".xml";
        }
        if (jRExporter instanceof JRHtmlExporter) {
            return ".html";
        }
        _log.fatal((Object)"Programming error: unexpected instance of JRExporter");
        throw new ReportingException("Unsupported exporter '" + jRExporter.getClass() + "'");
    }
}

