/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.reporting.service.data;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.reporting.service.DownloadService;
import com.vmware.vise.reporting.service.data.Downloadable;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;

public class DownloadableDataProviderAdapter
implements DataProviderAdapter {
    public static final String DOWNLOADABLE_TYPE = Downloadable.class.getSimpleName();
    private DownloadService _downloadService;

    public DownloadableDataProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, DownloadService downloadService) {
        this._downloadService = downloadService;
        dataServiceExtensionRegistry.registerDataAdapter((DataProviderAdapter)this, this.getProvidedTypes());
    }

    private String[] getProvidedTypes() {
        return new String[]{DOWNLOADABLE_TYPE};
    }

    public Response getData(RequestSpec requestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            resultSetArray[i] = this.processQuery(querySpecArray[i]);
        }
        Response response = new Response();
        response.resultSet = resultSetArray;
        return response;
    }

    private ResultSet processQuery(QuerySpec querySpec) {
        if (querySpec == null || querySpec.resourceSpec == null || querySpec.resourceSpec.constraint == null) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        resultSet.queryName = querySpec.name;
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            URI uRI = (URI)objectIdentityConstraint.target;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = this._downloadService.getDownlodable(DefaultUriSchemeUtil.getId((URI)uRI)) != null ? uRI : null;
            resultSet.items = new ResultItem[]{resultItem};
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid QuerySpec");
            resultSet.error = illegalArgumentException;
        }
        return resultSet;
    }
}

