/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.reporting.service.data;

import com.vmware.vise.reporting.service.data.Downloadable;
import com.vmware.vise.reporting.service.data.FileDownloadable;
import java.io.File;
import java.util.Calendar;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DownloadableObjectMap {
    private final ConcurrentMap<String, Downloadable> _downloadableByUrl = new ConcurrentHashMap<String, Downloadable>();

    public Downloadable putIfAbsent(String string, Downloadable downloadable) {
        if (string == null) {
            return null;
        }
        Downloadable downloadable2 = this._downloadableByUrl.putIfAbsent(string, downloadable);
        return downloadable2;
    }

    public Downloadable get(String string) {
        if (string == null) {
            return null;
        }
        Downloadable downloadable = this.getInternal(string);
        return downloadable;
    }

    public Downloadable remove(String string) {
        if (string == null || !this.containsKey(string)) {
            return null;
        }
        Downloadable downloadable = this.deleteDownloadableInternal(string);
        return downloadable;
    }

    public boolean containsKey(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = this._downloadableByUrl.containsKey(string);
        return bl;
    }

    public void removeExpiredDownloadables(long l) {
        long l2 = l * 1000L;
        long l3 = Calendar.getInstance().getTimeInMillis();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this._downloadableByUrl.keySet()) {
            Downloadable downloadable = this.getInternal(string);
            long l4 = downloadable.getCreationTime();
            if (l3 - l4 < l2) continue;
            hashSet.add(string);
        }
        for (String string : hashSet) {
            this.deleteDownloadableInternal(string);
        }
    }

    private Downloadable getInternal(String string) {
        assert (string != null);
        Downloadable downloadable = (Downloadable)this._downloadableByUrl.get(string);
        if (downloadable != null) {
            return downloadable;
        }
        FileDownloadable fileDownloadable = new FileDownloadable(new File(""));
        downloadable = this._downloadableByUrl.putIfAbsent(string, fileDownloadable);
        if (downloadable == null) {
            downloadable = fileDownloadable;
        }
        return downloadable;
    }

    private Downloadable deleteDownloadableInternal(String string) {
        assert (string != null);
        Downloadable downloadable = this.getInternal(string);
        boolean bl = downloadable.delete();
        if (bl) {
            Downloadable downloadable2 = (Downloadable)this._downloadableByUrl.remove(string);
            return downloadable2;
        }
        return null;
    }
}

