/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.reporting.service.data;

import com.vmware.vise.reporting.service.data.Downloadable;
import com.vmware.vise.reporting.util.Logger;
import com.vmware.vise.util.io.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;

public class FileDownloadable
implements Downloadable {
    private static Log _log = Logger.getLog(FileDownloadable.class);
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._readWriteLock.readLock();
    private final Lock _writeLock = this._readWriteLock.writeLock();
    private File _file;

    public FileDownloadable(File file) {
        this._file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPayload() {
        if (!this._readLock.tryLock() || this._file == null || !this._file.exists()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = null;
            byte[] byArray = null;
            try {
                fileInputStream = new FileInputStream(this._file);
                long l = this._file.length();
                if (l > Integer.MAX_VALUE) {
                    _log.error((Object)"File size beyond the limit: larger than 4GB.");
                }
                byArray = new byte[(int)l];
                fileInputStream.read(byArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                _log.debug((Object)fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                _log.debug((Object)iOException.toString());
            }
            finally {
                if (fileInputStream != null) {
                    StreamUtil.close((Closeable)fileInputStream);
                }
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMimeType() {
        if (!this._readLock.tryLock() || this._file == null || !this._file.exists()) {
            return "";
        }
        try {
            String string = "text/csv";
            return string;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        if (!this._readLock.tryLock() || this._file == null || !this._file.exists()) {
            return "";
        }
        try {
            String string = this._file.getName();
            return string;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCreationTime() {
        if (!this._readLock.tryLock() || this._file == null || !this._file.exists()) {
            return -1L;
        }
        try {
            long l = this._file.lastModified();
            return l;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete() {
        if (!this._writeLock.tryLock() || this._file == null || !this._file.exists()) {
            return false;
        }
        try {
            if (this._file.canWrite() && this._file.isFile()) {
                boolean bl = this._file.delete();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._writeLock.unlock();
        }
    }
}

