/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.cimmonitor.http.impl;

import com.vmware.vim.cimmonitor.http.CimMonitorHttpService;
import com.vmware.vim.cimmonitor.http.HttpCimException;
import com.vmware.vim.cimmonitor.http.Util;
import com.vmware.vim.cimmonitor.http.impl.CimHttpClientBuilder;
import com.vmware.vim.cimmonitor.http.impl.DefaultCimHttpGetBuilder;
import com.vmware.vsphere.client.cimmonitor.util.CimMonitorUtil;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;

public class CimLegacyVcHttpService
implements CimMonitorHttpService {
    private static final Log _logger = LogFactory.getLog(CimLegacyVcHttpService.class);
    private String _serverGuid;
    private URL _serviceUrl;

    public CimLegacyVcHttpService(String serverGuid, URL serviceUrl) {
        this._serverGuid = serverGuid;
        this._serviceUrl = serviceUrl;
    }

    @Override
    public String getHostData(String hostId, String vcSessionId) throws HttpCimException {
        return this.executeRequest(hostId, vcSessionId, "getHostData");
    }

    @Override
    public void refreshHost(String hostId, String vcSessionId) throws HttpCimException {
        this.executeRequest(hostId, vcSessionId, "refreshHost");
    }

    @Override
    public void resetHostSensors(String hostId, String vcSessionId) throws HttpCimException {
        this.executeRequest(hostId, vcSessionId, "resetHostSensors");
    }

    @Override
    public void resetEventLog(String hostId, String vcSessionId) throws HttpCimException {
        this.executeRequest(hostId, vcSessionId, "resetEventLog");
    }

    private String executeRequest(String hostId, String vcSessionId, String operation) throws HttpCimException {
        HttpClient client = null;
        String responseBody = null;
        try {
            HttpGet method = this.getHttpGet(hostId, vcSessionId, operation);
            client = this.getHttpClient();
            BasicResponseHandler handler = new BasicResponseHandler();
            responseBody = (String)client.execute((HttpUriRequest)method, (ResponseHandler)handler);
            HttpCimException.Id errorId = Util.getHttpCimErrorId(operation, responseBody);
            if (errorId != null) {
                _logger.error((Object)("CIM request returned error." + System.getProperty("line.separator") + responseBody));
                throw new HttpCimException(errorId, responseBody);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to execute CIM request. ", (Throwable)exception);
            throw new HttpCimException(null, CimMonitorUtil.getLocalizedString("httpError"));
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
        }
        return responseBody;
    }

    private HttpGet getHttpGet(String hostId, String vcSessionId, String operation) {
        DefaultCimHttpGetBuilder builder = new DefaultCimHttpGetBuilder();
        builder.setServiceUrl(this._serviceUrl);
        builder.setHostId(hostId);
        builder.setVcSessionId(vcSessionId);
        builder.setOperation(operation);
        return builder.getHttpGet();
    }

    private HttpClient getHttpClient() {
        CimHttpClientBuilder builder = new CimHttpClientBuilder();
        builder.setSchemeName(this._serviceUrl.getProtocol());
        builder.setSchemePort(this._serviceUrl.getPort());
        builder.setThumbprint(Util.getThumbprint(this._serverGuid));
        return builder.getHttpClient();
    }
}

