/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cimmonitor.impl;

import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.cis.cm.site.Folder;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMSServiceLocator {
    private static final String PRODUCT_ID = "com.vmware.vws";
    private static final String TYPE_ID = "vws.health";
    private static final String VWS_HEALTH_ENDPOINT_TYPE_ID = "vws.health";
    private static final Log _logger = LogFactory.getLog(CMSServiceLocator.class);
    private ComponentManagerService _cmService;

    public CMSServiceLocator(ComponentManagerService cms) {
        this._cmService = cms;
    }

    public URL getCMSUrl(String vcServerGuid) {
        try {
            SearchCriteriaImpl sc = new SearchCriteriaImpl();
            ServiceTypeImpl sType = new ServiceTypeImpl(PRODUCT_ID, "vws.health");
            sc.setServiceType((ServiceType)sType);
            Folder vcCmFolder = this.getVcCmFolder(vcServerGuid);
            sc.setFolder(vcCmFolder);
            Object[] services = this._cmService.search((SearchCriteria)sc);
            if (ArrayUtil.isNullOrEmpty((Object[])services)) {
                _logger.debug((Object)"vws poller url is not registered, using vc apis.");
                return null;
            }
            if (services.length > 1) {
                _logger.error((Object)"Found more than 1 vws service.");
            }
            URL result = this.getVwsHealthEndpointURL((ServiceInfo)services[0]);
            return result;
        }
        catch (ComponentManagerFault ex) {
            _logger.error((Object)"Error when fetching vws url from Component Manager.", (Throwable)ex);
            return null;
        }
    }

    private Folder getVcCmFolder(String vcServerGuid) {
        Folder vcCmFolder = null;
        try {
            ServiceInfo vcServiceInfo = this._cmService.getService(vcServerGuid);
            vcCmFolder = vcServiceInfo.getFolder();
        }
        catch (ComponentManagerFault e) {
            _logger.error((Object)"Failed to get VC service info.", (Throwable)e);
        }
        return vcCmFolder;
    }

    private URL getVwsHealthEndpointURL(ServiceInfo vwsService) {
        ServiceEndPoint[] vwsEndpoints = vwsService.getServiceEndPoints();
        try {
            for (ServiceEndPoint se : vwsEndpoints) {
                if (!"vws.health".equalsIgnoreCase(se.getEndPointType().getTypeId())) continue;
                URI vwsURI = se.getUrl();
                _logger.debug((Object)String.format("Found vws Service from Component Manager: {0}", vwsURI));
                return vwsURI.toURL();
            }
        }
        catch (MalformedURLException ex) {
            _logger.error((Object)"Failed to extract vws service enpoint url.", (Throwable)ex);
        }
        return null;
    }
}

