/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cimmonitor.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.cimmonitor.http.HttpCimException;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.http.HttpServiceAddressLookupException;
import com.vmware.vsphere.client.cimmonitor.impl.CimMonitorFacade;
import com.vmware.vsphere.client.cimmonitor.util.CimMonitorUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CimMonitorPropertyProvider
implements PropertyProviderBean {
    private static final boolean USE_STATIC_DATA = Boolean.getBoolean("useCimTestXml");
    private static final String TEST_FILE_PATH = "cim-data.xml";
    private static final Log _logger = LogFactory.getLog(CimMonitorPropertyProvider.class);
    private CimMonitorFacade _cimMonitorFacade;

    public CimMonitorPropertyProvider(CimMonitorFacade facade) {
        this._cimMonitorFacade = facade;
    }

    @type(value="HostSystem")
    public OperationResult getCimHostData(ManagedObjectReference host) {
        OperationResult result = new OperationResult();
        result.entity = host;
        if (USE_STATIC_DATA) {
            try {
                result.result = this.getTestDataFromFile();
            }
            catch (IOException exception) {
                _logger.error((Object)"Failed to read test data!", (Throwable)exception);
            }
            return result;
        }
        try {
            result.result = this._cimMonitorFacade.getHardwareHealthData(host);
        }
        catch (HttpServiceAddressLookupException exception) {
            _logger.error((Object)"CIM HTTP service address lookup failed!");
            String key = "cimServiceAddressNotFound";
            result.error = CimMonitorUtil.getLocalizedException("cimServiceAddressNotFound");
        }
        catch (HttpCimException exception) {
            _logger.error((Object)"Failed to retrieve host data!", (Throwable)exception);
            result.error = CimMonitorUtil.getLocalizedException(exception);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to retrieve host data!", (Throwable)exception);
            result.error = CimMonitorUtil.getLocalizedException("httpError");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTestDataFromFile() throws IOException {
        StringBuilder result = new StringBuilder();
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream stream = loader.getResourceAsStream(TEST_FILE_PATH);
        if (stream != null) {
            InputStreamReader input = new InputStreamReader(stream);
            BufferedReader reader = new BufferedReader(input);
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }
            }
            catch (IOException e) {
                _logger.error((Object)"Error while reading test data!", (Throwable)e);
                String string = null;
                return string;
            }
            finally {
                stream.close();
            }
        }
        return result.toString();
    }
}

