/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim;

import com.vmware.vim.binding.vim.CustomizationSpecInfo;
import com.vmware.vim.binding.vim.CustomizationSpecItem;
import com.vmware.vim.binding.vim.fault.AlreadyExists;
import com.vmware.vim.binding.vim.fault.ConcurrentAccess;
import com.vmware.vim.binding.vim.fault.CustomizationFault;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.version.version2;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;

@managed
@versionClass(value=version2.class)
@wsdlName(value="CustomizationSpecManager")
public interface CustomizationSpecManager
extends ManagedObject {
    @readonly
    @name(value="info")
    @privilege(value="VirtualMachine.Provisioning.ReadCustSpecs")
    @versionClass(value=version2.class)
    @optional
    @list
    public void getInfo(@optional Future<CustomizationSpecInfo[]> var1);

    @name(value="info")
    public CustomizationSpecInfo[] getInfo();

    @readonly
    @name(value="encryptionKey")
    @privilege(value="System.View")
    @versionClass(value=version2.class)
    @optional
    @list
    public void getEncryptionKey(@optional Future<byte[]> var1);

    @name(value="encryptionKey")
    public byte[] getEncryptionKey();

    @versionClass(value=version2.class)
    @wsdlName(value="DoesCustomizationSpecExist")
    @privilege(value="VirtualMachine.Provisioning.ReadCustSpecs")
    public void exists(@name(value="name") @versionClass(value=version2.class) String var1, Future<Boolean> var2);

    @wsdlName(value="DoesCustomizationSpecExist")
    public boolean exists(String var1);

    @versionClass(value=version2.class)
    @wsdlName(value="GetCustomizationSpec")
    @privilege(value="VirtualMachine.Provisioning.ReadCustSpecs")
    @faults(value={"NotFound"})
    public void get(@name(value="name") @versionClass(value=version2.class) String var1, Future<CustomizationSpecItem> var2);

    @wsdlName(value="GetCustomizationSpec")
    public CustomizationSpecItem get(String var1) throws NotFound;

    @versionClass(value=version2.class)
    @wsdlName(value="CreateCustomizationSpec")
    @privilege(value="VirtualMachine.Provisioning.ModifyCustSpecs")
    @faults(value={"CustomizationFault", "AlreadyExists"})
    public void create(@name(value="item") @versionClass(value=version2.class) CustomizationSpecItem var1, Future<Void> var2);

    @wsdlName(value="CreateCustomizationSpec")
    public void create(CustomizationSpecItem var1) throws CustomizationFault, AlreadyExists;

    @versionClass(value=version2.class)
    @wsdlName(value="OverwriteCustomizationSpec")
    @privilege(value="VirtualMachine.Provisioning.ModifyCustSpecs")
    @faults(value={"CustomizationFault", "NotFound", "ConcurrentAccess"})
    public void overwrite(@name(value="item") @versionClass(value=version2.class) CustomizationSpecItem var1, Future<Void> var2);

    @wsdlName(value="OverwriteCustomizationSpec")
    public void overwrite(CustomizationSpecItem var1) throws CustomizationFault, NotFound, ConcurrentAccess;

    @versionClass(value=version2.class)
    @wsdlName(value="DeleteCustomizationSpec")
    @privilege(value="VirtualMachine.Provisioning.ModifyCustSpecs")
    @faults(value={"NotFound"})
    public void delete(@name(value="name") @versionClass(value=version2.class) String var1, Future<Void> var2);

    @wsdlName(value="DeleteCustomizationSpec")
    public void delete(String var1) throws NotFound;

    @versionClass(value=version2.class)
    @wsdlName(value="DuplicateCustomizationSpec")
    @privilege(value="VirtualMachine.Provisioning.ModifyCustSpecs")
    @faults(value={"NotFound", "AlreadyExists"})
    public void duplicate(@name(value="name") @versionClass(value=version2.class) String var1, @name(value="newName") @versionClass(value=version2.class) String var2, Future<Void> var3);

    @wsdlName(value="DuplicateCustomizationSpec")
    public void duplicate(String var1, String var2) throws NotFound, AlreadyExists;

    @versionClass(value=version2.class)
    @wsdlName(value="RenameCustomizationSpec")
    @privilege(value="VirtualMachine.Provisioning.ModifyCustSpecs")
    @faults(value={"NotFound", "AlreadyExists"})
    public void rename(@name(value="name") @versionClass(value=version2.class) String var1, @name(value="newName") @versionClass(value=version2.class) String var2, Future<Void> var3);

    @wsdlName(value="RenameCustomizationSpec")
    public void rename(String var1, String var2) throws NotFound, AlreadyExists;

    @versionClass(value=version2.class)
    @wsdlName(value="CustomizationSpecItemToXml")
    @privilege(value="System.View")
    public void specItemToXml(@name(value="item") @versionClass(value=version2.class) CustomizationSpecItem var1, Future<String> var2);

    @wsdlName(value="CustomizationSpecItemToXml")
    public String specItemToXml(CustomizationSpecItem var1);

    @versionClass(value=version2.class)
    @wsdlName(value="XmlToCustomizationSpecItem")
    @privilege(value="System.View")
    @faults(value={"CustomizationFault"})
    public void xmlToSpecItem(@name(value="specItemXml") @versionClass(value=version2.class) String var1, Future<CustomizationSpecItem> var2);

    @wsdlName(value="XmlToCustomizationSpecItem")
    public CustomizationSpecItem xmlToSpecItem(String var1) throws CustomizationFault;

    @versionClass(value=version2.class)
    @wsdlName(value="CheckCustomizationResources")
    @privilege(value="System.View")
    @faults(value={"CustomizationFault"})
    public void checkResources(@name(value="guestOs") @versionClass(value=version2.class) String var1, Future<Void> var2);

    @wsdlName(value="CheckCustomizationResources")
    public void checkResources(String var1) throws CustomizationFault;
}

