/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.UserSession;
import com.vmware.vim.binding.vim.fault.InvalidLocale;
import com.vmware.vim.binding.vim.fault.InvalidLogin;
import com.vmware.vim.binding.vim.fault.InvalidTicket;
import com.vmware.vim.binding.vim.fault.NoClientCertificate;
import com.vmware.vim.binding.vim.fault.NoHost;
import com.vmware.vim.binding.vim.fault.NoSubjectName;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.fault.NotSupportedHost;
import com.vmware.vim.binding.vim.fault.SSPIChallenge;
import com.vmware.vim.binding.vim.fault.TooManyTickets;
import com.vmware.vim.binding.vim.fault.UserNotFound;
import com.vmware.vim.binding.vim.version.version2;
import com.vmware.vim.binding.vim.version.version3;
import com.vmware.vim.binding.vim.version.version5;
import com.vmware.vim.binding.vim.version.version7;
import com.vmware.vim.binding.vim.version.version8;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.MethodName;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.fault.NotSupported;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.secret;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version2.class)
@wsdlName(value="SessionManager")
public interface SessionManager
extends ManagedObject {
    @readonly
    @name(value="sessionList")
    @privilege(value="Sessions.TerminateSession")
    @versionClass(value=version2.class)
    @optional
    @map
    public void getSessionList(@optional Future<UserSession[]> var1);

    @name(value="sessionList")
    public UserSession[] getSessionList();

    @readonly
    @name(value="currentSession")
    @privilege(value="System.Anonymous")
    @versionClass(value=version2.class)
    @optional
    public void getCurrentSession(@optional Future<UserSession> var1);

    @name(value="currentSession")
    public UserSession getCurrentSession();

    @readonly
    @name(value="message")
    @privilege(value="System.View")
    @versionClass(value=version2.class)
    @optional
    public void getMessage(@optional Future<String> var1);

    @name(value="message")
    public String getMessage();

    @readonly
    @name(value="messageLocaleList")
    @privilege(value="System.Anonymous")
    @versionClass(value=version2.class)
    @optional
    @map
    public void getMessageLocaleList(@optional Future<String[]> var1);

    @name(value="messageLocaleList")
    public String[] getMessageLocaleList();

    @readonly
    @name(value="supportedLocaleList")
    @privilege(value="System.Anonymous")
    @versionClass(value=version2.class)
    @optional
    @map
    public void getSupportedLocaleList(@optional Future<String[]> var1);

    @name(value="supportedLocaleList")
    public String[] getSupportedLocaleList();

    @readonly
    @name(value="defaultLocale")
    @privilege(value="System.Anonymous")
    @versionClass(value=version2.class)
    public void getDefaultLocale(Future<String> var1);

    @name(value="defaultLocale")
    public String getDefaultLocale();

    @versionClass(value=version2.class)
    @wsdlName(value="UpdateServiceMessage")
    @privilege(value="Sessions.GlobalMessage")
    public void updateMessage(@name(value="message") @versionClass(value=version2.class) String var1, Future<Void> var2);

    @wsdlName(value="UpdateServiceMessage")
    public void updateMessage(String var1);

    @versionClass(value=version8.class)
    @wsdlName(value="LoginByToken")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "InvalidLocale"})
    public void loginByToken(@name(value="locale") @versionClass(value=version8.class) @optional String var1, Future<UserSession> var2);

    @wsdlName(value="LoginByToken")
    public UserSession loginByToken(String var1) throws InvalidLogin, InvalidLocale;

    @versionClass(value=version2.class)
    @wsdlName(value="Login")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "InvalidLocale"})
    public void login(@name(value="userName") @versionClass(value=version2.class) String var1, @name(value="password") @versionClass(value=version2.class) @secret String var2, @name(value="locale") @versionClass(value=version2.class) @optional String var3, Future<UserSession> var4);

    @wsdlName(value="Login")
    public UserSession login(String var1, String var2, String var3) throws InvalidLogin, InvalidLocale;

    @versionClass(value=version2.class)
    @wsdlName(value="LoginBySSPI")
    @privilege(value="System.Anonymous")
    @faults(value={"SSPIChallenge", "InvalidLogin", "InvalidLocale"})
    public void loginBySSPI(@name(value="base64Token") @versionClass(value=version2.class) String var1, @name(value="locale") @versionClass(value=version2.class) @optional String var2, Future<UserSession> var3);

    @wsdlName(value="LoginBySSPI")
    public UserSession loginBySSPI(String var1, String var2) throws SSPIChallenge, InvalidLogin, InvalidLocale;

    @versionClass(value=version5.class)
    @wsdlName(value="LoginBySSLThumbprint")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"InvalidLogin", "NoClientCertificate", "UserNotFound", "InvalidLocale", "NotSupported"})
    public void loginBySSLThumbprint(@name(value="locale") @versionClass(value=version5.class) @optional String var1, Future<UserSession> var2);

    @wsdlName(value="LoginBySSLThumbprint")
    public UserSession loginBySSLThumbprint(String var1) throws InvalidLogin, NoClientCertificate, UserNotFound, InvalidLocale, NotSupported;

    @versionClass(value=version5.class)
    @wsdlName(value="LoginBySessionTicket")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"InvalidTicket", "UserNotFound", "NotSupported"})
    @Deprecated
    public void loginBySessionTicket(@name(value="ticketData") @versionClass(value=version5.class) @secret String var1, Future<UserSession> var2);

    @wsdlName(value="LoginBySessionTicket")
    @Deprecated
    public UserSession loginBySessionTicket(String var1) throws InvalidTicket, UserNotFound, NotSupported;

    @versionClass(value=version5.class)
    @wsdlName(value="AcquireSessionTicket")
    @privilege(value="System.Anonymous")
    @internal
    @faults(value={"NotFound", "TooManyTickets", "NoHost", "NotSupportedHost", "InvalidLogin"})
    @Deprecated
    public void acquireSessionTicket(@name(value="serviceKey") @versionClass(value=version5.class) @optional String var1, @secret Future<String> var2);

    @wsdlName(value="AcquireSessionTicket")
    @Deprecated
    @secret
    public String acquireSessionTicket(String var1) throws NotFound, TooManyTickets, NoHost, NotSupportedHost, InvalidLogin;

    @versionClass(value=version2.class)
    @wsdlName(value="Logout")
    @privilege(value="System.View")
    public void logout(Future<Void> var1);

    @wsdlName(value="Logout")
    public void logout();

    @versionClass(value=version2.class)
    @wsdlName(value="AcquireLocalTicket")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin"})
    public void acquireLocalTicket(@name(value="userName") @versionClass(value=version2.class) String var1, Future<LocalTicket> var2);

    @wsdlName(value="AcquireLocalTicket")
    public LocalTicket acquireLocalTicket(String var1) throws InvalidLogin;

    @versionClass(value=version7.class)
    @wsdlName(value="AcquireGenericServiceTicket")
    @privilege(value="System.Anonymous")
    public void acquireGenericServiceTicket(@name(value="spec") @versionClass(value=version7.class) ServiceRequestSpec var1, Future<GenericServiceTicket> var2);

    @wsdlName(value="AcquireGenericServiceTicket")
    public GenericServiceTicket acquireGenericServiceTicket(ServiceRequestSpec var1);

    @versionClass(value=version2.class)
    @wsdlName(value="TerminateSession")
    @privilege(value="Sessions.TerminateSession")
    @faults(value={"NotFound"})
    public void terminate(@name(value="sessionId") @versionClass(value=version2.class) @map String[] var1, Future<Void> var2);

    @wsdlName(value="TerminateSession")
    public void terminate(String[] var1) throws NotFound;

    @versionClass(value=version2.class)
    @wsdlName(value="SetLocale")
    @privilege(value="System.View")
    @faults(value={"InvalidLocale"})
    public void setLocale(@name(value="locale") @versionClass(value=version2.class) String var1, Future<Void> var2);

    @wsdlName(value="SetLocale")
    public void setLocale(String var1) throws InvalidLocale;

    @versionClass(value=version2.class)
    @wsdlName(value="LoginExtensionBySubjectName")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "InvalidLocale", "NotFound", "NoClientCertificate", "NoSubjectName"})
    @Deprecated
    public void loginExtensionBySubjectName(@name(value="extensionKey") @versionClass(value=version2.class) String var1, @name(value="locale") @versionClass(value=version2.class) @optional String var2, Future<UserSession> var3);

    @wsdlName(value="LoginExtensionBySubjectName")
    @Deprecated
    public UserSession loginExtensionBySubjectName(String var1, String var2) throws InvalidLogin, InvalidLocale, NotFound, NoClientCertificate, NoSubjectName;

    @versionClass(value=version5.class)
    @wsdlName(value="LoginExtensionByCertificate")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin", "InvalidLocale", "NoClientCertificate"})
    @Deprecated
    public void loginExtensionByCertificate(@name(value="extensionKey") @versionClass(value=version5.class) String var1, @name(value="locale") @versionClass(value=version5.class) @optional String var2, Future<UserSession> var3);

    @wsdlName(value="LoginExtensionByCertificate")
    @Deprecated
    public UserSession loginExtensionByCertificate(String var1, String var2) throws InvalidLogin, InvalidLocale, NoClientCertificate;

    @versionClass(value=version2.class)
    @wsdlName(value="ImpersonateUser")
    @privilege(value="Sessions.ImpersonateUser")
    @faults(value={"InvalidLogin", "InvalidLocale"})
    public void impersonateUser(@name(value="userName") @versionClass(value=version2.class) String var1, @name(value="locale") @versionClass(value=version2.class) @optional String var2, Future<UserSession> var3);

    @wsdlName(value="ImpersonateUser")
    public UserSession impersonateUser(String var1, String var2) throws InvalidLogin, InvalidLocale;

    @versionClass(value=version2.class)
    @wsdlName(value="SessionIsActive")
    @privilege(value="Sessions.ValidateSession")
    public void sessionIsActive(@name(value="sessionID") @versionClass(value=version2.class) String var1, @name(value="userName") @versionClass(value=version2.class) String var2, Future<Boolean> var3);

    @wsdlName(value="SessionIsActive")
    public boolean sessionIsActive(String var1, String var2);

    @versionClass(value=version3.class)
    @wsdlName(value="AcquireCloneTicket")
    @privilege(value="System.View")
    public void acquireCloneTicket(@secret Future<String> var1);

    @wsdlName(value="AcquireCloneTicket")
    @secret
    public String acquireCloneTicket();

    @versionClass(value=version3.class)
    @wsdlName(value="CloneSession")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin"})
    public void cloneSession(@name(value="cloneTicket") @versionClass(value=version3.class) @secret String var1, Future<UserSession> var2);

    @wsdlName(value="CloneSession")
    public UserSession cloneSession(String var1) throws InvalidLogin;

    @versionClass(value=version7.class)
    @wsdlName(value="SessionManagerHttpServiceRequestSpec")
    @data
    @propertyOrder(value={"method", "url"})
    public static class HttpServiceRequestSpec
    extends ServiceRequestSpec {
        private static final long serialVersionUID = 1L;
        public String method;
        public String url;

        public HttpServiceRequestSpec() {
        }

        public HttpServiceRequestSpec(String string, String string2) {
            this.method = string;
            this.url = string2;
        }

        @optional
        @versionClass(value=version7.class)
        public String getMethod() {
            return this.method;
        }

        @optional
        @versionClass(value=version7.class)
        public void setMethod(String string) {
            this.method = string;
        }

        @versionClass(value=version7.class)
        public String getUrl() {
            return this.url;
        }

        @versionClass(value=version7.class)
        public void setUrl(String string) {
            this.url = string;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(160);
            stringBuilder.append("(vim.HttpServiceRequestSpec) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("method = ");
            stringBuilder.append(this.getMethod());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("url = ");
            stringBuilder.append(this.getUrl());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version7.class)
        @wsdlName(value="SessionManagerHttpServiceRequestSpecMethod")
        public static enum Method {
            httpOptions,
            httpGet,
            httpHead,
            httpPost,
            httpPut,
            httpDelete,
            httpTrace,
            httpConnect;

        }
    }

    @versionClass(value=version8.class)
    @wsdlName(value="SessionManagerVmomiServiceRequestSpec")
    @data
    @propertyOrder(value={"method"})
    public static class VmomiServiceRequestSpec
    extends ServiceRequestSpec {
        private static final long serialVersionUID = 1L;
        public MethodName method;

        public VmomiServiceRequestSpec() {
        }

        public VmomiServiceRequestSpec(MethodName methodName) {
            this.method = methodName;
        }

        @versionClass(value=version8.class)
        public MethodName getMethod() {
            return this.method;
        }

        @versionClass(value=version8.class)
        public void setMethod(MethodName methodName) {
            this.method = methodName;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(120);
            stringBuilder.append("(vim.VmomiServiceRequestSpec) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("method = ");
            stringBuilder.append(this.getMethod());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version7.class)
    @wsdlName(value="SessionManagerServiceRequestSpec")
    @data
    public static class ServiceRequestSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(80);
            stringBuilder.append("(vim.ServiceRequestSpec) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version7.class)
    @wsdlName(value="SessionManagerGenericServiceTicket")
    @data
    @propertyOrder(value={"id", "hostName", "sslThumbprint"})
    public static class GenericServiceTicket
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String id;
        public String hostName;
        public String sslThumbprint;

        public GenericServiceTicket() {
        }

        public GenericServiceTicket(String string, String string2, String string3) {
            this.id = string;
            this.hostName = string2;
            this.sslThumbprint = string3;
        }

        @secret
        @versionClass(value=version7.class)
        public String getId() {
            return this.id;
        }

        @secret
        @versionClass(value=version7.class)
        public void setId(String string) {
            this.id = string;
        }

        @optional
        @versionClass(value=version8.class)
        public String getHostName() {
            return this.hostName;
        }

        @optional
        @versionClass(value=version8.class)
        public void setHostName(String string) {
            this.hostName = string;
        }

        @optional
        @versionClass(value=version8.class)
        public String getSslThumbprint() {
            return this.sslThumbprint;
        }

        @optional
        @versionClass(value=version8.class)
        public void setSslThumbprint(String string) {
            this.sslThumbprint = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("(vim.GenericServiceTicket) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("id = ");
            if (this.getId() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(not shown)");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("hostName = ");
            stringBuilder.append(this.getHostName());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("sslThumbprint = ");
            stringBuilder.append(this.getSslThumbprint());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="SessionManagerLocalTicket")
    @data
    @propertyOrder(value={"userName", "passwordFilePath"})
    public static class LocalTicket
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String userName;
        public String passwordFilePath;

        public LocalTicket() {
        }

        public LocalTicket(String string, String string2) {
            this.userName = string;
            this.passwordFilePath = string2;
        }

        @versionClass(value=version2.class)
        public String getUserName() {
            return this.userName;
        }

        @versionClass(value=version2.class)
        public void setUserName(String string) {
            this.userName = string;
        }

        @versionClass(value=version2.class)
        public String getPasswordFilePath() {
            return this.passwordFilePath;
        }

        @versionClass(value=version2.class)
        public void setPasswordFilePath(String string) {
            this.passwordFilePath = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(160);
            stringBuilder.append("(vim.LocalTicket) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("userName = ");
            stringBuilder.append(this.getUserName());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("passwordFilePath = ");
            stringBuilder.append(this.getPasswordFilePath());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }
}

