/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim.host;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.fault.AlreadyExists;
import com.vmware.vim.binding.vim.fault.UserNotFound;
import com.vmware.vim.binding.vim.version.version2;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.secret;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version2.class)
@wsdlName(value="HostLocalAccountManager")
public interface LocalAccountManager
extends ManagedObject {
    @versionClass(value=version2.class)
    @wsdlName(value="CreateUser")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"AlreadyExists"})
    public void createUser(@name(value="user") @versionClass(value=version2.class) AccountSpecification var1, Future<Void> var2);

    @wsdlName(value="CreateUser")
    public void createUser(AccountSpecification var1) throws AlreadyExists;

    @versionClass(value=version2.class)
    @wsdlName(value="UpdateUser")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"UserNotFound", "AlreadyExists"})
    public void updateUser(@name(value="user") @versionClass(value=version2.class) AccountSpecification var1, Future<Void> var2);

    @wsdlName(value="UpdateUser")
    public void updateUser(AccountSpecification var1) throws UserNotFound, AlreadyExists;

    @versionClass(value=version2.class)
    @wsdlName(value="CreateGroup")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"AlreadyExists"})
    @Deprecated
    public void createGroup(@name(value="group") @versionClass(value=version2.class) AccountSpecification var1, Future<Void> var2);

    @wsdlName(value="CreateGroup")
    @Deprecated
    public void createGroup(AccountSpecification var1) throws AlreadyExists;

    @versionClass(value=version2.class)
    @wsdlName(value="RemoveUser")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"UserNotFound"})
    public void removeUser(@name(value="userName") @versionClass(value=version2.class) String var1, Future<Void> var2);

    @wsdlName(value="RemoveUser")
    public void removeUser(String var1) throws UserNotFound;

    @versionClass(value=version2.class)
    @wsdlName(value="RemoveGroup")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"UserNotFound"})
    @Deprecated
    public void removeGroup(@name(value="groupName") @versionClass(value=version2.class) String var1, Future<Void> var2);

    @wsdlName(value="RemoveGroup")
    @Deprecated
    public void removeGroup(String var1) throws UserNotFound;

    @versionClass(value=version2.class)
    @wsdlName(value="AssignUserToGroup")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"UserNotFound", "AlreadyExists"})
    @Deprecated
    public void assignUserToGroup(@name(value="user") @versionClass(value=version2.class) String var1, @name(value="group") @versionClass(value=version2.class) String var2, Future<Void> var3);

    @wsdlName(value="AssignUserToGroup")
    @Deprecated
    public void assignUserToGroup(String var1, String var2) throws UserNotFound, AlreadyExists;

    @versionClass(value=version2.class)
    @wsdlName(value="UnassignUserFromGroup")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"UserNotFound"})
    @Deprecated
    public void unassignUserFromGroup(@name(value="user") @versionClass(value=version2.class) String var1, @name(value="group") @versionClass(value=version2.class) String var2, Future<Void> var3);

    @wsdlName(value="UnassignUserFromGroup")
    @Deprecated
    public void unassignUserFromGroup(String var1, String var2) throws UserNotFound;

    @versionClass(value=version2.class)
    @wsdlName(value="HostPosixAccountSpec")
    @data
    @propertyOrder(value={"posixId", "shellAccess"})
    public static class PosixAccountSpecification
    extends AccountSpecification {
        private static final long serialVersionUID = 1L;
        public Integer posixId;
        public Boolean shellAccess;

        public PosixAccountSpecification() {
        }

        public PosixAccountSpecification(String string, String string2, String string3, Integer n, Boolean bl) {
            super(string, string2, string3);
            this.posixId = n;
            this.shellAccess = bl;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public Integer getPosixId() {
            return this.posixId;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public void setPosixId(Integer n) {
            this.posixId = n;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public Boolean isShellAccess() {
            return this.shellAccess;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public Boolean getShellAccess() {
            return this.shellAccess;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public void setShellAccess(Boolean bl) {
            this.shellAccess = bl;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(280);
            stringBuilder.append("(vim.host.PosixAccountSpecification) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("id = ");
            stringBuilder.append(this.getId());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("password = ");
            if (this.getPassword() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(not shown)");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("description = ");
            stringBuilder.append(this.getDescription());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("posixId = ");
            stringBuilder.append(this.getPosixId());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("shellAccess = ");
            stringBuilder.append(this.isShellAccess());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="HostAccountSpec")
    @data
    @propertyOrder(value={"id", "password", "description"})
    public static class AccountSpecification
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String id;
        public String password;
        public String description;

        public AccountSpecification() {
        }

        public AccountSpecification(String string, String string2, String string3) {
            this.id = string;
            this.password = string2;
            this.description = string3;
        }

        @versionClass(value=version2.class)
        public String getId() {
            return this.id;
        }

        @versionClass(value=version2.class)
        public void setId(String string) {
            this.id = string;
        }

        @secret
        @optional
        @versionClass(value=version2.class)
        public String getPassword() {
            return this.password;
        }

        @secret
        @optional
        @versionClass(value=version2.class)
        public void setPassword(String string) {
            this.password = string;
        }

        @optional
        @versionClass(value=version2.class)
        public String getDescription() {
            return this.description;
        }

        @optional
        @versionClass(value=version2.class)
        public void setDescription(String string) {
            this.description = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("(vim.host.AccountSpecification) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("id = ");
            stringBuilder.append(this.getId());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("password = ");
            if (this.getPassword() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(not shown)");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("description = ");
            stringBuilder.append(this.getDescription());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }
}

