/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.adapters.vcenter;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.federation.MajorMinorVersion;
import com.vmware.cis.data.internal.adapters.pc.PcDataProvider;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProviderConnection;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.cis.data.provider.ResourceModel;
import com.vmware.vim.binding.cis.data.provider.version.internal.versions;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.exception.VmodlAlreadyLoadedException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.util.Collections;
import org.apache.commons.lang.Validate;

public final class VpxdVimQueryService {
    private static final String SERVICE_INSTANCE = "ServiceInstance";
    private static final MajorMinorVersion REFERENCE_VERSION = new MajorMinorVersion(6, 5);

    private VpxdVimQueryService() {
    }

    public static Class<?> getClientVersion() {
        return versions.CIS_DATA_PROVIDER_VERSION_STABLE;
    }

    public static Class<?> getPublicClientVersion() {
        return versions.CIS_DATA_PROVIDER_VERSION_PUBLIC;
    }

    public static void prepareVmodlContext(VmodlContext vmodlContext) {
        Validate.notNull((Object)vmodlContext);
        VmodlTypeMap vmodlTypeMap = vmodlContext.getVmodlTypeMap();
        if (vmodlTypeMap.getLoadedVmodlType(ServiceInstance.class) == null) {
            throw new IllegalArgumentException("VmodlContext does not contain VIM bindings");
        }
        if (vmodlTypeMap.getLoadedVmodlType(ResourceModel.class) != null) {
            return;
        }
        try {
            vmodlContext.loadVmodlPackages(new String[]{"com.vmware.vim.binding.cis.data.provider"}, true);
        }
        catch (VmodlAlreadyLoadedException vmodlAlreadyLoadedException) {
            // empty catch block
        }
    }

    public static QueryService createQueryService(Client vimClient) {
        Validate.notNull((Object)vimClient);
        if (VpxdVimQueryService.usePcDataProvider(vimClient)) {
            PcDataProvider pcdp = new PcDataProvider(vimClient);
            return QueryService.Builder.forProvider((DataProvider)pcdp).build();
        }
        final VmomiDataProviderConnection vimdp = new VmomiDataProviderConnection(vimClient);
        final QuerySchema schema = vimdp.getSchema();
        DataProvider dataProvider = new DataProvider(){

            public ResultSet executeQuery(Query query) {
                return vimdp.executeQuery(query);
            }

            public QuerySchema getSchema() {
                return schema;
            }
        };
        return QueryService.Builder.forProviders(Collections.singleton(dataProvider)).build();
    }

    private static boolean usePcDataProvider(Client vimClient) {
        ManagedObjectReference siMor = new ManagedObjectReference(SERVICE_INSTANCE, SERVICE_INSTANCE);
        ServiceInstance siStub = VpxdVimQueryService.createStub(vimClient, ServiceInstance.class, siMor);
        ServiceInstanceContent sic = siStub.getContent();
        String version = sic.getAbout().getVersion();
        MajorMinorVersion currentVersion = MajorMinorVersion.parseVersion(version);
        return currentVersion.compareTo(REFERENCE_VERSION) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends ManagedObject> T createStub(Client vlsiClient, Class<T> stubBindingClass, ManagedObjectReference ref) {
        assert (vlsiClient != null);
        assert (stubBindingClass != null);
        assert (ref != null);
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(PcDataProvider.class.getClassLoader());
        try {
            ManagedObject managedObject = vlsiClient.createStub(stubBindingClass, ref);
            return (T)managedObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }
}

