/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.federation;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.internal.adapters.federation.AbstractForeignKeyRouter;
import com.vmware.cis.data.internal.adapters.federation.RouterUtils;
import com.vmware.vapi.std.DynamicID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class DynamicIdForeignKeyRouter
extends AbstractForeignKeyRouter {
    @Override
    protected List<Object> tryExtractForeignKeysForInstanceId(PropertyPredicate predicate, String targetInstanceId) {
        Collection<Object> values = RouterUtils.toCollection(predicate.getComparableValue());
        ArrayList<Object> keys = new ArrayList<Object>(values.size());
        for (Object value : values) {
            if (value instanceof DynamicID && DynamicIdForeignKeyRouter.isVmodl1Type(((DynamicID)value).getType())) {
                DynamicID foreignKey = (DynamicID)value;
                String instanceId = StringUtils.substringAfterLast((String)foreignKey.getId(), (String)":");
                if (StringUtils.isEmpty((String)instanceId)) {
                    return null;
                }
                if (!targetInstanceId.equals(instanceId)) continue;
                keys.add(foreignKey);
                continue;
            }
            return null;
        }
        return keys;
    }

    private static boolean isVmodl1Type(String typename) {
        return typename.indexOf(46) == -1;
    }
}

