/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.federation;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.adapters.federation.QueryRouter;
import com.vmware.cis.data.internal.provider.merge.DefaultItemComparator;
import com.vmware.cis.data.internal.provider.merge.OrderedSequenceMergePolicy;
import com.vmware.cis.data.internal.provider.merge.ResultMergePolicy;
import com.vmware.cis.data.internal.provider.merge.SequenceMergePolicy;
import com.vmware.cis.data.internal.provider.merge.UnorderedSequenceMergePolicy;
import com.vmware.cis.data.internal.provider.util.ResultSetUtil;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyByName;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.cis.data.internal.util.QueryMarker;
import com.vmware.cis.data.internal.util.TaskExecutor;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationConnection
implements DataProvider {
    private static final Logger logger = LoggerFactory.getLogger(FederationConnection.class);
    private final QueryRouter _queryRouter;
    private final TaskExecutor _taskExecutor;
    private final Map<String, FederatedProviderInfo> _providerByServiceId;

    public FederationConnection(QueryRouter queryRouter, TaskExecutor taskExecutor, Collection<FederatedProviderInfo> providerInfos) {
        this._queryRouter = queryRouter;
        this._taskExecutor = taskExecutor;
        this._providerByServiceId = new HashMap<String, FederatedProviderInfo>(providerInfos.size());
        for (FederatedProviderInfo providerInfo : providerInfos) {
            this._providerByServiceId.put(providerInfo.getServiceInstanceUuid(), providerInfo);
        }
    }

    public ResultSet executeQuery(Query query) {
        Query queryWithSelectedSortProps = FederationConnection.adjustQueryForOrderedMerge(query);
        ResultSet resultWithSortProps = this.executeQueryWithSelectedSortProps(queryWithSelectedSortProps);
        if (queryWithSelectedSortProps == query) {
            return resultWithSortProps;
        }
        return ResultSetUtil.project((ResultSet)resultWithSortProps, (List)query.getProperties());
    }

    private ResultSet executeQueryWithSelectedSortProps(Query query) {
        ResultSet result;
        List partialResults;
        HashMap<String, Query> queryByConnectionId = new HashMap<String, Query>();
        for (String targetInstanceId : this._providerByServiceId.keySet()) {
            Query routedQuery = this._queryRouter.route(query, targetInstanceId);
            if (routedQuery == null) continue;
            queryByConnectionId.put(targetInstanceId, routedQuery);
        }
        boolean targetMultipleInstances = queryByConnectionId.size() > 1;
        ArrayList<Callable<PartialResult>> partialResultTasks = new ArrayList<Callable<PartialResult>>(queryByConnectionId.size());
        for (Map.Entry entry : queryByConnectionId.entrySet()) {
            String connId = (String)entry.getKey();
            FederatedProviderInfo provider = this._providerByServiceId.get(connId);
            assert (provider != null);
            Query originalQuery = (Query)entry.getValue();
            Query federationQuery = this.adjustQueryForFederation(originalQuery, targetMultipleInstances);
            Callable<PartialResult> task = this.createQueryTask(originalQuery, federationQuery, provider);
            partialResultTasks.add(task);
        }
        if (QueryMarker.isExtendedTracingEnabled()) {
            logger.info("Start federation for query: {}", (Object)QueryMarker.getQueryId());
        }
        if ((partialResults = this._taskExecutor.invokeTasks(partialResultTasks)).isEmpty()) {
            result = ResultSet.Builder.properties((List)query.getProperties()).totalCount(query.getWithTotalCount() ? Integer.valueOf(0) : null).build();
        } else {
            List<ResultSet> unifiedResults = this.partialResultsToUnifiedResultSets(partialResults);
            result = this.mergeAndApplyPaging(query, targetMultipleInstances, unifiedResults);
        }
        return result;
    }

    private Callable<PartialResult> createQueryTask(final Query originalQuery, final Query routedQuery, final FederatedProviderInfo providerInfo) {
        assert (originalQuery != null);
        assert (routedQuery != null);
        assert (providerInfo != null);
        return new Callable<PartialResult>(){

            @Override
            public PartialResult call() throws Exception {
                DataProvider dataProvider = providerInfo.getDataProvider();
                String providerName = providerInfo.getProviderName();
                String instanceId = providerInfo.getServiceInstanceUuid();
                logger.debug("Routing query to {}: {}", (Object)providerName, (Object)routedQuery);
                ResultSet partialResultSet = dataProvider.executeQuery(routedQuery);
                logger.trace("Partial result received from {}: {}", (Object)providerName, (Object)partialResultSet);
                return new PartialResult(originalQuery, instanceId, partialResultSet);
            }

            public String toString() {
                return "federation for " + providerInfo.getProviderName();
            }
        };
    }

    public QuerySchema getSchema() {
        FederatedProviderInfo providerInfo = this._providerByServiceId.values().iterator().next();
        QuerySchema baseSchema = providerInfo.getDataProvider().getSchema();
        return FederationConnection.addFilterableInstanceUuid(baseSchema);
    }

    public String toString() {
        if (this._providerByServiceId.size() > 1) {
            return "Federation(" + StringUtils.join(this._providerByServiceId.values(), (String)", ") + ")";
        }
        return this._providerByServiceId.values().iterator().next().toString();
    }

    private Query adjustQueryForFederation(Query original, boolean targetMultipleInstances) {
        Query modifiedQuery;
        boolean modifyQuery;
        if (original.getLimit() == 0) {
            return original;
        }
        ArrayList<SortCriterion> modifiedSort = new ArrayList<SortCriterion>(original.getSortCriteria().size());
        for (SortCriterion sortCriterion : original.getSortCriteria()) {
            if (PropertyUtil.isInstanceUuid((String)sortCriterion.getProperty())) continue;
            modifiedSort.add(sortCriterion);
        }
        ArrayList<String> modifiedProperties = new ArrayList<String>(original.getProperties().size());
        for (String property : original.getProperties()) {
            if (PropertyUtil.isInstanceUuid((String)property)) continue;
            modifiedProperties.add(property);
        }
        boolean bl = modifyQuery = !original.getSortCriteria().equals(modifiedSort) || !original.getProperties().equals(modifiedProperties) || targetMultipleInstances;
        if (modifyQuery) {
            Query.Builder modifiedQueryBuilder = QueryCopy.copyAndSelect((Query)original, modifiedProperties).orderBy(modifiedSort);
            if (modifiedProperties.isEmpty()) {
                modifiedQueryBuilder = modifiedQueryBuilder.orderBy(Collections.emptyList()).withTotalCount().offset(0).limit(0);
            } else if (modifiedSort.isEmpty()) {
                modifiedQueryBuilder = modifiedQueryBuilder.offset(0).limit(-1);
            } else if (targetMultipleInstances) {
                modifiedQueryBuilder = modifiedQueryBuilder.offset(0).limit(FederationConnection.getLimitForFederation(original.getOffset(), original.getLimit()));
            }
            modifiedQuery = modifiedQueryBuilder.build();
        } else {
            modifiedQuery = original;
        }
        return modifiedQuery;
    }

    private static int getLimitForFederation(int originalOffset, int originalLimit) {
        if (originalLimit == 0) {
            return 0;
        }
        if (originalLimit < 0) {
            return -1;
        }
        long effectiveLimit = Math.min(Integer.MAX_VALUE, (long)originalOffset + (long)originalLimit);
        return (int)effectiveLimit;
    }

    private List<ResultSet> partialResultsToUnifiedResultSets(List<PartialResult> partialResults) {
        LinkedHashSet<String> allPropertiesSet = new LinkedHashSet<String>();
        LinkedHashSet<String> instanceIdProperties = new LinkedHashSet<String>();
        for (PartialResult partialResult : partialResults) {
            allPropertiesSet.addAll(partialResult.resultSet.getProperties());
            for (String originalProperty : partialResult.originalQuery.getProperties()) {
                if (!PropertyUtil.isInstanceUuid((String)originalProperty)) continue;
                instanceIdProperties.add(originalProperty);
                allPropertiesSet.add(originalProperty);
            }
        }
        ArrayList<String> allProperties = new ArrayList<String>(allPropertiesSet);
        ArrayList<ResultSet> unifiedResults = new ArrayList<ResultSet>(partialResults.size());
        for (PartialResult partialResult : partialResults) {
            ResultSet partialResultSet = this.createSyntheticResultIfNeeded(partialResult.resultSet, partialResult.originalQuery, instanceIdProperties, partialResult.sourceInstanceUuid);
            if (allProperties.equals(partialResultSet.getProperties())) {
                unifiedResults.add(partialResultSet);
                continue;
            }
            ResultSet desiredResult = this.reorderAndAppendInstanceIdColumns(partialResultSet, allProperties, instanceIdProperties, partialResult.sourceInstanceUuid);
            unifiedResults.add(desiredResult);
        }
        return unifiedResults;
    }

    private ResultSet reorderAndAppendInstanceIdColumns(ResultSet resultSet, List<String> desiredProperties, Set<String> instanceIdProperties, String sourceInstanceUuid) {
        CombinedResourceItemPropertyByName valueByProperty = new CombinedResourceItemPropertyByName(resultSet.getProperties(), instanceIdProperties, sourceInstanceUuid);
        ArrayList convertedItems = new ArrayList(resultSet.getItems().size());
        for (ResourceItem resultItem : resultSet.getItems()) {
            ArrayList<Object> reorderedValues = new ArrayList<Object>(desiredProperties.size());
            for (String property : desiredProperties) {
                Object value = valueByProperty.getValue(property, resultItem);
                reorderedValues.add(value);
            }
            convertedItems.add(reorderedValues);
        }
        ResultSet desiredResult = ResultSet.Builder.properties(desiredProperties).items(convertedItems).totalCount(resultSet.getTotalCount()).build();
        return desiredResult;
    }

    private ResultSet createSyntheticResultIfNeeded(ResultSet resultSet, Query originalQuery, Set<String> instanceIdProperties, String sourceInstanceId) {
        int totalCount;
        int n = totalCount = resultSet.getTotalCount() != null ? resultSet.getTotalCount() : -1;
        if (resultSet.getItems().isEmpty() && totalCount > 0 && !instanceIdProperties.isEmpty() && originalQuery.getLimit() != 0) {
            int itemCountToSynthesize = Math.max(0, totalCount - originalQuery.getOffset());
            if (originalQuery.getLimit() > 0) {
                itemCountToSynthesize = Math.min(itemCountToSynthesize, originalQuery.getLimit());
            }
            ArrayList<String> columns = new ArrayList<String>(instanceIdProperties);
            List<String> syntheticItem = Collections.nCopies(columns.size(), sourceInstanceId);
            List<List<String>> syntheticItems = Collections.nCopies(itemCountToSynthesize, syntheticItem);
            Integer totalCountForReturn = originalQuery.getWithTotalCount() ? Integer.valueOf(totalCount) : null;
            return ResultSet.Builder.properties(columns).items(syntheticItems).totalCount(totalCountForReturn).build();
        }
        return resultSet;
    }

    private ResultSet mergeAndApplyPaging(Query query, boolean targetMultipleInstances, List<ResultSet> partialResults) {
        UnorderedSequenceMergePolicy mergePolicy;
        if (query.getSortCriteria().isEmpty()) {
            mergePolicy = new UnorderedSequenceMergePolicy();
        } else {
            List properties = partialResults.get(0).getProperties();
            DefaultItemComparator comparator = new DefaultItemComparator(properties, query.getSortCriteria());
            mergePolicy = new OrderedSequenceMergePolicy((Comparator)comparator);
        }
        int offsetToApply = targetMultipleInstances ? query.getOffset() : 0;
        ResultMergePolicy resultMergePolicy = new ResultMergePolicy((SequenceMergePolicy)mergePolicy);
        ResultSet result = resultMergePolicy.merge(partialResults, query.getWithTotalCount(), offsetToApply, query.getLimit());
        return result;
    }

    private static QuerySchema addFilterableInstanceUuid(QuerySchema baseSchema) {
        HashMap<String, QuerySchema.ModelInfo> enhancedSchema = new HashMap<String, QuerySchema.ModelInfo>();
        for (Map.Entry schemaEntry : baseSchema.getModels().entrySet()) {
            String modelName = (String)schemaEntry.getKey();
            QuerySchema.ModelInfo modelInfo = (QuerySchema.ModelInfo)schemaEntry.getValue();
            HashMap<String, QuerySchema.PropertyInfo> enhancedProperties = new HashMap<String, QuerySchema.PropertyInfo>(modelInfo.getProperties());
            enhancedProperties.put("@instanceUuid", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
            QuerySchema.ModelInfo enhancedModelInfo = new QuerySchema.ModelInfo(enhancedProperties);
            enhancedSchema.put(modelName, enhancedModelInfo);
        }
        return QuerySchema.forModels(enhancedSchema);
    }

    private static Query adjustQueryForOrderedMerge(Query query) {
        if (query.getSortCriteria().isEmpty()) {
            return query;
        }
        HashSet selected = new HashSet(query.getProperties());
        ArrayList<String> newSelect = new ArrayList<String>();
        for (SortCriterion sort : query.getSortCriteria()) {
            if (selected.contains(sort.getProperty())) continue;
            newSelect.add(sort.getProperty());
        }
        if (newSelect.isEmpty()) {
            return query;
        }
        newSelect.addAll(query.getProperties());
        Query modified = QueryCopy.copyAndSelect((Query)query, newSelect).build();
        return modified;
    }

    private static final class CombinedResourceItemPropertyByName
    implements ResourceItemPropertyByName {
        private final List<String> _nativeProperties;
        private final Set<String> _instanceIdProperties;
        private final String _sourceInstanceUuid;

        public CombinedResourceItemPropertyByName(List<String> nativeProperties, Set<String> instanceIdProperties, String sourceInstanceUuid) {
            this._nativeProperties = nativeProperties;
            this._instanceIdProperties = instanceIdProperties;
            this._sourceInstanceUuid = sourceInstanceUuid;
        }

        public Object getValue(String propertyName, ResourceItem item) {
            if (this._instanceIdProperties.contains(propertyName)) {
                return this._sourceInstanceUuid;
            }
            int propIdx = this._nativeProperties.indexOf(propertyName);
            if (propIdx >= 0 && propIdx < item.getPropertyValues().size()) {
                return item.getPropertyValues().get(propIdx);
            }
            return null;
        }
    }

    private static final class PartialResult {
        public final Query originalQuery;
        public final String sourceInstanceUuid;
        public final ResultSet resultSet;

        public PartialResult(Query originalQuery, String sourceInstanceUuid, ResultSet resultSet) {
            this.originalQuery = originalQuery;
            this.sourceInstanceUuid = sourceInstanceUuid;
            this.resultSet = resultSet;
        }
    }

    public static final class FederatedProviderInfo {
        private final String _providerName;
        private final String _serviceInstanceUuid;
        private final DataProvider _dataProvider;

        public FederatedProviderInfo(String providerName, String serviceInstanceUuid, DataProvider dataProvider) {
            Validate.notNull((Object)serviceInstanceUuid, (String)"Argument `serviceInstanceUuid' is required");
            Validate.notNull((Object)dataProvider, (String)"Argument `dataProvider' is required");
            this._providerName = providerName;
            this._serviceInstanceUuid = serviceInstanceUuid;
            this._dataProvider = dataProvider;
        }

        public String getProviderName() {
            return this._providerName;
        }

        public String getServiceInstanceUuid() {
            return this._serviceInstanceUuid;
        }

        public DataProvider getDataProvider() {
            return this._dataProvider;
        }

        public String toString() {
            return this._providerName;
        }
    }
}

