/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.federation;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.internal.adapters.federation.QueryRouter;
import com.vmware.cis.data.internal.adapters.federation.RouterUtils;
import com.vmware.cis.data.internal.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;

public final class InstanceUuidRouter
implements QueryRouter {
    @Override
    public final Query route(Query query, String targetInstanceId) {
        if (query.getFilter() == null) {
            return query;
        }
        Filter filter = query.getFilter();
        ArrayList<PropertyPredicate> otherPredicates = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        block3: for (PropertyPredicate predicate : filter.getCriteria()) {
            if (PropertyUtil.isInstanceUuid((String)predicate.getProperty())) {
                switch (predicate.getOperator()) {
                    case EQUAL: 
                    case IN: {
                        boolean matches = this.containsTargetInstanceId(predicate.getComparableValue(), targetInstanceId);
                        if (matches && filter.getOperator() == LogicalOperator.OR) {
                            return RouterUtils.replaceCriteria(query, null);
                        }
                        if (matches || filter.getOperator() != LogicalOperator.AND) continue block3;
                        return null;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("%s with property %s doesn't support operators other than %s and %s", PropertyPredicate.class.getSimpleName(), predicate.getProperty(), PropertyPredicate.ComparisonOperator.EQUAL.name(), PropertyPredicate.ComparisonOperator.IN.name()));
                    }
                }
            }
            otherPredicates.add(predicate);
        }
        if (otherPredicates.isEmpty() && filter.getOperator() == LogicalOperator.OR) {
            return null;
        }
        return RouterUtils.replaceCriteria(query, otherPredicates);
    }

    private boolean containsTargetInstanceId(Object predicateInstanceUuid, String targetInstanceId) {
        Collection<Object> instanceIdValues = RouterUtils.toCollection(predicateInstanceUuid);
        return instanceIdValues.contains(targetInstanceId);
    }
}

