/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.is;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.is.QueryConverter;
import com.vmware.cis.data.internal.adapters.is.ResponseConverter;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.query.client.QueryDispatcher;
import com.vmware.vim.query.client.provider.ProviderClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsDataProvider
implements DataProvider {
    private static final String OPTION_KEY_FEDERATED = "FEDERATED";
    private static final String OPTION_KEY_TIMEOUT = "TIMEOUT";
    private static final boolean OPTION_DEFAULT_VALUE_FEDERATED = false;
    private static final int OPTION_DEFAULT_VALUE_TIMEOUT_MILLIS = 900;
    private static final Logger _logger = LoggerFactory.getLogger(IsDataProvider.class);
    private static final Map<String, Object> _options = new HashMap<String, Object>();
    private final ProviderClient _is;

    public IsDataProvider(ProviderClient is) {
        Validate.notNull((Object)is);
        this._is = is;
    }

    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        InputStream resultStream = null;
        QueryDispatcher dispatcher = this._is.getQueryDispatcher();
        UniquePropertyMapping uniqueMapping = new UniquePropertyMapping(query.getProperties());
        String xQuery = QueryConverter.convertQuery(query, uniqueMapping._uniqueProperties);
        _logger.trace("Generated XQuery: {}", (Object)xQuery);
        try {
            ResultSet convertedSet;
            QueryDispatcher.QueryResponse response = dispatcher.query(xQuery, _options);
            resultStream = response.getResponseStream();
            ResultSet resultSet = ResponseConverter.parse(resultStream, (String)query.getResourceModels().iterator().next(), uniqueMapping._uniqueProperties, query.getWithTotalCount());
            ResultSet resultSet2 = convertedSet = ResultSet.Builder.properties((List)query.getProperties()).items(this.convertItems(resultSet.getItems(), uniqueMapping._duplicatesIndex)).totalCount(resultSet.getTotalCount()).build();
            this.close(resultStream);
            return resultSet2;
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Failed to execute query against IS", ex);
            }
            catch (Throwable throwable) {
                this.close(resultStream);
                throw throwable;
            }
        }
    }

    public QuerySchema getSchema() {
        throw new UnsupportedOperationException("Retrieving schema for IS data provider not supported");
    }

    private void close(InputStream resultStream) {
        if (resultStream == null) {
            return;
        }
        try {
            resultStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<List<Object>> convertItems(List<ResourceItem> items, List<Integer> indexes) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>(items.size());
        for (ResourceItem item : items) {
            ArrayList<Object> values = new ArrayList<Object>(indexes.size());
            for (Integer index : indexes) {
                values.add(item.get(index.intValue()));
            }
            list.add(values);
        }
        return list;
    }

    static {
        _options.put(OPTION_KEY_FEDERATED, false);
        _options.put(OPTION_KEY_TIMEOUT, 900);
    }

    private static class UniquePropertyMapping {
        List<String> _uniqueProperties;
        List<Integer> _duplicatesIndex;

        UniquePropertyMapping(List<String> properties) {
            this._uniqueProperties = new ArrayList<String>(properties.size());
            this._duplicatesIndex = new ArrayList<Integer>(properties.size());
            HashMap<String, Integer> set = new HashMap<String, Integer>();
            for (String property : properties) {
                Integer index = (Integer)set.get(property);
                if (index == null) {
                    index = set.size();
                    set.put(property, index);
                    this._uniqueProperties.add(property);
                }
                this._duplicatesIndex.add(index);
            }
        }
    }
}

