/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.is;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.adapters.is.XQueryDefinitions;
import com.vmware.cis.data.internal.adapters.is.XQueryUtil;
import com.vmware.cis.data.internal.util.PropertyUtil;
import org.apache.commons.lang.StringUtils;

final class PropertyValueUnmarshaller {
    private static final Unmarshaller STRING_UNMARSHALLER = new StringUnmarshaller();
    private static final Unmarshaller INTEGER_UNMARSHALLER = new IntegerUnmarshaller();
    private static final Unmarshaller LONG_UNMARSHALLER = new LongUnmarshaller();
    private static final Unmarshaller BOOLEAN_UNMARSHALLER = new BooleanUnmarshaller();
    private static final Unmarshaller MOREF_UNMARSHALLER = new MoRefUnmarshaller();

    PropertyValueUnmarshaller() {
    }

    public Object unmarshal(String model, String property, String value) {
        Unmarshaller unmarshaller = this.getUnmarshaller(model, property);
        try {
            return unmarshaller.unmarshal(value);
        }
        catch (RuntimeException e) {
            String message = String.format("Failed to parse %s to %s for property '%s' of nodel '%s'", value, unmarshaller.getType(), property, model);
            throw new RuntimeException(message, e);
        }
    }

    public boolean hasMultipleCardinality(String model, String property) {
        XQueryDefinitions.PropertyDefinition propertyDefinition = XQueryDefinitions.getPropertyDefinition(model, property);
        return propertyDefinition.hasMultipleCardinality();
    }

    private Unmarshaller getUnmarshaller(String model, String property) {
        XQueryDefinitions.PropertyDefinition propertyDefinition = XQueryDefinitions.getPropertyDefinition(model, property);
        if (propertyDefinition == null) {
            return this.getDefaultUnmarshaller(property);
        }
        QuerySchema.PropertyType type = propertyDefinition.getType();
        switch (type) {
            case INT: {
                return INTEGER_UNMARSHALLER;
            }
            case LONG: {
                return LONG_UNMARSHALLER;
            }
            case BOOLEAN: {
                return BOOLEAN_UNMARSHALLER;
            }
            case ID: {
                return MOREF_UNMARSHALLER;
            }
            case STRING: {
                return STRING_UNMARSHALLER;
            }
        }
        throw new IllegalArgumentException("Type " + type + " not supported " + "for unmarshalling on property '" + property + "' of model '" + model + "'");
    }

    private Unmarshaller getDefaultUnmarshaller(String property) {
        if (PropertyUtil.isModelKey((String)property)) {
            return MOREF_UNMARSHALLER;
        }
        return STRING_UNMARSHALLER;
    }

    private static class MoRefUnmarshaller
    implements Unmarshaller {
        private MoRefUnmarshaller() {
        }

        @Override
        public QuerySchema.PropertyType getType() {
            return QuerySchema.PropertyType.ID;
        }

        @Override
        public Object unmarshal(String value) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return XQueryUtil.toMoR(value);
        }
    }

    private static class LongUnmarshaller
    implements Unmarshaller {
        private LongUnmarshaller() {
        }

        @Override
        public QuerySchema.PropertyType getType() {
            return QuerySchema.PropertyType.LONG;
        }

        @Override
        public Object unmarshal(String value) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return Long.parseLong(value);
        }
    }

    private static class IntegerUnmarshaller
    implements Unmarshaller {
        private IntegerUnmarshaller() {
        }

        @Override
        public QuerySchema.PropertyType getType() {
            return QuerySchema.PropertyType.INT;
        }

        @Override
        public Object unmarshal(String value) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return Integer.parseInt(value);
        }
    }

    private static class BooleanUnmarshaller
    implements Unmarshaller {
        private BooleanUnmarshaller() {
        }

        @Override
        public QuerySchema.PropertyType getType() {
            return QuerySchema.PropertyType.BOOLEAN;
        }

        @Override
        public Object unmarshal(String value) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return Boolean.parseBoolean(value);
        }
    }

    private static class StringUnmarshaller
    implements Unmarshaller {
        private StringUnmarshaller() {
        }

        @Override
        public QuerySchema.PropertyType getType() {
            return QuerySchema.PropertyType.STRING;
        }

        @Override
        public Object unmarshal(String value) {
            return value;
        }
    }

    private static interface Unmarshaller {
        public QuerySchema.PropertyType getType();

        public Object unmarshal(String var1);
    }
}

