/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.is;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.util.PropertyUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class XQueryDefinitions {
    private static final String XML_TAG_PROPERTY_DEFINITION = "definition";
    private static final String XML_TAG_MODEL = "model";
    private static final String XML_TAG_PROPERTY = "property";
    private static final String XML_TAG_TYPE = "type";
    private static final String XML_TAG_SELECT_EXPRESSION = "selectExpression";
    private static final String XML_TAG_FILTER_EXPRESSION = "filterExpression";
    private static final String XML_TAG_FILTER_TEMPLATE = "filterTemplate";
    private static final String XML_TAG_MULTIPLE_CARDINALITY = "multipleCardinality";
    private static final String XML_TAG_FUNCTION_DEFINITION = "definition";
    private static final String XML_TAG_NAME = "name";
    private static final String XML_TAG_EXPRESSION = "expression";
    private static final String FILE_NAME_PROPERTY_DEFINITIONS = "properties";
    private static final String FILE_NAME_FUNCTION_DEFINITIONS = "functions";
    private static final String FILE_PATH_TEMPLATE = "/metadata/inventory_service/%s.xml";
    private static final Pattern XQUERY_FUNCTION_PATTERN = Pattern.compile("local:[A-Za-z_]([A-Za-z_0-9]|-)*\\(");
    private static final PropertyDefinition DEFAULT_STRING_DEFINITION = new PropertyDefinition(QuerySchema.PropertyType.STRING, null, null, null, false);
    private static final PropertyDefinition DEFAULT_KEY_DEFINITION = new PropertyDefinition(QuerySchema.PropertyType.ID, null, null, null, false);
    private static final String KEY_LOCAL_RETURNNODE = "local:returnnode";
    private static final String KEY_LOCAL_WHICH_ONE_IS_ANCESTOR = "local:whichOneIsAncestor";
    private static final String KEY_LOCAL_PRODUCT = "local:product";
    private static Map<String, FunctionDefinition> _functionsByName;
    private static Map<String, ModelDefinition> _modelsByName;

    XQueryDefinitions() {
    }

    static Set<String> getRequiredFunctions() {
        HashSet<String> functionSet = new HashSet<String>();
        functionSet.add(KEY_LOCAL_WHICH_ONE_IS_ANCESTOR);
        functionSet.add(KEY_LOCAL_RETURNNODE);
        functionSet.add(KEY_LOCAL_PRODUCT);
        return functionSet;
    }

    static String getFunctionExpression(String functionName) {
        FunctionDefinition functionDefinition = XQueryDefinitions.getFunctionDefinition(functionName);
        return functionDefinition.getBody();
    }

    static Set<String> getAllDependentFunctions(String functionName) {
        HashSet<String> checkedFunctions = new HashSet<String>();
        HashSet<String> uncheckedFunctions = new HashSet<String>();
        uncheckedFunctions.add(functionName);
        while (!uncheckedFunctions.isEmpty()) {
            HashSet<String> newFunctions = new HashSet<String>();
            for (String crtFunctionName : uncheckedFunctions) {
                checkedFunctions.add(crtFunctionName);
                FunctionDefinition definition = XQueryDefinitions.getFunctionDefinition(crtFunctionName);
                for (String newFunction : definition.getDependencies()) {
                    if (checkedFunctions.contains(newFunction) || uncheckedFunctions.contains(newFunction)) continue;
                    newFunctions.add(newFunction);
                }
            }
            uncheckedFunctions = newFunctions;
        }
        return checkedFunctions;
    }

    static PropertyDefinition getPropertyDefinition(String model, String property) {
        if (PropertyUtil.isModelKey((String)property)) {
            return DEFAULT_KEY_DEFINITION;
        }
        ModelDefinition modelDefinition = _modelsByName.get(model);
        if (modelDefinition == null) {
            return DEFAULT_STRING_DEFINITION;
        }
        PropertyDefinition propertyDefinition = modelDefinition.getPropertyDefinition(property);
        return propertyDefinition == null ? DEFAULT_STRING_DEFINITION : propertyDefinition;
    }

    private static FunctionDefinition getFunctionDefinition(String functionName) {
        FunctionDefinition functionDefinition = _functionsByName.get(functionName);
        if (functionDefinition == null) {
            throw new IllegalArgumentException("xQuery function definition not found for '" + functionName + "'");
        }
        return functionDefinition;
    }

    private static void loadProperties() {
        _modelsByName = new HashMap<String, ModelDefinition>();
        Element root = XQueryDefinitions.load(FILE_NAME_PROPERTY_DEFINITIONS);
        HashMap<String, HashMap<String, PropertyDefinition>> modelsMap = new HashMap<String, HashMap<String, PropertyDefinition>>();
        NodeList propertyNodes = root.getElementsByTagName("definition");
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            PropertyDefinition oldDefinition;
            Element element = (Element)propertyNodes.item(i);
            String model = XQueryDefinitions.extractNodeContent(element, XML_TAG_MODEL, true);
            String property = XQueryDefinitions.extractNodeContent(element, XML_TAG_PROPERTY, true);
            String type = XQueryDefinitions.extractNodeContent(element, XML_TAG_TYPE, true);
            QuerySchema.PropertyType propertyType = QuerySchema.PropertyType.valueOf((String)type.toUpperCase());
            String selectExpression = XQueryDefinitions.extractNodeContent(element, XML_TAG_SELECT_EXPRESSION, false);
            String filterExpression = XQueryDefinitions.extractNodeContent(element, XML_TAG_FILTER_EXPRESSION, false);
            String filterTemplate = XQueryDefinitions.extractNodeContent(element, XML_TAG_FILTER_TEMPLATE, false);
            String multipleCardinalityString = XQueryDefinitions.extractNodeContent(element, XML_TAG_MULTIPLE_CARDINALITY, false);
            boolean multipleCardinality = multipleCardinalityString == null ? false : Boolean.parseBoolean(multipleCardinalityString);
            PropertyDefinition propertyDefinition = new PropertyDefinition(propertyType, selectExpression, filterExpression, filterTemplate, multipleCardinality);
            HashMap<String, PropertyDefinition> propertyMap = (HashMap<String, PropertyDefinition>)modelsMap.get(model);
            if (propertyMap == null) {
                propertyMap = new HashMap<String, PropertyDefinition>();
                modelsMap.put(model, propertyMap);
            }
            if ((oldDefinition = propertyMap.put(property, propertyDefinition)) == null) continue;
            String message = String.format("Multiple definitions for property %s of model %s", property, model);
            throw new IllegalArgumentException(message);
        }
        for (Map.Entry e : modelsMap.entrySet()) {
            _modelsByName.put((String)e.getKey(), new ModelDefinition((Map)e.getValue()));
        }
    }

    private static void loadFunctions() {
        _functionsByName = new HashMap<String, FunctionDefinition>();
        Element root = XQueryDefinitions.load(FILE_NAME_FUNCTION_DEFINITIONS);
        NodeList propertyNodes = root.getElementsByTagName("definition");
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            Element element = (Element)propertyNodes.item(i);
            String name = XQueryDefinitions.extractNodeContent(element, XML_TAG_NAME, true);
            String expression = XQueryDefinitions.extractNodeContent(element, XML_TAG_EXPRESSION, true);
            _functionsByName.put(name, new FunctionDefinition(expression));
        }
    }

    private static String extractNodeContent(Element element, String nodeName, boolean mandatory) {
        NodeList nodeList = element.getElementsByTagName(nodeName);
        if (nodeList.getLength() > 1) {
            String message = String.format("Element %s cannot have more than 1 child nodes named %s", element.getNodeName(), nodeName);
            throw new IllegalArgumentException(message);
        }
        if (mandatory && nodeList.getLength() != 1) {
            String message = String.format("Element %s must have a child child node named %s", element.getNodeName(), nodeName);
            throw new IllegalArgumentException(message);
        }
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element childNode = (Element)nodeList.item(0);
        return childNode.getTextContent();
    }

    private static Set<String> extractFunctions(String expression) {
        if (expression == null) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        Matcher match = XQUERY_FUNCTION_PATTERN.matcher(expression);
        while (match.find()) {
            String functionName = XQueryDefinitions.getFunctionName(match.group());
            set.add(functionName);
        }
        return Collections.unmodifiableSet(set);
    }

    private static String getFunctionName(String match) {
        assert (match != null);
        String openBracket = "(";
        int index = match.indexOf("(");
        if (index < 0) {
            throw new IllegalArgumentException(String.format("Invalid query. XQuery function with name {0} is not recognized.", match));
        }
        return match.substring(0, index).trim();
    }

    private static Element load(String resourceFileName) {
        String resourceId = String.format(FILE_PATH_TEMPLATE, resourceFileName);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        InputStream inputStream = XQueryDefinitions.class.getResourceAsStream(resourceId);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element root = document.getDocumentElement();
            root.normalize();
            Element element = root;
            return element;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {}
        }
    }

    static {
        XQueryDefinitions.loadFunctions();
        XQueryDefinitions.loadProperties();
    }

    static final class PropertyDefinition {
        private final QuerySchema.PropertyType _type;
        private final String _selectExpression;
        private final String _filterExpression;
        private final String _filterTemplate;
        private final Set<String> _selectFunctions;
        private final Set<String> _filterFunctions;
        private final boolean _multipleCardinality;

        PropertyDefinition(QuerySchema.PropertyType type, String selectExpression, String filterExpression, String filterTemplate, Boolean multipleCardinality) {
            Validate.notNull((Object)type);
            this._type = type;
            this._selectExpression = selectExpression;
            this._filterExpression = filterExpression;
            this._filterTemplate = filterTemplate;
            this._selectFunctions = XQueryDefinitions.extractFunctions(selectExpression);
            this._filterFunctions = filterTemplate != null ? XQueryDefinitions.extractFunctions(filterTemplate) : XQueryDefinitions.extractFunctions(filterExpression);
            this._multipleCardinality = multipleCardinality;
        }

        QuerySchema.PropertyType getType() {
            return this._type;
        }

        String getSelectExpression() {
            return this._selectExpression;
        }

        String getFilterExpression() {
            return this._filterExpression;
        }

        String getFilterTemplate() {
            return this._filterTemplate;
        }

        Set<String> getSelectFunctions() {
            return this._selectFunctions;
        }

        Set<String> getFilterFunctions() {
            return this._filterFunctions;
        }

        boolean hasMultipleCardinality() {
            return this._multipleCardinality;
        }
    }

    static final class ModelDefinition {
        Map<String, PropertyDefinition> _propertiesByName;

        ModelDefinition(Map<String, PropertyDefinition> propertiesByName) {
            assert (propertiesByName != null);
            this._propertiesByName = Collections.unmodifiableMap(propertiesByName);
        }

        PropertyDefinition getPropertyDefinition(String property) {
            Validate.notNull((Object)property);
            return this._propertiesByName.get(property);
        }
    }

    static final class FunctionDefinition {
        private final String _body;
        private final Set<String> _dependencies;

        FunctionDefinition(String body) {
            this._body = body;
            this._dependencies = XQueryDefinitions.extractFunctions(body);
        }

        String getBody() {
            return this._body;
        }

        Collection<String> getDependencies() {
            return this._dependencies;
        }
    }
}

