/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.lookup;

import java.net.URI;
import java.security.KeyStore;
import org.apache.commons.lang.Validate;

public final class ServiceEndpointInfo {
    private final String _serviceType;
    private final URI _endpointAddress;
    private final String _nodeId;
    private final KeyStore _trustStore;
    private final String _endpointType;
    private final String _endpointProtocol;
    private final String _serviceUuid;

    public ServiceEndpointInfo(String serviceType, URI endpointAddress, String nodeId, KeyStore trustStore, String endpointType, String endpointProtocol, String serviceUuid) {
        Validate.notEmpty((String)serviceType, (String)"serviceType is required.");
        Validate.notNull((Object)endpointAddress, (String)"endpointAddress is required.");
        if ("https".equalsIgnoreCase(endpointAddress.getScheme())) {
            Validate.notNull((Object)trustStore, (String)"trustStore is required for https endpoint");
        }
        Validate.notEmpty((String)endpointType, (String)"endpointType is required.");
        Validate.notEmpty((String)endpointProtocol, (String)"endpointProtocol is required.");
        Validate.notEmpty((String)serviceUuid, (String)"serviceUuid is required");
        this._serviceType = serviceType;
        this._endpointAddress = endpointAddress;
        this._nodeId = nodeId;
        this._trustStore = trustStore;
        this._endpointType = endpointType;
        this._endpointProtocol = endpointProtocol;
        this._serviceUuid = serviceUuid;
    }

    public String getServiceType() {
        return this._serviceType;
    }

    public URI getUrl() {
        return this._endpointAddress;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public KeyStore getTrustStore() {
        return this._trustStore;
    }

    public String getEndpointType() {
        return this._endpointType;
    }

    public String getEndpointProtocol() {
        return this._endpointProtocol;
    }

    public String getServiceUuid() {
        return this._serviceUuid;
    }

    public String toString() {
        return String.format("ServiceEndpoint[serviceType = %s, url = %s, uuid = %s, node = %s, endpointType = %s, protocol = %s]", this._serviceType, this._endpointAddress, this._serviceUuid, this._nodeId, this._endpointType, this._endpointProtocol);
    }
}

