/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.pc;

import com.vmware.cis.data.internal.provider.util.property.PropertyByName;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FormulaRegistry {
    private static final String TYPE_VIRTUAL_MACHINE = "VirtualMachine";
    private static final String TYPE_FOLDER = "Folder";
    private static final String TYPE_HOST = "HostSystem";
    private static final String TYPE_RESOURCE_POOL = "ResourcePool";
    private static final String TYPE_DATASTORE = "Datastore";
    private static final String TYPE_DATACENTER = "Datacenter";
    private static final String TYPE_COMPUTE_RESOURCE = "ComputeResource";
    private static final String TYPE_NETWORK = "Network";
    private static final String TYPE_CLUSTER_COMPUTE_RESOURCE = "ClusterComputeResource";
    private static final String PROPERTY_IS_NORMAL_VM_OR_PRIMARY = "isNormalVMOrPrimaryFTVM";
    private static final String PROPERTY_IS_ROOT_FOLDER = "isRootFolder";
    private static final String PROPERTY_IS_DATASTORE_FOLDER = "isDatastoreFolder";
    private static final String PROPERTY_IS_DATACENTER_FOLDER = "isDatacenterFolder";
    private static final String PROPERTY_IS_COMPUTERESOURCE_FOLDER = "isComputeResourceFolder";
    private static final String PROPERTY_IS_NETWORK_FOLDER = "isNetworkFolder";
    private static final String PROPERTY_IS_STANDALONE = "isStandalone";
    private static final String PROPERTY_IS_ROOT_RP = "isRootRP";
    private static final String PROPERTY_IS_VM_FOLDER = "isVirtualMachineFolder";
    private static final String PROPERTY_CONFIG = "config";
    private static final String PROPERTY_CONFIG_ROLE = "config/ftInfo/role";
    private static final String PROPERTY_CONFIG_TEMPLATE = "config/template";
    private static final String PROPERTY_PARENT = "parent";
    private static final String PROPERTY_CHILD_TYPE = "childType";
    private static final Map<String, Map<String, Formula>> _propertiesByModel = new LinkedHashMap<String, Map<String, Formula>>();

    public static Formula getComputedProperty(String model, String property) {
        Map<String, Formula> formulasByProperty = _propertiesByModel.get(model);
        if (formulasByProperty == null) {
            return null;
        }
        return formulasByProperty.get(property);
    }

    private static void addVmFormulas() {
        Map<String, Formula> formulasByProperty = _propertiesByModel.get(TYPE_VIRTUAL_MACHINE);
        final List<String> requiredProperties = Arrays.asList(PROPERTY_CONFIG, PROPERTY_CONFIG_ROLE, PROPERTY_CONFIG_TEMPLATE);
        Formula formula = new Formula(){

            @Override
            public Object computeValue(PropertyByName item) {
                Object template;
                Object config = item.getValue(FormulaRegistry.PROPERTY_CONFIG);
                if (config == null) {
                    return true;
                }
                Object role = item.getValue(FormulaRegistry.PROPERTY_CONFIG_ROLE);
                if (role != null) {
                    if (!(role instanceof Integer)) {
                        return null;
                    }
                    if ((Integer)role > 1) {
                        return false;
                    }
                }
                if ((template = item.getValue(FormulaRegistry.PROPERTY_CONFIG_TEMPLATE)) == null) {
                    return null;
                }
                if (!(template instanceof Boolean)) {
                    return null;
                }
                return (Boolean)template == false;
            }

            @Override
            public Collection<String> getRequiredProperties() {
                return requiredProperties;
            }
        };
        formulasByProperty.put(PROPERTY_IS_NORMAL_VM_OR_PRIMARY, formula);
    }

    private static void addFolderIsRoot() {
        Map<String, Formula> formulasByProperty = _propertiesByModel.get(TYPE_FOLDER);
        final List<String> requiredProperties = Arrays.asList(PROPERTY_PARENT);
        Formula formula = new Formula(){

            @Override
            public Object computeValue(PropertyByName item) {
                Object config = item.getValue(FormulaRegistry.PROPERTY_PARENT);
                return config == null;
            }

            @Override
            public Collection<String> getRequiredProperties() {
                return requiredProperties;
            }
        };
        formulasByProperty.put(PROPERTY_IS_ROOT_FOLDER, formula);
    }

    private static void addFolderType() {
        Map<String, Formula> formulasByProperty = _propertiesByModel.get(TYPE_FOLDER);
        List<String> requiredProperties = Arrays.asList(PROPERTY_CHILD_TYPE);
        formulasByProperty.put(PROPERTY_IS_COMPUTERESOURCE_FOLDER, new FolderTypeFormula(requiredProperties, TYPE_COMPUTE_RESOURCE));
        formulasByProperty.put(PROPERTY_IS_DATACENTER_FOLDER, new FolderTypeFormula(requiredProperties, TYPE_DATACENTER));
        formulasByProperty.put(PROPERTY_IS_DATASTORE_FOLDER, new FolderTypeFormula(requiredProperties, TYPE_DATASTORE));
        formulasByProperty.put(PROPERTY_IS_NETWORK_FOLDER, new FolderTypeFormula(requiredProperties, TYPE_NETWORK));
        formulasByProperty.put(PROPERTY_IS_VM_FOLDER, new FolderTypeFormula(requiredProperties, TYPE_VIRTUAL_MACHINE));
    }

    private static void addHostIsStandalone() {
        Map<String, Formula> formulasByProperty = _propertiesByModel.get(TYPE_HOST);
        final List<String> requiredProperties = Arrays.asList(PROPERTY_PARENT);
        Formula formula = new Formula(){

            @Override
            public Object computeValue(PropertyByName item) {
                Object parent = item.getValue(FormulaRegistry.PROPERTY_PARENT);
                if (parent == null) {
                    return null;
                }
                if (!(parent instanceof ManagedObjectReference)) {
                    return null;
                }
                ManagedObjectReference parentRef = (ManagedObjectReference)parent;
                return FormulaRegistry.TYPE_COMPUTE_RESOURCE.equals(parentRef.getType());
            }

            @Override
            public Collection<String> getRequiredProperties() {
                return requiredProperties;
            }
        };
        formulasByProperty.put(PROPERTY_IS_STANDALONE, formula);
    }

    private static void addResourcePoolIsRootRP() {
        Map<String, Formula> formulasByProperty = _propertiesByModel.get(TYPE_RESOURCE_POOL);
        final List<String> requiredProperties = Arrays.asList(PROPERTY_PARENT);
        Formula formula = new Formula(){

            @Override
            public Object computeValue(PropertyByName item) {
                Object parent = item.getValue(FormulaRegistry.PROPERTY_PARENT);
                if (parent == null) {
                    return null;
                }
                if (!(parent instanceof ManagedObjectReference)) {
                    return null;
                }
                ManagedObjectReference parentRef = (ManagedObjectReference)parent;
                return FormulaRegistry.TYPE_COMPUTE_RESOURCE.equals(parentRef.getType()) || FormulaRegistry.TYPE_CLUSTER_COMPUTE_RESOURCE.equals(parentRef.getType());
            }

            @Override
            public Collection<String> getRequiredProperties() {
                return requiredProperties;
            }
        };
        formulasByProperty.put(PROPERTY_IS_ROOT_RP, formula);
    }

    static {
        _propertiesByModel.put(TYPE_VIRTUAL_MACHINE, new HashMap());
        _propertiesByModel.put(TYPE_FOLDER, new HashMap());
        _propertiesByModel.put(TYPE_HOST, new HashMap());
        _propertiesByModel.put(TYPE_RESOURCE_POOL, new HashMap());
        FormulaRegistry.addVmFormulas();
        FormulaRegistry.addFolderIsRoot();
        FormulaRegistry.addFolderType();
        FormulaRegistry.addHostIsStandalone();
        FormulaRegistry.addResourcePoolIsRootRP();
    }

    static interface Formula {
        public Object computeValue(PropertyByName var1);

        public Collection<String> getRequiredProperties();
    }

    static final class FolderTypeFormula
    implements Formula {
        private final String _type;
        private final Collection<String> _requiredProperties;

        FolderTypeFormula(Collection<String> requiredProperties, String type) {
            this._requiredProperties = requiredProperties;
            this._type = type;
        }

        @Override
        public Object computeValue(PropertyByName item) {
            Object childType = item.getValue(FormulaRegistry.PROPERTY_CHILD_TYPE);
            if (childType == null) {
                return null;
            }
            if (!(childType instanceof String[])) {
                return null;
            }
            String[] childTypeArray = (String[])childType;
            for (int i = 0; i < childTypeArray.length; ++i) {
                if (!this._type.equals(childTypeArray[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<String> getRequiredProperties() {
            return this._requiredProperties;
        }
    }
}

