/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.pc;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.adapters.pc.FormulaRegistry;
import com.vmware.cis.data.internal.adapters.pc.PropertyRegistry;
import com.vmware.cis.data.internal.adapters.pc.QueryAnalyzer;
import com.vmware.cis.data.internal.adapters.pc.ResultWrapper;
import com.vmware.cis.data.internal.provider.util.filter.FilterEvaluator;
import com.vmware.cis.data.internal.provider.util.property.PropertyByName;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.DynamicProperty;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vim.binding.vmodl.query.InvalidProperty;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.client.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcDataProvider
implements DataProvider {
    private static final Logger _logger = LoggerFactory.getLogger(PcDataProvider.class);
    private static final String SERVICE_INSTANCE = "ServiceInstance";
    private static final Integer MAX_OBJECTS = 250;
    private static final PropertyCollector.RetrieveOptions OPTIONS = new PropertyCollector.RetrieveOptions();
    private static final String TYPE_FOLDER = "Folder";
    private static final String ROOT_FOLDER_PROPERTY = "@rootFolder";
    private final PropertyCollector _pc;
    private final ManagedObjectReference _rootFolder;

    public PcDataProvider(Client vlsiClient) {
        Validate.notNull((Object)vlsiClient, (String)"VLSI client");
        ManagedObjectReference siMor = new ManagedObjectReference(SERVICE_INSTANCE, SERVICE_INSTANCE);
        ServiceInstance siStub = PcDataProvider.createStub(vlsiClient, ServiceInstance.class, siMor);
        ServiceInstanceContent sic = siStub.getContent();
        this._rootFolder = sic.getRootFolder();
        this._pc = PcDataProvider.createPropertyCollector(vlsiClient, siStub.getContent());
    }

    public ResultSet executeQuery(Query query) {
        QueryAnalyzer.QueryAnalysis analysis = QueryAnalyzer.analyzeQuery(query);
        ResultWrapper allEntitiesResult = this.retrieveEntities(analysis);
        allEntitiesResult = this.filterModels(allEntitiesResult, query.getResourceModels());
        this.addForeignKeys(allEntitiesResult, analysis);
        List<ResultWrapper.ItemValueMap> items = this.extractItemValues(allEntitiesResult);
        this.orderItems(items, analysis);
        ResultSet resultSet = this.createResponse(items, query);
        return resultSet;
    }

    public QuerySchema getSchema() {
        throw new UnsupportedOperationException("Retrieving schema for PC data provider not supported");
    }

    private ResultWrapper filterModels(ResultWrapper originalResults, Collection<String> models) {
        ResultWrapper resultWrapper = new ResultWrapper();
        for (Map.Entry<ManagedObjectReference, ResultWrapper.ItemValueMap> entry : originalResults.entrySet()) {
            ManagedObjectReference key = entry.getKey();
            if (!models.contains(key.getType())) continue;
            resultWrapper.add(key, entry.getValue());
        }
        return resultWrapper;
    }

    private ResultSet createResponse(List<ResultWrapper.ItemValueMap> results, Query query) {
        int offset;
        int last;
        int limit = query.getLimit();
        if (limit == 0) {
            return ResultSet.Builder.properties((String[])new String[0]).totalCount(Integer.valueOf(results.size())).build();
        }
        if (limit < 0) {
            limit = results.size();
        }
        if ((last = (offset = query.getOffset()) + limit) > results.size()) {
            last = results.size();
        }
        ResultSet.Builder builder = ResultSet.Builder.properties((List)query.getProperties());
        for (int i = offset; i < last; ++i) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (String property : query.getProperties()) {
                values.add(results.get(i).getValue(property));
            }
            builder.item(values);
        }
        if (query.getWithTotalCount()) {
            builder.totalCount(Integer.valueOf(results.size()));
        }
        return builder.build();
    }

    private List<ResultWrapper.ItemValueMap> extractItemValues(ResultWrapper resultWrapper) {
        ArrayList<ResultWrapper.ItemValueMap> results = new ArrayList<ResultWrapper.ItemValueMap>();
        for (Map.Entry<ManagedObjectReference, ResultWrapper.ItemValueMap> entry : resultWrapper.entrySet()) {
            results.add(entry.getValue());
        }
        return results;
    }

    private void orderItems(List<ResultWrapper.ItemValueMap> itemValues, QueryAnalyzer.QueryAnalysis analysis) {
        if (analysis.getSortDirection() == null) {
            return;
        }
        final int multiplier = analysis.getSortDirection().equals((Object)SortCriterion.SortDirection.ASCENDING) ? 1 : -1;
        Collections.sort(itemValues, new Comparator<ResultWrapper.ItemValueMap>(){

            @Override
            public int compare(ResultWrapper.ItemValueMap o1, ResultWrapper.ItemValueMap o2) {
                ManagedObjectReference mor1 = (ManagedObjectReference)o1.get("@modelKey");
                ManagedObjectReference mor2 = (ManagedObjectReference)o2.get("@modelKey");
                return multiplier * mor1.getValue().compareTo(mor2.getValue());
            }
        });
    }

    private ResultWrapper retrieveEntities(QueryAnalyzer.QueryAnalysis analysis) {
        if (analysis.getClientSidePredicates().isEmpty() && analysis.getMorPredicates().isEmpty()) {
            return this.retrieveEntitiesByModel(analysis);
        }
        if (analysis.getClientSidePredicates().isEmpty()) {
            return this.retrieveEntitiesByKey(analysis);
        }
        if (analysis.getMorPredicates().isEmpty()) {
            ResultWrapper allEntities = this.retrieveEntitiesByModel(analysis);
            return this.filter(allEntities, analysis);
        }
        ResultWrapper traversalResults = this.retrieveEntitiesByKey(analysis);
        if (analysis.isIntersection()) {
            return this.filter(traversalResults, analysis);
        }
        ResultWrapper allEntitiesOfModel = this.retrieveEntitiesByModel(analysis);
        ResultWrapper filteredEntities = this.filter(allEntitiesOfModel, analysis);
        traversalResults.union(filteredEntities);
        return traversalResults;
    }

    private ResultWrapper retrieveEntitiesByKey(QueryAnalyzer.QueryAnalysis analysis) {
        ResultWrapper resultWrapper = null;
        PropertyCollector.PropertySpec propSepc = this.createPropertySpec(analysis.getModel(), analysis.getNativeProperties());
        for (PropertyPredicate predicate : analysis.getMorPredicates()) {
            String property = predicate.getProperty();
            PropertyRegistry.PropertyDefinition definition = PropertyRegistry.getPropertyDefinition(analysis.getModel(), property);
            PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec();
            filterSpec.setPropSet(new PropertyCollector.PropertySpec[]{propSepc});
            ArrayList<PropertyCollector.ObjectSpec> objectSpecs = new ArrayList<PropertyCollector.ObjectSpec>();
            if (predicate.getOperator().equals((Object)PropertyPredicate.ComparisonOperator.EQUAL)) {
                ManagedObjectReference mor = (ManagedObjectReference)predicate.getComparableValue();
                objectSpecs.add(this.createObjectSpec(mor, definition.getFilterSpecForPredicate()));
            } else {
                Collection mors = (Collection)predicate.getComparableValue();
                for (ManagedObjectReference mor : mors) {
                    objectSpecs.add(this.createObjectSpec(mor, definition.getFilterSpecForPredicate()));
                }
            }
            filterSpec.setObjectSet(objectSpecs.toArray(new PropertyCollector.ObjectSpec[0]));
            Collection<PropertyCollector.RetrieveResult> retrieveResults = this.fetchFromPC(filterSpec);
            ResultWrapper partialResult = this.convertToWrapper(retrieveResults, analysis);
            if (resultWrapper == null) {
                resultWrapper = partialResult;
                continue;
            }
            if (analysis.isIntersection()) {
                resultWrapper.intersection(partialResult);
                continue;
            }
            resultWrapper.union(partialResult);
        }
        return resultWrapper;
    }

    private ResultWrapper retrieveEntitiesByModel(QueryAnalyzer.QueryAnalysis analysis) {
        PropertyCollector.PropertySpec propSepc = this.createPropertySpec(analysis.getModel(), analysis.getNativeProperties());
        PropertyRegistry.PropertyDefinition definition = PropertyRegistry.getPropertyDefinition(analysis.getModel(), ROOT_FOLDER_PROPERTY);
        if (definition.getFilterSpecForPredicate() == null) {
            throw new IllegalArgumentException("Cannot select all '" + analysis.getModel() + "' entities");
        }
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec();
        filterSpec.setPropSet(new PropertyCollector.PropertySpec[]{propSepc});
        PropertyCollector.ObjectSpec objectSpec = this.createObjectSpec(this._rootFolder, definition.getFilterSpecForPredicate());
        objectSpec.setSkip(Boolean.valueOf(!analysis.getModel().equals(TYPE_FOLDER)));
        filterSpec.setObjectSet(new PropertyCollector.ObjectSpec[]{objectSpec});
        Collection<PropertyCollector.RetrieveResult> retrieveResults = this.fetchFromPC(filterSpec);
        return this.convertToWrapper(retrieveResults, analysis);
    }

    private ResultWrapper filter(ResultWrapper filterOnEntities, QueryAnalyzer.QueryAnalysis analysis) {
        ResultWrapper result = new ResultWrapper();
        Filter filter = new Filter(analysis.getClientSidePredicates(), analysis.isIntersection() ? LogicalOperator.AND : LogicalOperator.OR);
        for (Map.Entry<ManagedObjectReference, ResultWrapper.ItemValueMap> entry : filterOnEntities.entrySet()) {
            boolean valid = FilterEvaluator.eval((Filter)filter, (PropertyByName)entry.getValue());
            if (!valid) continue;
            result.add(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private PropertyCollector.ObjectSpec createObjectSpec(ManagedObjectReference mor, PropertyCollector.SelectionSpec[] traversals) {
        PropertyCollector.ObjectSpec objectSpec = new PropertyCollector.ObjectSpec();
        objectSpec.setDynamicType(mor.getType());
        objectSpec.setObj(mor);
        if (traversals != null) {
            objectSpec.setSelectSet(traversals);
            objectSpec.setSkip(Boolean.valueOf(true));
        }
        return objectSpec;
    }

    private PropertyCollector.PropertySpec createPropertySpec(String model, Collection<String> properties) {
        ArrayList<String> convertedProperties = new ArrayList<String>(properties.size());
        for (String property : properties) {
            if (PropertyUtil.isModelKey((String)property)) continue;
            convertedProperties.add(this.convertPropertyToPCFormat(property));
        }
        PropertyCollector.PropertySpec propSpec = new PropertyCollector.PropertySpec();
        propSpec.setType((TypeName)new TypeNameImpl(model));
        propSpec.setAll(Boolean.valueOf(false));
        propSpec.setPathSet(convertedProperties.toArray(new String[0]));
        return propSpec;
    }

    private ResultWrapper convertToWrapper(Collection<PropertyCollector.RetrieveResult> retrieveResults, QueryAnalyzer.QueryAnalysis analysis) {
        ResultWrapper resultWrapper = new ResultWrapper();
        for (PropertyCollector.RetrieveResult retrieveResult : retrieveResults) {
            this.convertToWrapper(resultWrapper, retrieveResult);
        }
        if (analysis.getFormulas().isEmpty()) {
            return resultWrapper;
        }
        for (Map.Entry entry : resultWrapper.entrySet()) {
            this.addVirtualProperties((ResultWrapper.ItemValueMap)entry.getValue(), analysis);
        }
        return resultWrapper;
    }

    private void convertToWrapper(ResultWrapper resultWrapper, PropertyCollector.RetrieveResult retrieveResult) {
        if (retrieveResult.objects == null) {
            return;
        }
        for (PropertyCollector.ObjectContent content : retrieveResult.getObjects()) {
            ResultWrapper.ItemValueMap itemValueMap = new ResultWrapper.ItemValueMap();
            ManagedObjectReference mor = content.obj;
            itemValueMap.add("@modelKey", mor);
            resultWrapper.add(mor, itemValueMap);
            if (content.getPropSet() == null) continue;
            for (DynamicProperty property : content.getPropSet()) {
                itemValueMap.add(this.convertPropertyToDSFormat(property.getName()), property.getVal());
            }
        }
    }

    private void addVirtualProperties(ResultWrapper.ItemValueMap item, QueryAnalyzer.QueryAnalysis analysis) {
        for (Map.Entry<String, FormulaRegistry.Formula> entry : analysis.getFormulas().entrySet()) {
            Object virtualValue = entry.getValue().computeValue(item);
            item.add(entry.getKey(), virtualValue);
        }
    }

    private void addForeignKeys(ResultWrapper resultWrapper, QueryAnalyzer.QueryAnalysis analysis) {
        if (analysis.getForeignKeyProperties().isEmpty()) {
            return;
        }
        String model = analysis.getModel();
        for (String property : analysis.getForeignKeyProperties()) {
            this.addForeignKeys(resultWrapper, model, property);
        }
    }

    private void addForeignKeys(ResultWrapper resultWrapper, String model, String property) {
        PropertyRegistry.PropertyDefinition definition = PropertyRegistry.getPropertyDefinition(model, property);
        PropertyCollector.SelectionSpec[] selectionSpec = definition.getFilterSpecForSelect();
        PropertyCollector.PropertySpec[] pSpecs = new PropertyCollector.PropertySpec[definition.getForeignKeyModels().size()];
        int counter = 0;
        for (String foreignKeyModel : definition.getForeignKeyModels()) {
            PropertyCollector.PropertySpec pSpec = new PropertyCollector.PropertySpec();
            pSpec.setType((TypeName)new TypeNameImpl(foreignKeyModel));
            pSpecs[counter++] = pSpec;
        }
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec();
        filterSpec.setPropSet(pSpecs);
        for (Map.Entry<ManagedObjectReference, ResultWrapper.ItemValueMap> entry : resultWrapper.entrySet()) {
            PropertyCollector.ObjectSpec objectSpec = this.createObjectSpec(entry.getKey(), selectionSpec);
            filterSpec.setObjectSet(new PropertyCollector.ObjectSpec[]{objectSpec});
            Collection<PropertyCollector.RetrieveResult> retrieveResults = this.fetchFromPC(filterSpec);
            ManagedObjectReference mor = this.extractForeignKey(retrieveResults);
            entry.getValue().add(property, mor);
        }
    }

    private ManagedObjectReference extractForeignKey(Collection<PropertyCollector.RetrieveResult> retrieveResults) {
        for (PropertyCollector.RetrieveResult retrieveResult : retrieveResults) {
            PropertyCollector.ObjectContent[] content;
            if (retrieveResult.objects == null || (content = retrieveResult.getObjects()).length == 0) continue;
            return content[0].obj;
        }
        return null;
    }

    private Collection<PropertyCollector.RetrieveResult> fetchFromPC(PropertyCollector.FilterSpec filterSpec) {
        ArrayList<PropertyCollector.RetrieveResult> results = new ArrayList<PropertyCollector.RetrieveResult>();
        try {
            PropertyCollector.RetrieveResult currentResult = this._pc.retrievePropertiesEx(new PropertyCollector.FilterSpec[]{filterSpec}, OPTIONS);
            if (currentResult == null) {
                return results;
            }
            results.add(currentResult);
            while (currentResult.getToken() != null && (currentResult = this._pc.continueRetrievePropertiesEx(currentResult.getToken())) != null) {
                results.add(currentResult);
            }
            return results;
        }
        catch (ManagedObjectNotFound e) {
            _logger.debug("A query requested a missing object", (Throwable)e);
            return results;
        }
        catch (InvalidProperty e) {
            throw new IllegalArgumentException("Invalid property " + e.getName(), e);
        }
    }

    private String convertPropertyToPCFormat(String property) {
        return property.replace('/', '.');
    }

    private String convertPropertyToDSFormat(String property) {
        return property.replace('.', '/');
    }

    private static PropertyCollector createPropertyCollector(Client vlsiClient, ServiceInstanceContent serviceInstanceContent) {
        assert (vlsiClient != null);
        assert (serviceInstanceContent != null);
        try {
            PropertyCollector rootPC = PcDataProvider.createStub(vlsiClient, PropertyCollector.class, serviceInstanceContent.getPropertyCollector());
            return rootPC;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error has occurred while preparing PropertyCollector.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends ManagedObject> T createStub(Client vlsiClient, Class<T> stubBindingClass, ManagedObjectReference ref) {
        assert (vlsiClient != null);
        assert (stubBindingClass != null);
        assert (ref != null);
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(PcDataProvider.class.getClassLoader());
        try {
            ManagedObject managedObject = vlsiClient.createStub(stubBindingClass, ref);
            return (T)managedObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    static {
        PcDataProvider.OPTIONS.maxObjects = MAX_OBJECTS;
    }
}

