/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.pc;

import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class PropertyRegistry {
    private static final String TRAVERSALS_FILE = "/metadata/property_collector/traversals.xml";
    private static final String XML_TAG_PROPERTY_DEFINITION = "definition";
    private static final String XML_TAG_MODEL = "model";
    private static final String XML_TAG_FOREIGN_MODELS = "foreignModels";
    private static final String XML_TAG_PROPERTY = "property";
    private static final String XML_TAG_FILTER_TRAVERSALS = "filterTraversals";
    private static final String XML_TAG_SELECT_TRAVERSALS = "selectTraversals";
    private static final String XML_TAG_START = "start";
    private static final String XML_TAG_NAME = "name";
    private static final String XML_TAG_NEXT_TRAVERSAL = "next";
    private static final String XML_TAG_TRAVERSAL_GROUP = "traversal";
    private static Map<String, ModelDefinition> _propertiesByModel;
    private static final PropertyDefinition SIMPLE_PROPERTY;

    PropertyRegistry() {
    }

    public static PropertyDefinition getPropertyDefinition(String model, String property) {
        if (PropertyUtil.isModelKey((String)property)) {
            return SIMPLE_PROPERTY;
        }
        ModelDefinition definition = _propertiesByModel.get(model);
        if (definition == null) {
            throw new IllegalArgumentException("Model " + model + " not supported");
        }
        PropertyDefinition propDef = definition.getPropertyDefinition(property);
        if (propDef == null) {
            return SIMPLE_PROPERTY;
        }
        return propDef;
    }

    private static void populateTraversals() {
        _propertiesByModel = new HashMap<String, ModelDefinition>();
        HashMap<String, HashMap<String, PropertyDefinition>> modelsMap = new HashMap<String, HashMap<String, PropertyDefinition>>();
        Element root = PropertyRegistry.load();
        NodeList propertyNodes = root.getElementsByTagName(XML_TAG_PROPERTY_DEFINITION);
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            PropertyDefinition oldDefinition;
            Element element = (Element)propertyNodes.item(i);
            String model = PropertyRegistry.extractNodeContent(element, XML_TAG_MODEL, true);
            String property = PropertyRegistry.extractNodeContent(element, XML_TAG_PROPERTY, true);
            List<String> foreignKeyModels = null;
            String foreignKeyModelsString = PropertyRegistry.extractNodeContent(element, XML_TAG_FOREIGN_MODELS, false);
            if (foreignKeyModelsString != null) {
                foreignKeyModels = Arrays.asList(foreignKeyModelsString.split(","));
            }
            NodeList traversals = element.getElementsByTagName(XML_TAG_FILTER_TRAVERSALS);
            PropertyCollector.SelectionSpec[] traversalsFilter = PropertyRegistry.handleTraversal(traversals);
            traversals = element.getElementsByTagName(XML_TAG_SELECT_TRAVERSALS);
            PropertyCollector.SelectionSpec[] traversalsSelect = PropertyRegistry.handleTraversal(traversals);
            if (traversalsSelect != null && foreignKeyModels == null) {
                String message = String.format("No foreign key models specified for property %s of model %s", property, model);
                throw new RuntimeException(message);
            }
            PropertyDefinition definition = new PropertyDefinition(traversalsFilter, traversalsSelect, foreignKeyModels);
            HashMap<String, PropertyDefinition> propertyByName = (HashMap<String, PropertyDefinition>)modelsMap.get(model);
            if (propertyByName == null) {
                propertyByName = new HashMap<String, PropertyDefinition>();
                modelsMap.put(model, propertyByName);
            }
            if ((oldDefinition = propertyByName.put(property, definition)) == null) continue;
            String message = String.format("Multiple definitions for property %s of model %s", property, model);
            throw new RuntimeException(message);
        }
        for (Map.Entry entry : modelsMap.entrySet()) {
            _propertiesByModel.put((String)entry.getKey(), new ModelDefinition((Map)entry.getValue()));
        }
    }

    private static PropertyCollector.SelectionSpec[] handleTraversal(NodeList traversalsRoot) {
        NodeList traversals = PropertyRegistry.extractTraversals(traversalsRoot);
        if (traversals == null) {
            return null;
        }
        if (traversals.getLength() == 0) {
            return null;
        }
        HashMap<String, List<Object>> nextTraversalByName = new HashMap<String, List<Object>>();
        HashMap<String, PropertyCollector.TraversalSpec> traversalsByName = new HashMap<String, PropertyCollector.TraversalSpec>();
        LinkedList<String> unprocessedSpecs = new LinkedList<String>();
        ArrayList<PropertyCollector.TraversalSpec> traversalSpecsRoot = new ArrayList<PropertyCollector.TraversalSpec>(unprocessedSpecs.size());
        HashSet<String> referencedTraversals = new HashSet<String>();
        for (int i = 0; i < traversals.getLength(); ++i) {
            String next;
            Element traversalElement = (Element)traversals.item(i);
            String model = PropertyRegistry.extractNodeContent(traversalElement, XML_TAG_MODEL, true);
            String property = PropertyRegistry.extractNodeContent(traversalElement, XML_TAG_PROPERTY, true);
            String name = PropertyRegistry.extractNodeContent(traversalElement, XML_TAG_NAME, true);
            String startString = PropertyRegistry.extractNodeContent(traversalElement, XML_TAG_START, false);
            boolean start = startString == null ? false : Boolean.parseBoolean(startString);
            PropertyCollector.TraversalSpec traversalSpec = PropertyRegistry.createTraversalSpec(name, model, property);
            traversalsByName.put(name, traversalSpec);
            if (start) {
                unprocessedSpecs.add(name);
                traversalSpecsRoot.add(traversalSpec);
                referencedTraversals.add(name);
            }
            if ((next = PropertyRegistry.extractNodeContent(traversalElement, XML_TAG_NEXT_TRAVERSAL, false)) == null) {
                nextTraversalByName.put(name, Collections.emptyList());
                continue;
            }
            String[] nextTraversalName = next.split(",");
            nextTraversalByName.put(name, Arrays.asList(nextTraversalName));
        }
        while (!unprocessedSpecs.isEmpty()) {
            String specName = (String)unprocessedSpecs.poll();
            PropertyCollector.TraversalSpec spec = (PropertyCollector.TraversalSpec)traversalsByName.get(specName);
            if (spec == null) {
                String message = String.format("No traversal named %s could be found", specName);
                throw new RuntimeException(message);
            }
            List nextList = (List)nextTraversalByName.get(specName);
            ArrayList<Object> selectionSpecs = new ArrayList<Object>(nextList.size());
            for (String next : nextList) {
                if (referencedTraversals.contains(next)) {
                    selectionSpecs.add(new PropertyCollector.SelectionSpec(next));
                    continue;
                }
                selectionSpecs.add(traversalsByName.get(next));
                unprocessedSpecs.add(next);
                referencedTraversals.add(next);
            }
            spec.setSelectSet(selectionSpecs.toArray(new PropertyCollector.SelectionSpec[0]));
        }
        return traversalSpecsRoot.toArray(new PropertyCollector.SelectionSpec[0]);
    }

    private static NodeList extractTraversals(NodeList traversalsRoot) {
        if (traversalsRoot.getLength() == 0) {
            return null;
        }
        if (traversalsRoot.getLength() > 2) {
            throw new RuntimeException("Found too many traversal structures");
        }
        Element root = (Element)traversalsRoot.item(0);
        return root.getElementsByTagName(XML_TAG_TRAVERSAL_GROUP);
    }

    private static PropertyCollector.TraversalSpec createTraversalSpec(String name, String model, String property) {
        PropertyCollector.TraversalSpec traversalSepc = new PropertyCollector.TraversalSpec();
        traversalSepc.setName(name);
        traversalSepc.setType((TypeName)new TypeNameImpl(model));
        traversalSepc.setPath(property);
        traversalSepc.setSkip(new Boolean(false));
        return traversalSepc;
    }

    private static String extractNodeContent(Element element, String nodeName, boolean mandatory) {
        Node childNode = null;
        NodeList nodeList = element.getElementsByTagName(nodeName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getParentNode().equals(element)) continue;
            if (childNode != null) {
                String message = String.format("Element %s cannot have more than 1 child nodes named %s", element.getNodeName(), nodeName);
                throw new RuntimeException(message);
            }
            childNode = (Element)nodeList.item(i);
        }
        if (mandatory && childNode == null) {
            String message = String.format("Element %s must have a child node named %s", element.getNodeName(), nodeName);
            throw new RuntimeException(message);
        }
        if (childNode == null) {
            return null;
        }
        return childNode.getTextContent();
    }

    private static Element load() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        InputStream inputStream = PropertyRegistry.class.getResourceAsStream(TRAVERSALS_FILE);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element root = document.getDocumentElement();
            root.normalize();
            Element element = root;
            return element;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {}
        }
    }

    static {
        SIMPLE_PROPERTY = new PropertyDefinition(null, null, null);
        PropertyRegistry.populateTraversals();
    }

    static final class PropertyDefinition {
        private final PropertyCollector.SelectionSpec[] _traversalSpecFilter;
        private final PropertyCollector.SelectionSpec[] _traversalSpecSelect;
        private final Collection<String> _foreignKeyModels;

        PropertyDefinition(PropertyCollector.SelectionSpec[] traversalSpecFilter, PropertyCollector.SelectionSpec[] traversalSpecSelect, Collection<String> foreignKeyModels) {
            this._traversalSpecFilter = traversalSpecFilter;
            this._traversalSpecSelect = traversalSpecSelect;
            this._foreignKeyModels = foreignKeyModels;
        }

        public PropertyCollector.SelectionSpec[] getFilterSpecForPredicate() {
            return this._traversalSpecFilter;
        }

        public PropertyCollector.SelectionSpec[] getFilterSpecForSelect() {
            return this._traversalSpecSelect;
        }

        public Collection<String> getForeignKeyModels() {
            return this._foreignKeyModels;
        }
    }

    static final class ModelDefinition {
        final Map<String, PropertyDefinition> _propertiesByName;

        ModelDefinition(Map<String, PropertyDefinition> propertiesByName) {
            assert (propertiesByName != null);
            this._propertiesByName = Collections.unmodifiableMap(propertiesByName);
        }

        PropertyDefinition getPropertyDefinition(String property) {
            Validate.notNull((Object)property);
            return this._propertiesByName.get(property);
        }
    }
}

