/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.pc;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.adapters.pc.FormulaRegistry;
import com.vmware.cis.data.internal.adapters.pc.PropertyRegistry;
import com.vmware.cis.data.internal.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

final class QueryAnalyzer {
    QueryAnalyzer() {
    }

    public static QueryAnalysis analyzeQuery(Query query) {
        QueryAnalyzer.validateQuery(query);
        String model = (String)query.getResourceModels().iterator().next();
        LinkedHashSet<String> nativeProperties = new LinkedHashSet<String>();
        LinkedHashSet<String> foreignKeyProperties = new LinkedHashSet<String>();
        LinkedHashMap<String, FormulaRegistry.Formula> formulasByProperty = new LinkedHashMap<String, FormulaRegistry.Formula>();
        ArrayList<PropertyPredicate> morPredicates = new ArrayList<PropertyPredicate>();
        ArrayList<PropertyPredicate> clientSidePredicates = new ArrayList<PropertyPredicate>();
        for (String property : query.getProperties()) {
            if (PropertyUtil.isModelKey((String)property)) continue;
            PropertyRegistry.PropertyDefinition definition = PropertyRegistry.getPropertyDefinition(model, property);
            if (definition.getFilterSpecForSelect() != null) {
                foreignKeyProperties.add(property);
                continue;
            }
            FormulaRegistry.Formula formula = FormulaRegistry.getComputedProperty(model, property);
            if (formula == null) {
                nativeProperties.add(property);
                continue;
            }
            nativeProperties.addAll(formula.getRequiredProperties());
            formulasByProperty.put(property, formula);
        }
        Filter filter = query.getFilter();
        boolean joinByAnd = true;
        if (filter != null) {
            joinByAnd = filter.getOperator().equals((Object)LogicalOperator.AND);
            List predicates = filter.getCriteria();
            for (PropertyPredicate predicate : predicates) {
                String property = predicate.getProperty();
                if (PropertyUtil.isModelKey((String)property)) {
                    morPredicates.add(predicate);
                    continue;
                }
                PropertyRegistry.PropertyDefinition definition = PropertyRegistry.getPropertyDefinition(model, property);
                if (definition.getFilterSpecForPredicate() != null) {
                    morPredicates.add(predicate);
                    continue;
                }
                FormulaRegistry.Formula formula = FormulaRegistry.getComputedProperty(model, property);
                if (formula != null) {
                    nativeProperties.addAll(formula.getRequiredProperties());
                    formulasByProperty.put(property, formula);
                }
                clientSidePredicates.add(predicate);
            }
        }
        SortCriterion.SortDirection sortDirection = null;
        if (!query.getSortCriteria().isEmpty()) {
            sortDirection = ((SortCriterion)query.getSortCriteria().get(0)).getSortDirection();
        }
        return new QueryAnalysis(model, nativeProperties, foreignKeyProperties, morPredicates, clientSidePredicates, sortDirection, formulasByProperty, joinByAnd);
    }

    static void validateQuery(Query query) {
        String property;
        if (query.getResourceModels().size() != 1) {
            throw new IllegalArgumentException("Only one model supported");
        }
        if (query.getSortCriteria().size() > 1) {
            throw new IllegalArgumentException("At most one sort criterion supported");
        }
        if (query.getSortCriteria().size() == 1 && !PropertyUtil.isModelKey((String)(property = ((SortCriterion)query.getSortCriteria().get(0)).getProperty()))) {
            throw new IllegalArgumentException("Only sort by @modelKey allowed");
        }
        if (query.getFilter() == null) {
            return;
        }
        for (PropertyPredicate predicate : query.getFilter().getCriteria()) {
            PropertyPredicate.ComparisonOperator operator = predicate.getOperator();
            if (operator.equals((Object)PropertyPredicate.ComparisonOperator.EQUAL) || operator.equals((Object)PropertyPredicate.ComparisonOperator.IN)) continue;
            throw new IllegalArgumentException("Only EQUAL and IN operators supported");
        }
    }

    public static final class QueryAnalysis {
        private final String _model;
        private final Collection<String> _nativeProperties;
        private final Collection<String> _foreignKeyProperties;
        private final List<PropertyPredicate> _morPredicates;
        private final List<PropertyPredicate> _clientSidePredicates;
        private final Map<String, FormulaRegistry.Formula> _formulasByProperty;
        private final SortCriterion.SortDirection _sortDirection;
        private final boolean _isIntersection;

        QueryAnalysis(String model, Collection<String> nativeProperties, Collection<String> foreignKeyProperties, List<PropertyPredicate> morPredicates, List<PropertyPredicate> clientSidePredicates, SortCriterion.SortDirection sortDirection, Map<String, FormulaRegistry.Formula> formulasByProperty, boolean joinByAnd) {
            this._model = model;
            this._nativeProperties = nativeProperties;
            this._foreignKeyProperties = foreignKeyProperties;
            this._formulasByProperty = formulasByProperty;
            this._morPredicates = morPredicates;
            this._clientSidePredicates = clientSidePredicates;
            this._sortDirection = sortDirection;
            this._isIntersection = joinByAnd;
        }

        public String getModel() {
            return this._model;
        }

        public Collection<String> getNativeProperties() {
            return this._nativeProperties;
        }

        public Collection<String> getForeignKeyProperties() {
            return this._foreignKeyProperties;
        }

        public Collection<PropertyPredicate> getMorPredicates() {
            return this._morPredicates;
        }

        public List<PropertyPredicate> getClientSidePredicates() {
            return this._clientSidePredicates;
        }

        public SortCriterion.SortDirection getSortDirection() {
            return this._sortDirection;
        }

        public Map<String, FormulaRegistry.Formula> getFormulas() {
            return this._formulasByProperty;
        }

        public boolean isIntersection() {
            return this._isIntersection;
        }
    }
}

