/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.internal.adapters.tagging.FilteringPropertyProvider;
import com.vmware.cis.data.internal.adapters.tagging.LenientTaggingFacade;
import com.vmware.cis.data.internal.provider.util.filter.OperatorLikeEvaluator;
import com.vmware.cis.data.internal.provider.util.filter.PredicateEvaluator;
import com.vmware.cis.tagging.TagModel;
import java.util.ArrayList;
import java.util.List;

final class TagModelFilteringPropertyProvider
implements FilteringPropertyProvider {
    private final LenientTaggingFacade _tagging;

    TagModelFilteringPropertyProvider(LenientTaggingFacade tagging) {
        assert (tagging != null);
        this._tagging = tagging;
    }

    @Override
    public List<String> getKeys(PropertyPredicate predicate) {
        String tagNamePattern;
        boolean needExtraFiltering;
        assert (predicate != null);
        if (!"com.vmware.cis.tagging.TagModel/name".equals(predicate.getProperty())) {
            return null;
        }
        if (!PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)predicate.getOperator()) && !PropertyPredicate.ComparisonOperator.LIKE.equals((Object)predicate.getOperator())) {
            return null;
        }
        if (!(predicate.getComparableValue() instanceof String)) {
            return null;
        }
        String comparable = (String)predicate.getComparableValue();
        if (PropertyPredicate.ComparisonOperator.LIKE.equals((Object)predicate.getOperator())) {
            OperatorLikeEvaluator.StringMatchingInfo matchInfo = OperatorLikeEvaluator.analyzeTemplate((String)comparable);
            needExtraFiltering = !OperatorLikeEvaluator.StringMatchingMode.Contains.equals((Object)matchInfo.getMode()) || !predicate.isIgnoreCase();
            tagNamePattern = matchInfo.getSearchText();
        } else {
            needExtraFiltering = true;
            tagNamePattern = comparable;
        }
        List<String> tagIds = this._tagging.findTagsByName(tagNamePattern);
        if (!needExtraFiltering) {
            return tagIds;
        }
        List<TagModel> tagModels = this._tagging.getTags(tagIds);
        ArrayList<String> filtered = new ArrayList<String>(tagIds.size());
        for (TagModel tagModel : tagModels) {
            if (!PredicateEvaluator.eval((PropertyPredicate)predicate, (Object)tagModel.getName())) continue;
            filtered.add(tagModel.getId());
        }
        return filtered;
    }
}

