/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.adapters.tagging.LenientTaggingFacade;
import com.vmware.cis.data.internal.adapters.tagging.PropertyProvider;
import com.vmware.cis.tagging.CategoryModel;
import com.vmware.cis.tagging.TagModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

final class TagModelPropertyProvider
implements PropertyProvider {
    private final LenientTaggingFacade _tagging;

    public static Map<String, QuerySchema.PropertyInfo> getProperties() {
        HashMap<String, QuerySchema.PropertyInfo> properties = new HashMap<String, QuerySchema.PropertyInfo>();
        properties.put("com.vmware.cis.tagging.TagModel/id", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID));
        properties.put("com.vmware.cis.tagging.TagModel/categoryId", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID));
        properties.put("com.vmware.cis.tagging.TagModel/name", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        properties.put("com.vmware.cis.tagging.TagModel/description", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        properties.put("com.vmware.cis.tagging.TagModel/categoryName", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        properties.put("com.vmware.cis.tagging.TagModel/usedBy", QuerySchema.PropertyInfo.forNonFilterableProperty());
        return Collections.unmodifiableMap(properties);
    }

    TagModelPropertyProvider(LenientTaggingFacade tagging) {
        assert (tagging != null);
        this._tagging = tagging;
    }

    @Override
    public List<Object> get(String modelKey, List<String> properties) {
        assert (modelKey != null);
        assert (properties != null);
        TagModel tagModel = this._tagging.getTag(modelKey);
        return this.getItem(tagModel, properties);
    }

    @Override
    public List<List<Object>> get(List<String> modelKeys, List<String> properties) {
        assert (modelKeys != null);
        assert (properties != null);
        List<TagModel> tagModels = this._tagging.getTags(modelKeys);
        if (properties.contains("com.vmware.cis.tagging.TagModel/categoryName")) {
            HashSet<String> categoryIds = new HashSet<String>();
            for (TagModel tagModel : tagModels) {
                categoryIds.add(tagModel.getCategoryId());
            }
            this._tagging.getCategories(new ArrayList<String>(categoryIds));
        }
        return this.getItems(tagModels, properties);
    }

    @Override
    public List<List<Object>> list(List<String> properties) {
        assert (properties != null);
        List<TagModel> tagModels = this._tagging.getAllTags();
        if (properties.contains("com.vmware.cis.tagging.TagModel/categoryName")) {
            this._tagging.getAllCategories();
        }
        return this.getItems(tagModels, properties);
    }

    private List<List<Object>> getItems(List<TagModel> tagModels, List<String> properties) {
        assert (tagModels != null);
        assert (properties != null);
        ArrayList<List<Object>> items = new ArrayList<List<Object>>(tagModels.size());
        for (TagModel tagModel : tagModels) {
            List<Object> item = this.getItem(tagModel, properties);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    private List<Object> getItem(TagModel tagModel, List<String> properties) {
        assert (properties != null);
        if (tagModel == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>(properties.size());
        for (String property : properties) {
            Object value = this.getProperty(tagModel, property);
            values.add(value);
        }
        return values;
    }

    private Object getProperty(TagModel tagModel, String property) {
        assert (tagModel != null);
        assert (property != null);
        switch (property) {
            case "@modelKey": {
                return tagModel.getId();
            }
            case "@type": {
                return "com.vmware.cis.tagging.Tag";
            }
            case "com.vmware.cis.tagging.TagModel/id": {
                return tagModel.getId();
            }
            case "com.vmware.cis.tagging.TagModel/categoryId": {
                return tagModel.getCategoryId();
            }
            case "com.vmware.cis.tagging.TagModel/name": {
                return tagModel.getName();
            }
            case "com.vmware.cis.tagging.TagModel/description": {
                return tagModel.getDescription();
            }
            case "com.vmware.cis.tagging.TagModel/usedBy": {
                return tagModel.getUsedBy();
            }
            case "com.vmware.cis.tagging.TagModel/categoryName": {
                return this.getCategoryName(tagModel);
            }
        }
        throw new IllegalArgumentException("Unknown property : " + property);
    }

    private String getCategoryName(TagModel tagModel) {
        assert (tagModel != null);
        String categoryId = tagModel.getCategoryId();
        CategoryModel categoryModel = this._tagging.getCategory(categoryId);
        if (categoryModel == null) {
            return null;
        }
        return categoryModel.getName();
    }
}

