/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.util.vapi;

import com.vmware.cis.data.internal.adapters.util.vapi.VapiSession;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiSessionSource;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenewableVapiSession
implements VapiSession {
    private static Logger _logger = LoggerFactory.getLogger(RenewableVapiSession.class);
    private final VapiSessionSource _authenticator;
    private final AtomicReference<char[]> _sessionId;

    public RenewableVapiSession(VapiSessionSource authenticator) {
        assert (authenticator != null);
        this._authenticator = authenticator;
        this._sessionId = new AtomicReference<char[]>(authenticator.createSession());
    }

    @Override
    public char[] get() {
        char[] current = this._sessionId.get();
        this.validateIsOpen(current);
        return current;
    }

    @Override
    public char[] renew(char[] expired) {
        assert (expired != null);
        char[] current = this._sessionId.get();
        this.validateIsOpen(current);
        if (current != expired) {
            return current;
        }
        char[] fresh = this._authenticator.createSession();
        boolean changed = this._sessionId.compareAndSet(current, fresh);
        if (changed) {
            _logger.debug("Renewed session from {}", (Object)this._authenticator);
            return fresh;
        }
        _logger.debug("Destroying redundant new session from {} because somebody renewed the session before us", (Object)this._authenticator);
        this.silentLogout(fresh);
        return this.get();
    }

    @Override
    public void logout() {
        char[] session = this._sessionId.getAndSet(null);
        this.silentLogout(session);
    }

    private void silentLogout(char[] session) {
        try {
            this._authenticator.deleteSession(session);
        }
        catch (RuntimeException ex) {
            _logger.debug("Error while logging out session", (Throwable)ex);
        }
    }

    private void validateIsOpen(char[] session) {
        if (session == null) {
            throw new IllegalStateException("Session is closed");
        }
    }
}

