/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.util.vapi;

import com.vmware.cis.data.internal.adapters.util.vapi.VapiSession;
import com.vmware.vapi.protocol.ProtocolConnection;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionAwareVapiConnectionCloseable
implements AutoCloseable {
    private static Logger _logger = LoggerFactory.getLogger(SessionAwareVapiConnectionCloseable.class);
    private final ProtocolConnection _connection;
    private final VapiSession _session;

    public SessionAwareVapiConnectionCloseable(ProtocolConnection connection, VapiSession session) {
        Validate.notNull((Object)connection);
        Validate.notNull((Object)session);
        this._connection = connection;
        this._session = session;
    }

    @Override
    public void close() throws Exception {
        try {
            this._session.logout();
        }
        catch (RuntimeException ex) {
            _logger.debug("Error while logging out session", (Throwable)ex);
        }
        try {
            this._connection.disconnect();
        }
        catch (RuntimeException ex) {
            _logger.debug("Error while closing connection", (Throwable)ex);
        }
    }
}

