/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vapi.impl;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.adapters.vapi.VapiPropertyValueConverter;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.provider.vapi.ResourceModelTypes;
import com.vmware.vapi.data.DataValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;

final class VapiDataProviderQueryConverter {
    private final VapiPropertyValueConverter _propertyValueConverter;

    VapiDataProviderQueryConverter(VapiPropertyValueConverter propertyValueConverter) {
        assert (propertyValueConverter != null);
        this._propertyValueConverter = propertyValueConverter;
    }

    public ResourceModelTypes.QuerySpec convertQuery(Query query) {
        Validate.notNull((Object)query);
        ResourceModelTypes.QuerySpec querySpec = new ResourceModelTypes.QuerySpec();
        querySpec.setResourceModels(VapiDataProviderQueryConverter.convertResourceModels(query.getResourceModels()));
        querySpec.setFilter(this.convertFilter(query.getFilter()));
        querySpec.setLimit(VapiDataProviderQueryConverter.convertLimit(query));
        querySpec.setOffset(VapiDataProviderQueryConverter.convertOffset(query));
        querySpec.setReturnTotalCount(Boolean.valueOf(query.getWithTotalCount()));
        if (query.getLimit() == 0) {
            querySpec.setProperties(PropertyUtil.PROPERTY_LIST_MODEL_KEY);
            querySpec.setSortCriteria(Collections.singletonList(VapiDataProviderQueryConverter.stubSortForTotalCountQuery()));
        } else {
            querySpec.setProperties(VapiDataProviderQueryConverter.convertProperties(query.getProperties()));
            querySpec.setSortCriteria(VapiDataProviderQueryConverter.convertSortCriteria(query.getSortCriteria()));
        }
        return querySpec;
    }

    private static List<String> convertResourceModels(Collection<String> resourceModels) {
        return new ArrayList<String>(resourceModels);
    }

    private static List<String> convertProperties(List<String> properties) {
        assert (properties != null);
        ArrayList<String> vapiProperties = new ArrayList<String>(properties.size());
        for (String property : properties) {
            vapiProperties.add(VapiDataProviderQueryConverter.convertProperty(property));
        }
        return vapiProperties;
    }

    private static List<ResourceModelTypes.SortCriterion> convertSortCriteria(List<SortCriterion> criteria) {
        assert (criteria != null);
        if (criteria.isEmpty()) {
            return null;
        }
        ArrayList<ResourceModelTypes.SortCriterion> vapiSortCriteria = new ArrayList<ResourceModelTypes.SortCriterion>(criteria.size());
        for (SortCriterion criterion : criteria) {
            vapiSortCriteria.add(VapiDataProviderQueryConverter.convertSortCriterion(criterion));
        }
        return vapiSortCriteria;
    }

    private static ResourceModelTypes.SortCriterion convertSortCriterion(SortCriterion criterion) {
        assert (criterion != null);
        assert (criterion.getProperty() != null);
        assert (criterion.getProperty().length() > 0);
        assert (criterion.getSortDirection() != null);
        ResourceModelTypes.SortCriterion vapiSort = new ResourceModelTypes.SortCriterion();
        vapiSort.setProperty(VapiDataProviderQueryConverter.convertProperty(criterion.getProperty()));
        vapiSort.setSortDirection(VapiDataProviderQueryConverter.convertSortDirection(criterion.getSortDirection()));
        vapiSort.setIgnoreCase(criterion.isIgnoreCase() ? Boolean.TRUE : null);
        return vapiSort;
    }

    private static ResourceModelTypes.SortCriterion.SortDirection convertSortDirection(SortCriterion.SortDirection sortDirection) {
        assert (sortDirection != null);
        switch (sortDirection) {
            case ASCENDING: {
                return ResourceModelTypes.SortCriterion.SortDirection.ASCENDING;
            }
            case DESCENDING: {
                return ResourceModelTypes.SortCriterion.SortDirection.DESCENDING;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported sort direction: '%s'", sortDirection.name()));
    }

    private ResourceModelTypes.Filter convertFilter(Filter filter) {
        if (filter == null) {
            return null;
        }
        ResourceModelTypes.Filter vapiFilter = new ResourceModelTypes.Filter();
        vapiFilter.setOperator(VapiDataProviderQueryConverter.convertLogicalOperator(filter.getOperator()));
        vapiFilter.setCriteria(this.convertPropertyPredicates(filter.getCriteria()));
        return vapiFilter;
    }

    private List<ResourceModelTypes.PropertyPredicate> convertPropertyPredicates(List<PropertyPredicate> predicates) {
        assert (predicates != null);
        assert (predicates.size() > 0);
        ArrayList<ResourceModelTypes.PropertyPredicate> vapiPredicates = new ArrayList<ResourceModelTypes.PropertyPredicate>(predicates.size());
        for (PropertyPredicate predicate : predicates) {
            vapiPredicates.add(this.convertPropertyPredicate(predicate));
        }
        return vapiPredicates;
    }

    private ResourceModelTypes.PropertyPredicate convertPropertyPredicate(PropertyPredicate predicate) {
        assert (predicate != null);
        String property = predicate.getProperty();
        Object comparableValue = predicate.getComparableValue();
        PropertyPredicate.ComparisonOperator operator = predicate.getOperator();
        ResourceModelTypes.PropertyPredicate vapiPredicate = new ResourceModelTypes.PropertyPredicate();
        vapiPredicate.setProperty(VapiDataProviderQueryConverter.convertProperty(property));
        vapiPredicate.setOperator(VapiDataProviderQueryConverter.convertComparisonOperator(operator));
        vapiPredicate.setIgnoreCase(predicate.isIgnoreCase() ? Boolean.TRUE : null);
        if (PropertyPredicate.ComparisonOperator.IN.equals((Object)predicate.getOperator())) {
            vapiPredicate.setComparableList(this.convertComparableList(predicate.getProperty(), comparableValue));
        } else {
            vapiPredicate.setComparableValue(this.convertComparableValue(predicate.getProperty(), comparableValue));
        }
        return vapiPredicate;
    }

    private List<DataValue> convertComparableList(String property, Object comparableValue) {
        assert (comparableValue instanceof List);
        return this._propertyValueConverter.toVapiComparableList(property, (List)comparableValue);
    }

    private DataValue convertComparableValue(String property, Object comparableValue) {
        assert (comparableValue != null);
        return this._propertyValueConverter.toVapiComparableValue(property, comparableValue);
    }

    private static ResourceModelTypes.PropertyPredicate.ComparisonOperator convertComparisonOperator(PropertyPredicate.ComparisonOperator operator) {
        assert (operator != null);
        switch (operator) {
            case EQUAL: {
                return ResourceModelTypes.PropertyPredicate.ComparisonOperator.EQUAL;
            }
            case NOT_EQUAL: {
                return ResourceModelTypes.PropertyPredicate.ComparisonOperator.NOT_EQUAL;
            }
            case GREATER: {
                return ResourceModelTypes.PropertyPredicate.ComparisonOperator.GREATER;
            }
            case GREATER_OR_EQUAL: {
                return ResourceModelTypes.PropertyPredicate.ComparisonOperator.GREATER_OR_EQUAL;
            }
            case LESS: {
                return ResourceModelTypes.PropertyPredicate.ComparisonOperator.LESS;
            }
            case LESS_OR_EQUAL: {
                return ResourceModelTypes.PropertyPredicate.ComparisonOperator.LESS_OR_EQUAL;
            }
            case IN: {
                return ResourceModelTypes.PropertyPredicate.ComparisonOperator.IN;
            }
            case LIKE: {
                return ResourceModelTypes.PropertyPredicate.ComparisonOperator.LIKE;
            }
            case UNSET: {
                return ResourceModelTypes.PropertyPredicate.ComparisonOperator.UNSET;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported comparison operator: '%s'", operator.name()));
    }

    private static ResourceModelTypes.Filter.LogicalOperator convertLogicalOperator(LogicalOperator operator) {
        assert (operator != null);
        switch (operator) {
            case AND: {
                return ResourceModelTypes.Filter.LogicalOperator.AND;
            }
            case OR: {
                return ResourceModelTypes.Filter.LogicalOperator.OR;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported logical operator: '%s'", operator.name()));
    }

    private static String convertProperty(String property) {
        return property;
    }

    private static Long convertLimit(Query query) {
        int limit = query.getLimit();
        if (limit < 0) {
            return null;
        }
        assert (query.getSortCriteria() != null);
        assert (query.getLimit() == 0 || query.getSortCriteria().size() > 0);
        return limit;
    }

    private static Long convertOffset(Query query) {
        assert (query.getOffset() >= 0);
        int offset = query.getOffset();
        if (offset == 0) {
            return null;
        }
        assert (query.getSortCriteria() != null);
        assert (query.getSortCriteria().size() > 0);
        return offset;
    }

    private static ResourceModelTypes.SortCriterion stubSortForTotalCountQuery() {
        ResourceModelTypes.SortCriterion sortCriterion = new ResourceModelTypes.SortCriterion();
        sortCriterion.setProperty("@modelKey");
        sortCriterion.setSortDirection(ResourceModelTypes.SortCriterion.SortDirection.ASCENDING);
        sortCriterion.setIgnoreCase(Boolean.FALSE);
        return sortCriterion;
    }
}

