/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vapi.impl;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.provider.metadata.vapi.SchemaTypes;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VapiDataProviderSchemaConverter {
    private static final Logger _logger = LoggerFactory.getLogger(VapiDataProviderSchemaConverter.class);

    VapiDataProviderSchemaConverter() {
    }

    public static QuerySchema convertSchema(SchemaTypes.SchemaInfo schemaInfo) {
        Validate.notNull((Object)schemaInfo);
        Map vapiModels = schemaInfo.getModels();
        HashMap<String, QuerySchema.ModelInfo> models = new HashMap<String, QuerySchema.ModelInfo>(vapiModels.size());
        for (String modelName : vapiModels.keySet()) {
            SchemaTypes.ModelInfo vapiModel = (SchemaTypes.ModelInfo)vapiModels.get(modelName);
            models.put(modelName, VapiDataProviderSchemaConverter.convertModelInfo(modelName, vapiModel));
        }
        return QuerySchema.forModels(models);
    }

    private static QuerySchema.ModelInfo convertModelInfo(String modelName, SchemaTypes.ModelInfo vapiModel) {
        Map vapiProperties = vapiModel.getProperties();
        HashMap<String, QuerySchema.PropertyInfo> properties = new HashMap<String, QuerySchema.PropertyInfo>(vapiProperties.size());
        for (String propertyName : vapiProperties.keySet()) {
            SchemaTypes.PropertyInfo vapiProperty = (SchemaTypes.PropertyInfo)vapiProperties.get(propertyName);
            try {
                properties.put(propertyName, VapiDataProviderSchemaConverter.convertProperty(modelName, propertyName, vapiProperty));
            }
            catch (Exception e) {
                String msg = String.format("There is an error in the registration of %s/%s.", modelName, propertyName);
                _logger.error(msg, (Throwable)e);
            }
        }
        return new QuerySchema.ModelInfo(properties);
    }

    private static QuerySchema.PropertyInfo convertProperty(String modelName, String propertyName, SchemaTypes.PropertyInfo vapiProperty) {
        boolean isPropertyFilterableByUnset;
        boolean isPropertyFilterable;
        boolean bl = isPropertyFilterable = vapiProperty.getFilterable() != null && vapiProperty.getFilterable() != false;
        if (isPropertyFilterable) {
            return VapiDataProviderSchemaConverter.convertFilterableProperty(modelName, propertyName, vapiProperty.getType());
        }
        boolean bl2 = isPropertyFilterableByUnset = vapiProperty.getFilterableByUnset() != null && vapiProperty.getFilterableByUnset() != false;
        if (isPropertyFilterableByUnset) {
            return QuerySchema.PropertyInfo.forFilterableByUnsetProperty();
        }
        return QuerySchema.PropertyInfo.forNonFilterableProperty();
    }

    private static QuerySchema.PropertyInfo convertFilterableProperty(String modelName, String propertyName, SchemaTypes.PropertyInfo.PropertyType propertyType) {
        if (propertyType == null) {
            String msg = String.format("Property %s/%s marked as filterable has invalid type: %s.", modelName, propertyName, propertyType);
            throw new IllegalArgumentException(msg);
        }
        switch (propertyType.getEnumValue()) {
            case STRING: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING);
            }
            case LONG: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.LONG);
            }
            case DOUBLE: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.DOUBLE);
            }
            case BOOLEAN: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.BOOLEAN);
            }
            case ID: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID);
            }
            case ENUM: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ENUM);
            }
        }
        String msg = String.format("Property %s/%s marked as filterable contains type that doesn't have a core equivalent: %s.", modelName, propertyName, propertyType);
        throw new IllegalArgumentException(msg);
    }
}

