/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vcenter;

import com.vmware.cis.data.internal.adapters.federation.FederationConnection;
import com.vmware.cis.data.internal.adapters.federation.InstanceUuidRouter;
import com.vmware.cis.data.internal.adapters.federation.RouterChain;
import com.vmware.cis.data.internal.adapters.federation.ServiceEndpointDiscovery;
import com.vmware.cis.data.internal.adapters.federation.Vmodl1ForeignKeyRouter;
import com.vmware.cis.data.internal.adapters.federation.Vmodl1ModelKeyRouter;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiDataProviderConfig;
import com.vmware.cis.data.internal.provider.profiler.DataProviderProfilerFactory;
import com.vmware.cis.data.internal.util.TaskExecutor;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.cis.data.provider.vcenter.VcenterDataProviderFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VcenterDataProviderFactoryDataProviders {
    private static final Logger _logger = LoggerFactory.getLogger(VcenterDataProviderFactoryDataProviders.class);
    private final Collection<VcenterDataProviderFactory> _providerFactories;
    private final ServiceLocator _serviceLocator;
    private final VmomiDataProviderConfig _vmomiCfg;
    private final ExecutorService _executor;
    private final long _providerOperationThreshold;

    public VcenterDataProviderFactoryDataProviders(Collection<VcenterDataProviderFactory> providerFactories, ServiceLocator serviceLocator, VmomiDataProviderConfig vmomiCfg, ExecutorService executor, long providerOperationThreshold) {
        Validate.notNull(providerFactories);
        Validate.notNull((Object)serviceLocator);
        Validate.notNull((Object)vmomiCfg);
        Validate.notNull((Object)executor);
        Validate.isTrue((providerOperationThreshold >= 0L ? 1 : 0) != 0);
        this._providerFactories = providerFactories;
        this._serviceLocator = serviceLocator;
        this._vmomiCfg = vmomiCfg;
        this._executor = executor;
        this._providerOperationThreshold = providerOperationThreshold;
    }

    public Collection<DataProvider> get() {
        if (this._providerFactories.isEmpty()) {
            _logger.info("No data provider factories found");
            return Collections.emptyList();
        }
        Set<String> vcGuids = ServiceEndpointDiscovery.getVcGuids(this._serviceLocator, this._vmomiCfg);
        if (vcGuids.isEmpty()) {
            _logger.info("No VC servers found. Will not create data providers via data provider factories.");
            return Collections.emptyList();
        }
        _logger.info("Creating data providers via data provider factories for VC servers: {}", vcGuids);
        ArrayList<DataProvider> federations = new ArrayList<DataProvider>(this._providerFactories.size());
        for (VcenterDataProviderFactory providerFactory : this._providerFactories) {
            federations.add(this.federate(providerFactory, vcGuids));
        }
        return federations;
    }

    private DataProvider federate(VcenterDataProviderFactory providerFactory, Set<String> vcGuids) {
        assert (providerFactory != null);
        assert (!vcGuids.isEmpty());
        ArrayList<FederationConnection.FederatedProviderInfo> nodes = new ArrayList<FederationConnection.FederatedProviderInfo>(vcGuids.size());
        for (String vcGuid : vcGuids) {
            DataProvider dataProvider = this.providerForVc(providerFactory, vcGuid);
            if (dataProvider == null) continue;
            nodes.add(new FederationConnection.FederatedProviderInfo(dataProvider.toString(), vcGuid, DataProviderProfilerFactory.profileProvider((DataProvider)dataProvider, (long)this._providerOperationThreshold)));
        }
        return this.federate(nodes);
    }

    private DataProvider providerForVc(VcenterDataProviderFactory providerFactory, String vcGuid) {
        assert (providerFactory != null);
        assert (vcGuid != null);
        DataProvider dataProvider = null;
        try {
            dataProvider = providerFactory.getDataProviderForVcenter(vcGuid);
        }
        catch (RuntimeException ex) {
            _logger.error("Failed to create data provider via factory '{}' for VC '{}'", new Object[]{providerFactory.getClass(), vcGuid, ex});
            return null;
        }
        if (dataProvider == null) {
            _logger.error("No data provider via factory '{}' for VC '{}'", providerFactory.getClass(), (Object)vcGuid);
        } else {
            _logger.debug("Created data provider for VC '{}' : '{}'", (Object)vcGuid, (Object)dataProvider);
        }
        return dataProvider;
    }

    private DataProvider federate(List<FederationConnection.FederatedProviderInfo> nodes) {
        assert (nodes != null);
        assert (!nodes.isEmpty());
        RouterChain queryRouter = new RouterChain(new InstanceUuidRouter(), new Vmodl1ModelKeyRouter(), new Vmodl1ForeignKeyRouter());
        FederationConnection federation = new FederationConnection(queryRouter, new TaskExecutor(this._executor, TaskExecutor.ErrorHandlingPolicy.LENIENT), nodes);
        return federation;
    }
}

