/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vcenter;

import com.vmware.cis.data.internal.adapters.customfield.CustomFieldDataProvider;
import com.vmware.cis.data.internal.adapters.federation.DynamicIdForeignKeyRouter;
import com.vmware.cis.data.internal.adapters.federation.FederationDataProvider;
import com.vmware.cis.data.internal.adapters.federation.IdentifiableServiceInstance;
import com.vmware.cis.data.internal.adapters.federation.InstanceUuidRouter;
import com.vmware.cis.data.internal.adapters.federation.QueryRouter;
import com.vmware.cis.data.internal.adapters.federation.RouterChain;
import com.vmware.cis.data.internal.adapters.federation.ServiceEndpointDiscovery;
import com.vmware.cis.data.internal.adapters.federation.Vmodl1ForeignKeyRouter;
import com.vmware.cis.data.internal.adapters.federation.Vmodl1ModelKeyRouter;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.adapters.tagging.TagAssociationDataProvider;
import com.vmware.cis.data.internal.adapters.tagging.TagDataProvider;
import com.vmware.cis.data.internal.adapters.tagging.TaggingDiscovery;
import com.vmware.cis.data.internal.adapters.util.vapi.SharedProtocolConnectionFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiAuthenticator;
import com.vmware.cis.data.internal.adapters.vapi.VapiDataProviderConfig;
import com.vmware.cis.data.internal.adapters.vapi.impl.VapiDataProvider;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticator;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiDataProviderConfig;
import com.vmware.cis.data.internal.adapters.vmomi.impl.SharedHttpConfigurationFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VlsiClientUtil;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProvider;
import com.vmware.cis.data.internal.provider.DataProviderConnector;
import com.vmware.cis.data.internal.provider.profiler.DataProviderProfilerFactory;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VcenterDataProviders {
    private static final Logger logger = LoggerFactory.getLogger(VcenterDataProviders.class);
    public static final long DEFAULT_DATA_PROVIDER_OPERATION_THRESHOLD = 2000L;
    public static final long DEFAULT_DATA_PROVIDER_LOGIN_THRESHOLD = 30000L;
    private static final String ENDPOINT_DATA_PROVIDER = "com.vmware.cis.data.provider";
    private final ServiceLocator _serviceLocator;
    private final ExecutorService _executorService;
    private final long _providerLoginThreshold;
    private final long _providerOperationThreshold;
    private final VmomiDataProviderConfig _vmomiCfg;
    private final VapiDataProviderConfig _vapiCfg;
    private volatile Collection<DataProviderConnector> _providerConnectors;

    private VcenterDataProviders(ServiceLocator serviceLocator, ExecutorService executorService, long providerLoginThreshold, long providerOperationThreshold, VmomiDataProviderConfig vmomiCfg, VapiDataProviderConfig vapiCfg) {
        assert (serviceLocator != null);
        assert (vmomiCfg != null);
        assert (vapiCfg != null);
        this._serviceLocator = serviceLocator;
        this._executorService = executorService;
        this._providerLoginThreshold = providerLoginThreshold;
        this._providerOperationThreshold = providerOperationThreshold;
        this._vmomiCfg = vmomiCfg;
        this._vapiCfg = vapiCfg;
    }

    public static Builder fromLocator(ServiceLocator serviceLocator) {
        return new Builder(serviceLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataProviderConnector> getProviderConnectors() {
        Collection<DataProviderConnector> providerConnectors = this._providerConnectors;
        if (providerConnectors != null) {
            return providerConnectors;
        }
        VcenterDataProviders vcenterDataProviders = this;
        synchronized (vcenterDataProviders) {
            providerConnectors = this._providerConnectors;
            if (providerConnectors == null) {
                this._providerConnectors = providerConnectors = this.createDefaultSet();
            }
            return providerConnectors;
        }
    }

    private Collection<DataProviderConnector> createDefaultSet() {
        List<DataProviderConnector> providerConnectors = this.createProviderConnectorsForServices();
        return Collections.unmodifiableCollection(providerConnectors);
    }

    private List<DataProviderConnector> createProviderConnectorsForServices() {
        Collection<ServiceEndpointInfo> providerEndpoints = VcenterDataProviders.findDataProviderEndpoints(this._serviceLocator);
        Collection<ServiceEndpointInfo> vpxdEndpoints = ServiceEndpointDiscovery.filterByServiceType(providerEndpoints, ServiceEndpointDiscovery.PROVIDER_TYPE_VC);
        Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode = ServiceEndpointDiscovery.createVpxdInstanceIdPerNode(vpxdEndpoints, this._vmomiCfg.getVmodlContext(), this._vmomiCfg.getVlsiHttpConfigFactory());
        Collection<ServiceEndpointInfo> nonLegacyEndpoints = ServiceEndpointDiscovery.onlySupported(providerEndpoints, vpxdInstanceIdByNode);
        Map<String, List<ProviderAtNode>> providersByService = this.createNonFederatedProvidersPerServiceType(nonLegacyEndpoints);
        ArrayList<DataProviderConnector> federatedGroups = new ArrayList<DataProviderConnector>(providersByService.size());
        for (Map.Entry<String, List<ProviderAtNode>> entry : providersByService.entrySet()) {
            String serviceType = entry.getKey();
            List<ProviderAtNode> providersData = entry.getValue();
            ArrayList<FederationDataProvider.FederatedInstanceInfo> federatedInstances = new ArrayList<FederationDataProvider.FederatedInstanceInfo>(providersData.size());
            for (ProviderAtNode providerAtNode : providersData) {
                ServiceEndpointInfo endpoint = providerAtNode.endpoint;
                String mnemonicName = endpoint.getServiceType() + "@" + endpoint.getUrl();
                DataProviderConnector provider = providerAtNode.provider;
                IdentifiableServiceInstance instanceId = vpxdInstanceIdByNode.get(providerAtNode.nodeId);
                federatedInstances.add(new FederationDataProvider.FederatedInstanceInfo(mnemonicName, instanceId, provider));
            }
            QueryRouter queryRouter = ServiceEndpointDiscovery.PROVIDER_TYPE_VC.equals(serviceType) && federatedInstances.size() > 1 ? new RouterChain(new InstanceUuidRouter(), new Vmodl1ModelKeyRouter(), new Vmodl1ForeignKeyRouter()) : new InstanceUuidRouter();
            FederationDataProvider dataProvider = new FederationDataProvider(queryRouter, this._executorService, federatedInstances);
            federatedGroups.add(dataProvider);
        }
        this.addTaggingProviders(federatedGroups, vpxdInstanceIdByNode);
        this.addCustomFieldProviders(federatedGroups, vpxdInstanceIdByNode);
        return federatedGroups;
    }

    private static Collection<ServiceEndpointInfo> findDataProviderEndpoints(ServiceLocator serviceLocator) {
        assert (serviceLocator != null);
        Collection<ServiceEndpointInfo> endpointInfos = serviceLocator.findServiceEndpoints(null, null, ENDPOINT_DATA_PROVIDER, null);
        HashSet<String> seenServices = new HashSet<String>();
        for (ServiceEndpointInfo info : endpointInfos) {
            seenServices.add(info.getServiceType());
        }
        ArrayList<ServiceEndpointInfo> wellKnownEndpoinInfos = new ArrayList<ServiceEndpointInfo>();
        if (!seenServices.contains(ServiceEndpointDiscovery.PROVIDER_TYPE_VC)) {
            Collection<ServiceEndpointInfo> vcEndpoints = ServiceEndpointDiscovery.findVcEndpoints(serviceLocator);
            wellKnownEndpoinInfos.addAll(vcEndpoints);
        }
        if (!seenServices.contains(ServiceEndpointDiscovery.PROVIDER_TYPE_CLS)) {
            Collection<ServiceEndpointInfo> clsEndpoints = ServiceEndpointDiscovery.findClsEndpoints(serviceLocator);
            wellKnownEndpoinInfos.addAll(clsEndpoints);
        }
        if (!wellKnownEndpoinInfos.isEmpty()) {
            ArrayList<ServiceEndpointInfo> combinedEndpoints = new ArrayList<ServiceEndpointInfo>(endpointInfos);
            combinedEndpoints.addAll(wellKnownEndpoinInfos);
            return combinedEndpoints;
        }
        return endpointInfos;
    }

    private Map<String, List<ProviderAtNode>> createNonFederatedProvidersPerServiceType(Collection<ServiceEndpointInfo> providerEndpoints) {
        HashMap<String, List<ProviderAtNode>> providersByService = new HashMap<String, List<ProviderAtNode>>();
        for (ServiceEndpointInfo endpoint : providerEndpoints) {
            String nodeId = endpoint.getNodeId();
            if (nodeId == null) {
                logger.error("No nodeId was discovered for endpoint [service = {}, url = {}]. The data provider at this endpoint will not be connected.", (Object)endpoint.getServiceType(), (Object)endpoint.getUrl());
                continue;
            }
            DataProviderConnector dataProvider = this.createProviderForEndpoint(endpoint);
            logger.debug("Created data adapter for data provider of type '{}' at {}", (Object)endpoint.getServiceType(), (Object)endpoint.getUrl());
            String serviceType = endpoint.getServiceType();
            if (!providersByService.containsKey(serviceType)) {
                providersByService.put(serviceType, new ArrayList());
            }
            ((List)providersByService.get(serviceType)).add(new ProviderAtNode(endpoint, dataProvider, nodeId));
        }
        return providersByService;
    }

    private DataProviderConnector createProviderForEndpoint(ServiceEndpointInfo endpointInfo) {
        String protocolName;
        Validate.notNull((Object)endpointInfo);
        switch (protocolName = endpointInfo.getEndpointProtocol()) {
            case "vmomi": {
                return this.profileConnector(this.createVmomiAdapter(endpointInfo));
            }
            case "vapi.json.https": 
            case "vapi.json.http": {
                return this.profileConnector(this.createVapiAdapter(endpointInfo));
            }
        }
        throw new IllegalArgumentException(String.format("Data provider endpoint '%s' has unknown protocol '%s'", endpointInfo.getUrl(), protocolName));
    }

    private DataProviderConnector createVmomiAdapter(ServiceEndpointInfo endpoint) {
        URI url = endpoint.getUrl();
        KeyStore trustStore = endpoint.getTrustStore();
        VmomiAuthenticator authenticator = this._vmomiCfg.getAuthenticatorFactory().getAuthenticator(endpoint);
        VmomiDataProvider vmomiProvider = new VmomiDataProvider(this._vmomiCfg, url, trustStore, authenticator);
        return vmomiProvider;
    }

    private DataProviderConnector createVapiAdapter(ServiceEndpointInfo endpoint) {
        VapiAuthenticator authenticator = this._vapiCfg.getAuthenticatorFactory().getAuthenticator(endpoint);
        VapiDataProvider vapiProvider = new VapiDataProvider(endpoint.getUrl(), endpoint.getTrustStore(), this._vapiCfg, authenticator);
        return vapiProvider;
    }

    private void addTaggingProviders(Collection<DataProviderConnector> providers, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        Collection<ServiceEndpointInfo> taggingEndpoints;
        try {
            taggingEndpoints = TaggingDiscovery.findTaggingEndpoints(this._serviceLocator);
        }
        catch (Exception e) {
            logger.warn("Exception caught while creating Tagging data providers. Tagging data will not be available.", (Throwable)e);
            return;
        }
        taggingEndpoints = ServiceEndpointDiscovery.onlySupported(taggingEndpoints, vpxdInstanceIdByNode);
        if (taggingEndpoints.isEmpty()) {
            logger.info("No Tagging API endpoints found. Tagging will not be available.");
        } else {
            this.addTagDataProvider(providers, taggingEndpoints);
            this.addTagAssociationDataProvider(providers, taggingEndpoints, vpxdInstanceIdByNode);
        }
    }

    private void addTagDataProvider(Collection<DataProviderConnector> providers, Collection<ServiceEndpointInfo> taggingServiceEndpoints) {
        ServiceEndpointInfo taggingEndpoint = TaggingDiscovery.chooseEndpointForTagAndCategoryData(taggingServiceEndpoints);
        TagDataProvider tagging = new TagDataProvider(this._vapiCfg.getVApiConnectionFactory(), taggingEndpoint.getUrl(), taggingEndpoint.getTrustStore());
        providers.add(this.profileConnector(tagging));
        logger.debug("Created data adapter for tag and category data at {}", (Object)taggingEndpoint.getUrl());
    }

    private void addTagAssociationDataProvider(Collection<DataProviderConnector> providers, Collection<ServiceEndpointInfo> taggingServiceEndpoints, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        ArrayList<FederationDataProvider.FederatedInstanceInfo> associationProviderInfos = new ArrayList<FederationDataProvider.FederatedInstanceInfo>();
        for (ServiceEndpointInfo endpointInfo : taggingServiceEndpoints) {
            TagAssociationDataProvider associationProvider = new TagAssociationDataProvider(this._vapiCfg.getVApiConnectionFactory(), endpointInfo.getUrl(), endpointInfo.getTrustStore());
            String nodeId = endpointInfo.getNodeId();
            IdentifiableServiceInstance vpxdInstanceId = vpxdInstanceIdByNode.get(nodeId);
            FederationDataProvider.FederatedInstanceInfo instanceInfo = new FederationDataProvider.FederatedInstanceInfo("TagAssociations@" + endpointInfo.getUrl(), vpxdInstanceId, this.profileConnector(associationProvider));
            associationProviderInfos.add(instanceInfo);
            logger.debug("Created data adapter for tag association data at {}", (Object)endpointInfo.getUrl());
        }
        RouterChain router = new RouterChain(new InstanceUuidRouter(), new DynamicIdForeignKeyRouter());
        FederationDataProvider federatedAssoctionProvider = new FederationDataProvider(router, this._executorService, associationProviderInfos);
        providers.add(federatedAssoctionProvider);
    }

    private void addCustomFieldProviders(Collection<DataProviderConnector> providers, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        Collection<ServiceEndpointInfo> vcEndpoints = ServiceEndpointDiscovery.findVcEndpoints(this._serviceLocator);
        if ((vcEndpoints = ServiceEndpointDiscovery.onlySupported(vcEndpoints, vpxdInstanceIdByNode)).isEmpty()) {
            logger.info("No VIM API endpoints found. Custom fields will not be available.");
            return;
        }
        ArrayList<FederationDataProvider.FederatedInstanceInfo> instanceInfos = new ArrayList<FederationDataProvider.FederatedInstanceInfo>();
        for (ServiceEndpointInfo endpointInfo : vcEndpoints) {
            VmomiAuthenticator authenticator = this._vmomiCfg.getAuthenticatorFactory().getAuthenticator(endpointInfo);
            CustomFieldDataProvider customFieldProvider = new CustomFieldDataProvider(this._vmomiCfg.getVmodlContext(), this._vmomiCfg.getVlsiHttpConfigFactory(), endpointInfo.getUrl(), endpointInfo.getTrustStore(), authenticator);
            String nodeId = endpointInfo.getNodeId();
            IdentifiableServiceInstance fakeInstanceId = vpxdInstanceIdByNode.get(nodeId);
            FederationDataProvider.FederatedInstanceInfo instanceInfo = new FederationDataProvider.FederatedInstanceInfo("CustomFields@" + endpointInfo.getUrl(), fakeInstanceId, this.profileConnector(customFieldProvider));
            instanceInfos.add(instanceInfo);
            logger.debug("Created data adapter for custom fields data at {}", (Object)endpointInfo.getUrl());
        }
        InstanceUuidRouter router = new InstanceUuidRouter();
        FederationDataProvider federated = new FederationDataProvider(router, this._executorService, instanceInfos);
        providers.add(federated);
    }

    private DataProviderConnector profileConnector(DataProviderConnector providerConnector) {
        return DataProviderProfilerFactory.profileConnector((DataProviderConnector)providerConnector, (long)this._providerLoginThreshold, (long)this._providerOperationThreshold);
    }

    private static final class ProviderAtNode {
        public final ServiceEndpointInfo endpoint;
        public final DataProviderConnector provider;
        public final String nodeId;

        public ProviderAtNode(ServiceEndpointInfo endpoint, DataProviderConnector provider, String nodeId) {
            this.endpoint = endpoint;
            this.provider = provider;
            this.nodeId = nodeId;
        }
    }

    public static final class Builder {
        private final ServiceLocator _serviceLocator;
        private ExecutorService _executorService;
        private VmomiDataProviderConfig _vmomiCfg = null;
        private VapiDataProviderConfig _vapiCfg = null;
        private Long _providerLoginThreshold = null;
        private Long _providerOperationThreshold = null;

        private Builder(ServiceLocator serviceLocator) {
            Validate.notNull((Object)serviceLocator, (String)"The serviceLocator is required.");
            this._serviceLocator = serviceLocator;
        }

        public Builder withExecutor(ExecutorService executorService) {
            this._executorService = executorService;
            return this;
        }

        public Builder withVmomiDataProviderConfig(VmomiDataProviderConfig vmomiCfg) {
            this._vmomiCfg = vmomiCfg;
            return this;
        }

        public Builder withVapiDataProviderConfig(VapiDataProviderConfig vapiCfg) {
            this._vapiCfg = vapiCfg;
            return this;
        }

        public Builder withProviderLoginThreshold(long providerLoginThreshold) {
            assert (providerLoginThreshold >= 0L);
            this._providerLoginThreshold = providerLoginThreshold;
            return this;
        }

        public Builder withProviderOperationThreshold(long providerOperationThreshold) {
            assert (providerOperationThreshold >= 0L);
            this._providerOperationThreshold = providerOperationThreshold;
            return this;
        }

        public VcenterDataProviders build() {
            VapiDataProviderConfig vapiCfgToUse;
            ExecutorService executorToUse = this._executorService != null ? this._executorService : Executors.newSingleThreadExecutor();
            long loginThresholdToUse = this._providerLoginThreshold != null ? this._providerLoginThreshold : 30000L;
            long operationThresholdToUse = this._providerOperationThreshold != null ? this._providerOperationThreshold : 2000L;
            VmomiDataProviderConfig vmomiCfgToUse = this._vmomiCfg;
            if (vmomiCfgToUse == null) {
                VmodlContext vmodlContext = VlsiClientUtil.createDefaultVmodlContext();
                SharedHttpConfigurationFactory httpConfigFactory = new SharedHttpConfigurationFactory();
                vmomiCfgToUse = VmomiDataProviderConfig.Builder.create().withHttpConfigurationFactory(httpConfigFactory).withVmodlContext(vmodlContext).build();
            }
            if ((vapiCfgToUse = this._vapiCfg) == null) {
                SharedProtocolConnectionFactory vapiConnFactory = new SharedProtocolConnectionFactory();
                vapiCfgToUse = VapiDataProviderConfig.Builder.create().withVapiConnectionFactory(vapiConnFactory).build();
            }
            return new VcenterDataProviders(this._serviceLocator, executorToUse, loginThresholdToUse, operationThresholdToUse, vmomiCfgToUse, vapiCfgToUse);
        }
    }
}

