/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi;

import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.DefaultVmomiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.HttpConfigurationFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.SharedHttpConfigurationFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VlsiClientUtil;
import com.vmware.cis.data.internal.adapters.vmomi.util.VmomiVersion;
import com.vmware.vim.vmomi.core.types.VmodlContext;

public final class VmomiDataProviderConfig {
    private final VmodlContext _vmodlContext;
    private final VmomiVersion _vmomiVersion;
    private final HttpConfigurationFactory _vlsiHttpConfigFactory;
    private final VmomiAuthenticatorFactory _authFactory;

    private VmomiDataProviderConfig(VmodlContext vmodlContext, VmomiVersion vmomiVersion, HttpConfigurationFactory vlsiHttpConfigFactory, VmomiAuthenticatorFactory authFactory) {
        this._vmodlContext = vmodlContext;
        this._vmomiVersion = vmomiVersion;
        this._vlsiHttpConfigFactory = vlsiHttpConfigFactory;
        this._authFactory = authFactory;
    }

    public VmodlContext getVmodlContext() {
        return this._vmodlContext;
    }

    public VmomiVersion getVmomiVersion() {
        return this._vmomiVersion;
    }

    public HttpConfigurationFactory getVlsiHttpConfigFactory() {
        return this._vlsiHttpConfigFactory;
    }

    public VmomiAuthenticatorFactory getAuthenticatorFactory() {
        return this._authFactory;
    }

    public static final class Builder {
        private VmomiVersion _vmomiVersion = VmomiVersion.PUBLIC;
        private VmodlContext _vmodlContext = null;
        private HttpConfigurationFactory _vlsiHttpConfigFactory = null;
        private VmomiAuthenticatorFactory _userSuppliedFactory = null;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder withVmomiVersion(VmomiVersion vmomiVersion) {
            this._vmomiVersion = vmomiVersion;
            return this;
        }

        public Builder withVmodlContext(VmodlContext context) {
            this._vmodlContext = context;
            return this;
        }

        public Builder withHttpConfigurationFactory(HttpConfigurationFactory vlsiHttpConfigFactory) {
            this._vlsiHttpConfigFactory = vlsiHttpConfigFactory;
            return this;
        }

        public Builder withAuthenticatorFactory(VmomiAuthenticatorFactory authFactory) {
            this._userSuppliedFactory = authFactory;
            return this;
        }

        public VmomiDataProviderConfig build() {
            VmodlContext contextToUse = this._vmodlContext != null ? this._vmodlContext : VlsiClientUtil.createDefaultVmodlContext();
            HttpConfigurationFactory configFactoryToUse = this._vlsiHttpConfigFactory != null ? this._vlsiHttpConfigFactory : new SharedHttpConfigurationFactory();
            DefaultVmomiAuthenticatorFactory authFactoryToUse = new DefaultVmomiAuthenticatorFactory(this._vmodlContext, configFactoryToUse, this._userSuppliedFactory);
            return new VmomiDataProviderConfig(contextToUse, this._vmomiVersion, configFactoryToUse, authFactoryToUse);
        }
    }
}

