/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.impl;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.adapters.vmomi.impl.ResultSetRange;
import com.vmware.cis.data.internal.provider.util.ResultSetUtil;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

class NotInSupportDataProvider
implements DataProvider {
    private final DataProvider _provider;

    public NotInSupportDataProvider(DataProvider provider) {
        assert (provider != null);
        this._provider = provider;
    }

    public QuerySchema getSchema() {
        return this._provider.getSchema();
    }

    public ResultSet executeQuery(Query query) {
        assert (query != null);
        Collection<Object> keysToExclude = NotInSupportDataProvider.getKeysToExclude(query);
        if (keysToExclude.isEmpty()) {
            return this._provider.executeQuery(query);
        }
        if (query.getLimit() == 0) {
            Filter modifiedFilter = NotInSupportDataProvider.getFilterWithoutNotIn(query.getFilter());
            Query modifiedQuery = QueryCopy.copy((Query)query).where(modifiedFilter).build();
            ResultSet resultSet = this._provider.executeQuery(modifiedQuery);
            return NotInSupportDataProvider.modifyResultTotalCountPerExcludedKeys(this._provider, resultSet, query, keysToExclude);
        }
        Query modifiedQuery = NotInSupportDataProvider.extendQueryPage(query, keysToExclude);
        ResultSet resultSet = this._provider.executeQuery(modifiedQuery);
        ResultSetRange resultRange = new ResultSetRange(resultSet, modifiedQuery.getOffset(), modifiedQuery.getLimit());
        ResultSet processedResult = NotInSupportDataProvider.processResult(this._provider, resultRange, query, keysToExclude);
        return ResultSetUtil.project((ResultSet)processedResult, (List)query.getProperties());
    }

    public String toString() {
        return this._provider.toString();
    }

    private static Collection<Object> getKeysToExclude(Query query) {
        assert (query != null);
        LinkedHashSet<Object> keysToExclude = new LinkedHashSet<Object>();
        Filter filter = query.getFilter();
        if (filter == null) {
            return keysToExclude;
        }
        for (PropertyPredicate predicate : filter.getCriteria()) {
            if (!PropertyPredicate.ComparisonOperator.NOT_IN.equals((Object)predicate.getOperator())) continue;
            if (!"@modelKey".equals(predicate.getProperty())) {
                throw new IllegalArgumentException("NOT_IN operator is supported only for @modelKey properties.");
            }
            Collection comparableKeys = (Collection)predicate.getComparableValue();
            keysToExclude.addAll(comparableKeys);
        }
        if (keysToExclude.isEmpty()) {
            return keysToExclude;
        }
        if (filter.getCriteria().size() > 1 && filter.getOperator().equals((Object)LogicalOperator.OR)) {
            throw new IllegalArgumentException("NOT_IN operator is supported only for filters with logical operator AND.");
        }
        return keysToExclude;
    }

    private static ResultSet processResult(DataProvider provider, ResultSetRange resultRange, Query query, Collection<Object> keysToExclude) {
        if (resultRange.isEmptyPage(query.getOffset(), query.getLimit())) {
            ResultSet resultSet = resultRange.page(query.getOffset(), query.getLimit());
            if (query.getWithTotalCount()) {
                return NotInSupportDataProvider.modifyResultTotalCountPerExcludedKeys(provider, resultSet, query, keysToExclude);
            }
            return resultSet;
        }
        Collection<?> remainingKeysToExclude = resultRange.getAbsent(keysToExclude);
        resultRange = resultRange.exclude(keysToExclude);
        if (remainingKeysToExclude.isEmpty()) {
            return resultRange.page(query.getOffset(), query.getLimit());
        }
        if (query.getOffset() == 0 && query.getLimit() < 0) {
            return resultRange.page(query.getOffset(), query.getLimit());
        }
        if (resultRange.isEmptyPage(query.getOffset(), query.getLimit()) || resultRange.getOffset() == 0) {
            ResultSet resultSet = resultRange.page(query.getOffset(), query.getLimit());
            if (query.getWithTotalCount()) {
                return NotInSupportDataProvider.modifyResultTotalCountPerExcludedKeys(provider, resultSet, query, remainingKeysToExclude);
            }
            return resultSet;
        }
        ResultSet keysToExcludeResult = NotInSupportDataProvider.fetchSortPropertiesForExcludedKeys(provider, query, remainingKeysToExclude);
        if (keysToExcludeResult.getItems().isEmpty()) {
            return resultRange.page(query.getOffset(), query.getLimit());
        }
        resultRange = resultRange.exclude(keysToExcludeResult.getItems(), query.getSortCriteria());
        return resultRange.page(query.getOffset(), query.getLimit());
    }

    private static ResultSet modifyResultTotalCountPerExcludedKeys(DataProvider provider, ResultSet resultSet, Query query, Collection<?> keysToExclude) {
        Filter filterForExcludedKeys = NotInSupportDataProvider.filterForExcludedKeys(query.getFilter(), keysToExclude);
        Query queryForTotalCount = Query.Builder.select((String[])new String[0]).from(query.getResourceModels()).where(filterForExcludedKeys).limit(0).withTotalCount().build();
        ResultSet totalCountResultSet = provider.executeQuery(queryForTotalCount);
        int totalCount = resultSet.getTotalCount() - totalCountResultSet.getTotalCount();
        totalCount = totalCount < 0 ? 0 : totalCount;
        return ResultSet.Builder.copy((ResultSet)resultSet).totalCount(Integer.valueOf(totalCount)).build();
    }

    private static ResultSet fetchSortPropertiesForExcludedKeys(DataProvider provider, Query query, Collection<?> keysToExclude) {
        Filter filterForExcludedKeys = NotInSupportDataProvider.filterForExcludedKeys(query.getFilter(), keysToExclude);
        ArrayList<String> selectedProperties = new ArrayList<String>();
        selectedProperties.add("@modelKey");
        assert (!query.getSortCriteria().isEmpty());
        for (SortCriterion sort : query.getSortCriteria()) {
            selectedProperties.add(sort.getProperty());
        }
        Query queryForOrderedKeys = Query.Builder.select(selectedProperties).from(query.getResourceModels()).where(filterForExcludedKeys).orderBy(query.getSortCriteria()).build();
        ResultSet orderedKeysResultSet = provider.executeQuery(queryForOrderedKeys);
        return orderedKeysResultSet;
    }

    private static Filter filterForExcludedKeys(Filter filter, Collection<?> keysToExclude) {
        assert (filter != null);
        assert (keysToExclude != null);
        ArrayList<PropertyPredicate> predicates = new ArrayList<PropertyPredicate>();
        for (PropertyPredicate predicate : filter.getCriteria()) {
            if (PropertyPredicate.ComparisonOperator.NOT_IN.equals((Object)predicate.getOperator())) continue;
            predicates.add(predicate);
        }
        if (keysToExclude.size() == 1) {
            predicates.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, keysToExclude.iterator().next()));
        } else {
            predicates.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, keysToExclude));
        }
        return new Filter(predicates, LogicalOperator.AND);
    }

    private static Query extendQueryPage(Query query, Collection<?> keysToExclude) {
        ArrayList<String> selectedProperties = new ArrayList<String>(query.getProperties());
        if (!selectedProperties.contains("@modelKey")) {
            selectedProperties.add("@modelKey");
        }
        for (SortCriterion sort : query.getSortCriteria()) {
            if (selectedProperties.contains(sort.getProperty())) continue;
            selectedProperties.add(sort.getProperty());
        }
        int effectiveOffset = NotInSupportDataProvider.getEffectiveOffset(query, keysToExclude);
        int effectiveLimit = NotInSupportDataProvider.getEffectiveLimit(query, keysToExclude);
        Filter modifiedFilter = NotInSupportDataProvider.getFilterWithoutNotIn(query.getFilter());
        return QueryCopy.copyAndSelect((Query)query, selectedProperties).where(modifiedFilter).offset(effectiveOffset).limit(effectiveLimit).build();
    }

    private static Filter getFilterWithoutNotIn(Filter filter) {
        assert (filter != null);
        ArrayList<PropertyPredicate> predicates = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        for (PropertyPredicate predicate : filter.getCriteria()) {
            if (PropertyPredicate.ComparisonOperator.NOT_IN.equals((Object)predicate.getOperator())) continue;
            predicates.add(predicate);
        }
        return predicates.isEmpty() ? null : new Filter(predicates, filter.getOperator());
    }

    private static int getEffectiveLimit(Query query, Collection<?> keysToExclude) {
        if (query.getLimit() > 0) {
            long effectiveLimit = Math.min(Integer.MAX_VALUE, (long)query.getLimit() + (long)(2 * keysToExclude.size()));
            return (int)effectiveLimit;
        }
        return query.getLimit();
    }

    private static int getEffectiveOffset(Query query, Collection<?> keysToExclude) {
        if (query.getOffset() > 0) {
            long effectiveOffset = query.getOffset() - keysToExclude.size();
            return effectiveOffset < 0L ? 0 : (int)effectiveOffset;
        }
        return query.getOffset();
    }
}

