/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.impl;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VlsiClientUtil;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProviderQueryConverter;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProviderResultSetConverter;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProviderSchemaConverter;
import com.vmware.cis.data.internal.util.QueryMarker;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.cis.data.provider.QuerySpec;
import com.vmware.vim.binding.cis.data.provider.ResourceModel;
import com.vmware.vim.binding.cis.data.provider.schema.ResourceModelInfo;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VmomiDataProviderConnection
implements DataProvider {
    private static final Logger _logger = LoggerFactory.getLogger(VmomiDataProviderConnection.class);
    private final Client _vlsiClient;
    private final URI _serviceUri;

    public VmomiDataProviderConnection(Client vlsiClient) {
        Validate.notNull((Object)vlsiClient, (String)"VLSI client");
        this._vlsiClient = vlsiClient;
        this._serviceUri = vlsiClient.getBinding().getEndpointUri();
    }

    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        QuerySpec querySpec = VmomiDataProviderQueryConverter.convertQuery(query);
        if (querySpec == null) {
            return ResultSet.Builder.properties((List)query.getProperties()).totalCount(query.getWithTotalCount() ? Integer.valueOf(0) : null).build();
        }
        com.vmware.vim.binding.cis.data.provider.ResultSet vmodlResult = this.query(querySpec);
        return VmomiDataProviderResultSetConverter.convertResultSet(vmodlResult, querySpec, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuerySchema getSchema() {
        ResourceModel resourceModelStub = VmomiDataProviderConnection.createStub(this._vlsiClient);
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(VlsiClientUtil.class.getClassLoader());
        try {
            _logger.trace("Requesting schema from VC data provider");
            ResourceModelInfo[] models = resourceModelStub.getSchema();
            QuerySchema schema = VmomiDataProviderSchemaConverter.convertSchema(models);
            _logger.trace("Received schema from VC data provider: {}", (Object)schema);
            QuerySchema querySchema = schema;
            return querySchema;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    public String toString() {
        return "VmomiConnection(url=" + this._serviceUri + ")";
    }

    private com.vmware.vim.binding.cis.data.provider.ResultSet query(QuerySpec query) {
        try {
            return this.queryImpl(query);
        }
        catch (InvalidArgument ex) {
            throw new IllegalArgumentException("Invalid query", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.vmware.vim.binding.cis.data.provider.ResultSet queryImpl(QuerySpec query) {
        com.vmware.vim.binding.cis.data.provider.ResultSet result;
        ResourceModel resourceModelStub = VmomiDataProviderConnection.createStub(this._vlsiClient);
        boolean extendedTracing = QueryMarker.isExtendedTracingEnabled();
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(VlsiClientUtil.class.getClassLoader());
        try {
            if (extendedTracing) {
                _logger.info("Sending query {} to VC data provider at {}", (Object)QueryMarker.getQueryId(), (Object)this._serviceUri);
            } else {
                _logger.trace("Sending query {} to VC data provider at {}: {}", new Object[]{QueryMarker.getQueryId(), this._serviceUri, query});
            }
            result = resourceModelStub.query(query);
            _logger.trace("Received response from VC data provider: {}", (Object)result);
        }
        finally {
            if (extendedTracing) {
                _logger.info("Query {} complete. VC data provider: {}", (Object)QueryMarker.getQueryId(), (Object)this._serviceUri);
            }
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
        return result;
    }

    private static ResourceModel createStub(Client vlsiClient) {
        ManagedObjectReference ref = new ManagedObjectReference("DPResourceModel", "ResourceModel", null);
        ResourceModel stub = VlsiClientUtil.createStub(vlsiClient, ResourceModel.class, ref);
        VmomiDataProviderConnection.setOpId((ManagedObject)stub);
        return stub;
    }

    private static void setOpId(ManagedObject mo) {
        String opId = QueryMarker.getQueryId();
        if (opId == null) {
            return;
        }
        VmomiDataProviderConnection.getRequestContext(mo).put((Object)"operationID", (Object)opId);
    }

    private static RequestContextImpl getRequestContext(ManagedObject mo) {
        Stub stub = (Stub)mo;
        RequestContextImpl rc = (RequestContextImpl)stub._getRequestContext();
        if (rc == null) {
            rc = new RequestContextImpl();
            stub._setRequestContext((RequestContext)rc);
        }
        return rc;
    }
}

