/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.impl;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.vim.binding.cis.data.provider.schema.PropertyInfo;
import com.vmware.vim.binding.cis.data.provider.schema.ResourceModelInfo;
import java.util.HashMap;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VmomiDataProviderSchemaConverter {
    private static final Logger _logger = LoggerFactory.getLogger(VmomiDataProviderSchemaConverter.class);

    VmomiDataProviderSchemaConverter() {
    }

    public static QuerySchema convertSchema(ResourceModelInfo[] vmomiModels) {
        Validate.notEmpty((Object[])vmomiModels);
        HashMap<String, QuerySchema.ModelInfo> models = new HashMap<String, QuerySchema.ModelInfo>(vmomiModels.length);
        for (ResourceModelInfo vmomiModel : vmomiModels) {
            models.put(vmomiModel.getName(), VmomiDataProviderSchemaConverter.convertModel(vmomiModel));
        }
        return QuerySchema.forModels(models);
    }

    private static QuerySchema.ModelInfo convertModel(ResourceModelInfo vmomiModel) {
        HashMap<String, QuerySchema.PropertyInfo> properties = new HashMap<String, QuerySchema.PropertyInfo>(vmomiModel.getProperties().length);
        for (PropertyInfo propertyInfo : vmomiModel.getProperties()) {
            String modelName = vmomiModel.getName();
            String propertyName = propertyInfo.getName();
            try {
                properties.put(propertyName, VmomiDataProviderSchemaConverter.convertProperty(modelName, propertyInfo));
            }
            catch (Exception e) {
                String msg = String.format("There is an error in the registration of %s/%s.", modelName, propertyName);
                _logger.error(msg, (Throwable)e);
            }
        }
        return new QuerySchema.ModelInfo(properties);
    }

    private static QuerySchema.PropertyInfo convertProperty(String modelName, PropertyInfo vmomiProperty) {
        boolean isPropertyFilterableByUnset;
        boolean isPropertyFilterable;
        boolean bl = isPropertyFilterable = vmomiProperty.getFilterable() != null && vmomiProperty.getFilterable() != false;
        if (isPropertyFilterable) {
            return VmomiDataProviderSchemaConverter.convertFilterableProperty(modelName, vmomiProperty.getName(), vmomiProperty.getType());
        }
        boolean bl2 = isPropertyFilterableByUnset = vmomiProperty.getFilterableByUnset() != null && vmomiProperty.getFilterableByUnset() != false;
        if (isPropertyFilterableByUnset) {
            return QuerySchema.PropertyInfo.forFilterableByUnsetProperty();
        }
        return QuerySchema.PropertyInfo.forNonFilterableProperty();
    }

    private static QuerySchema.PropertyInfo convertFilterableProperty(String modelName, String propertyName, String vmomiPropertyType) {
        PropertyInfo.PropertyType propertyType;
        try {
            propertyType = PropertyInfo.PropertyType.valueOf((String)vmomiPropertyType);
        }
        catch (Exception e) {
            String msg = String.format("Property %s/%s marked as filterable has invalid type: %s.", modelName, propertyName, vmomiPropertyType);
            throw new IllegalArgumentException(msg);
        }
        switch (propertyType) {
            case STRING: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING);
            }
            case BYTE: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.BYTE);
            }
            case SHORT: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.SHORT);
            }
            case INT: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.INT);
            }
            case LONG: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.LONG);
            }
            case FLOAT: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.FLOAT);
            }
            case DOUBLE: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.DOUBLE);
            }
            case BOOLEAN: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.BOOLEAN);
            }
            case MOREF: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID);
            }
            case ENUM: {
                return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ENUM);
            }
        }
        String msg = String.format("Property %s/%s marked as filterable contains type that doesn't have a core equivalent: %s.", modelName, propertyName, propertyType);
        throw new IllegalArgumentException(msg);
    }
}

