/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.commondataformat.serialization.rdf;

import com.vmware.ph.exceptions.Bug;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.rio.turtle.TurtleWriter;

public class CompactTurtleWriter
extends TurtleWriter {
    public static Value createListValue(List<Value> values) {
        return new ListValue(values);
    }

    public CompactTurtleWriter(OutputStream out) {
        super(out);
    }

    public CompactTurtleWriter(Writer out) {
        super(out);
    }

    @Override
    protected void writeValue(Value val) throws IOException {
        if (val instanceof ListValue) {
            this.writer.append('(');
            for (Value element : ((ListValue)val).values) {
                this.writeValue(element);
                if (element instanceof ListValue) {
                    this.writer.writeEOL();
                    continue;
                }
                this.writer.append(' ');
            }
            this.writer.append(')');
        } else {
            super.writeValue(val);
        }
    }

    private static class ListValue
    implements Value {
        private final List<Value> values;

        private ListValue(List<Value> values) {
            this.values = values;
        }

        @Override
        public String stringValue() {
            throw new Bug("ListValue.stringValue should not be called.");
        }
    }
}

