/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.commondataformat.serialization.rdf;

import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.commondataformat.serialization.CdfSequenceSerializer;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.FreeFormData;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.RelatedResource;
import com.vmware.ph.common.StringUtil;
import com.vmware.ph.exceptions.Bug;
import java.io.IOException;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.Literals;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class RdfCdfSequenceSerializer
implements CdfSequenceSerializer {
    public static final String ENVELOPE_RESOURCE_TYPE = "envelope";
    public static final String ENVELOPE_TIMESTAMP_PREDICATE = "has_timestamp";
    public static final String ENVELOPE_COLLECTOR_PREDICATE = "for_collector";
    public static final String ENVELOPE_SYSTEM_ID = "envelope_id";
    public static final String COLLECTOR_RESOURCE_TYPE = "collector";
    public static final String COLLECTOR_HAS_INSTANCE_PREDICATE = "has_instance";
    public static final String COLLECTOR_INSTANCE_TYPE = "collector_instance";
    static final String CDF_URI_SCHEME = "cdf:";
    static final String CUSTOM_PREDICATES_NAMESPACE = "schema#";
    private static final String ID_NAMESPACE = "id#";
    private static final String TYPES_NAMESPACE = "type#";
    private final ValueFactory valueFactory = new ValueFactoryImpl();
    private final RDFHandler handler;

    RdfCdfSequenceSerializer(RDFHandler handler) throws RDFHandlerException {
        this.handler = handler;
        handler.startRDF();
        handler.handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        handler.handleNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
        handler.handleNamespace("c", "cdf:schema#");
        handler.handleNamespace("t", "cdf:type#");
        handler.handleNamespace("id", "cdf:id#");
    }

    @Override
    public void write(CdfAble cdf) throws IOException {
        if (FreeFormData.class.equals(cdf.getClass())) {
            this.write((FreeFormData)cdf);
        } else if (com.vmware.ph.client.api.commondataformat.types.Resource.class.equals(cdf.getClass())) {
            this.write((com.vmware.ph.client.api.commondataformat.types.Resource)cdf);
        } else if (PayloadEnvelope.class.equals(cdf.getClass())) {
            this.write((PayloadEnvelope)cdf);
        } else {
            throw new Bug("Not implemented. Cannot serialize " + cdf.getClass().getName());
        }
    }

    void write(com.vmware.ph.client.api.commondataformat.types.Resource res) throws IOException {
        URI resourceUri = this.idAsUri(res.getId());
        try {
            this.handler.handleStatement(new StatementImpl(resourceUri, RDF.TYPE, this.typeAsUri(res.getType())));
            for (Resource.KeyValue kv : res.getAttributes()) {
                if (kv == null) continue;
                this.handler.handleStatement(new StatementImpl(resourceUri, this.predAsUri(kv.getKey()), this.primitiveAsValue(kv.getValue())));
            }
            for (RelatedResource rr : res.getRelations()) {
                if (rr == null) continue;
                this.handler.handleStatement(new StatementImpl(resourceUri, this.predAsUri(rr.getNameOfRelation()), this.idAsUri(rr.getResourceId())));
            }
        }
        catch (RDFHandlerException e) {
            throw RdfCdfSequenceSerializer.toIOException(e);
        }
    }

    void write(FreeFormData str) throws IOException {
        URI resourceUri = this.idAsUri(str.getId());
        try {
            this.handler.handleStatement(new StatementImpl(resourceUri, RDF.TYPE, this.typeAsUri(str.getType())));
            List<AnyPrimitive[]> data = str.getData();
            boolean isEmpty = true;
            Resource outerTail = this.valueFactory.createBNode();
            StatementImpl dataRelation = new StatementImpl(resourceUri, this.predAsUri("data"), outerTail);
            for (int i = 0; i < data.size(); ++i) {
                URI nextNode;
                AnyPrimitive[] row = data.get(i);
                if (row.length == 0) continue;
                isEmpty = false;
                Resource innerTail = this.valueFactory.createBNode();
                this.handler.handleStatement(new StatementImpl(outerTail, RDF.FIRST, innerTail));
                for (int j = 0; j < row.length; ++j) {
                    this.handler.handleStatement(new StatementImpl(innerTail, RDF.FIRST, this.primitiveAsValue(row[j])));
                    nextNode = j == row.length - 1 ? RDF.NIL : this.valueFactory.createBNode();
                    this.handler.handleStatement(new StatementImpl(innerTail, RDF.REST, nextNode));
                    innerTail = nextNode;
                }
                assert (((Object)innerTail).equals(RDF.NIL));
                nextNode = i == data.size() - 1 ? RDF.NIL : this.valueFactory.createBNode();
                this.handler.handleStatement(new StatementImpl(outerTail, RDF.REST, nextNode));
                outerTail = nextNode;
            }
            assert (((Object)outerTail).equals(RDF.NIL));
            if (!isEmpty) {
                this.handler.handleStatement(dataRelation);
            }
        }
        catch (RDFHandlerException e) {
            throw RdfCdfSequenceSerializer.toIOException(e);
        }
    }

    void write(PayloadEnvelope envelope) throws IOException {
        Collector collector = envelope.getCollector();
        long timestamp = envelope.getTimestamp();
        BNode envelopeBNode = this.envelopeIdAsBNode();
        URI collectorIdUri = this.idAsUri(collector.getCollectorId());
        try {
            this.handler.handleStatement(new StatementImpl(envelopeBNode, RDF.TYPE, this.typeAsUri(ENVELOPE_RESOURCE_TYPE)));
            this.handler.handleStatement(new StatementImpl(envelopeBNode, this.predAsUri(ENVELOPE_COLLECTOR_PREDICATE), collectorIdUri));
            this.handler.handleStatement(new StatementImpl(envelopeBNode, this.predAsUri(ENVELOPE_TIMESTAMP_PREDICATE), this.objectAsValue(timestamp)));
            this.handler.handleStatement(new StatementImpl(collectorIdUri, RDF.TYPE, this.typeAsUri(COLLECTOR_RESOURCE_TYPE)));
            if (!StringUtil.isEmptyOrNull(collector.getCollectorInstanceId())) {
                URI collectorInstanceIdUri = this.idAsUri(collector.getCollectorInstanceId());
                this.handler.handleStatement(new StatementImpl(collectorIdUri, this.predAsUri(COLLECTOR_HAS_INSTANCE_PREDICATE), collectorInstanceIdUri));
                this.handler.handleStatement(new StatementImpl(collectorInstanceIdUri, RDF.TYPE, this.typeAsUri(COLLECTOR_INSTANCE_TYPE)));
            }
        }
        catch (RDFHandlerException e) {
            throw RdfCdfSequenceSerializer.toIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.handler.endRDF();
        }
        catch (RDFHandlerException e) {
            throw RdfCdfSequenceSerializer.toIOException(e);
        }
    }

    RDFHandler getHandler() {
        return this.handler;
    }

    static IOException toIOException(RDFHandlerException e) throws IOException {
        if (e.getCause() instanceof IOException) {
            return (IOException)e.getCause();
        }
        return new IOException(e);
    }

    BNode envelopeIdAsBNode() {
        return new BNodeImpl(ENVELOPE_SYSTEM_ID);
    }

    URI idAsUri(String id) {
        return new URIImpl("cdf:id#" + id);
    }

    URI predAsUri(String key) {
        return new URIImpl("cdf:schema#" + key);
    }

    URI sequencePredAsUri(int index) {
        return new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + index);
    }

    Value typeAsUri(String type) {
        return new URIImpl("cdf:type#" + type);
    }

    Value primitiveAsValue(AnyPrimitive value) {
        Object object = value.getValue();
        return this.objectAsValue(object);
    }

    Value objectAsValue(Object object) {
        if (object == null) {
            return RDF.NIL;
        }
        if (object instanceof Integer || object instanceof Long) {
            return new LiteralImpl(String.valueOf(object), XMLSchema.INTEGER);
        }
        return Literals.createLiteral(this.valueFactory, object);
    }
}

