/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.extensions.ps;

import com.btr.proxy.util.PlatformUtil;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOrigin;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOriginProvider;
import com.vmware.ph.client.common.extensions.ps.discovery.JnaWinRegistry;
import com.vmware.ph.client.common.extensions.ps.discovery.ProxyVoleProvider;
import com.vmware.ph.client.common.extensions.ps.discovery.WinRegistryProxyProvider;
import com.vmware.ph.client.common.extensions.ps.discovery.WpadProxyProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyProviderFactory {
    public static ProxySettingsWithOriginProvider getDefaultProvider(URI platformBaseUri) {
        ArrayList<ProxySettingsWithOriginProvider> providers = new ArrayList<ProxySettingsWithOriginProvider>();
        providers.add(ProxySettingsWithOriginProvider.DIRECT_CONN_PROVIDER);
        providers.add(new ProxyVoleProvider(platformBaseUri));
        if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
            providers.add(new WinRegistryProxyProvider(new JnaWinRegistry()));
        }
        providers.add(new WpadProxyProvider(platformBaseUri));
        return new MultiProxyProvider(providers);
    }

    static class MultiProxyProvider
    implements ProxySettingsWithOriginProvider {
        private static final Logger log = LoggerFactory.getLogger(MultiProxyProvider.class);
        private final List<ProxySettingsWithOriginProvider> providers;

        public MultiProxyProvider(List<ProxySettingsWithOriginProvider> providers) {
            this.providers = providers;
        }

        List<ProxySettingsWithOriginProvider> getProviders() {
            return this.providers;
        }

        @Override
        public Collection<ProxySettingsWithOrigin> getOptions() {
            LinkedHashSet<ProxySettingsWithOrigin> result = new LinkedHashSet<ProxySettingsWithOrigin>();
            for (ProxySettingsWithOriginProvider p : this.providers) {
                try {
                    result.addAll(this.getProxySettingsFromProvider(p));
                }
                catch (RuntimeException e) {
                    log.debug("Unexpected error while retrieving proxy settings from provider " + p, (Throwable)e);
                }
            }
            return result;
        }

        private Collection<ProxySettingsWithOrigin> getProxySettingsFromProvider(ProxySettingsWithOriginProvider p) {
            Collection<ProxySettingsWithOrigin> result = p.getOptions();
            log.debug("Discovered proxy settings from provider " + p.getClass().getName() + " = " + result.size());
            for (ProxySettingsWithOrigin proxy : result) {
                if (proxy == null) continue;
                log.debug(proxy.toString());
            }
            return result;
        }
    }
}

