/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.extensions.ps.discovery;

import com.btr.proxy.search.ProxySearch;
import com.btr.proxy.util.Logger;
import com.btr.proxy.util.PlatformUtil;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOrigin;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOriginProvider;
import com.vmware.ph.client.common.extensions.ps.discovery.Utils;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyVoleProvider
implements ProxySettingsWithOriginProvider {
    private static final Logger log = LoggerFactory.getLogger(ProxyVoleProvider.class);
    private final URI platformBaseUri;

    public ProxyVoleProvider(URI platformBaseUri) {
        this.configureLogging();
        this.platformBaseUri = platformBaseUri;
    }

    @Override
    public Collection<ProxySettingsWithOrigin> getOptions() {
        LinkedHashSet<ProxySettingsWithOrigin> result = new LinkedHashSet<ProxySettingsWithOrigin>();
        for (ProxySearch.Strategy strategy : this.getStrategies()) {
            result.addAll(this.getSettings(strategy, this.platformBaseUri));
        }
        return result;
    }

    private List<ProxySettingsWithOrigin> getSettings(ProxySearch.Strategy strategy, URI platformUri) {
        List<Proxy> possibleProxies = null;
        try {
            ProxySearch proxySearch = new ProxySearch();
            proxySearch.addStrategy(strategy);
            ProxySelector selector = proxySearch.getProxySelector();
            if (selector != null) {
                possibleProxies = selector.select(platformUri);
            }
        }
        catch (RuntimeException e) {
            log.warn("Ignoring unexpected error while retrieving proxy information from " + (Object)((Object)strategy), (Throwable)e);
        }
        ArrayList<ProxySettingsWithOrigin> result = new ArrayList<ProxySettingsWithOrigin>();
        if (possibleProxies != null) {
            for (Proxy javaProxy : possibleProxies) {
                List<ProxySettingsWithOrigin> strategyResult = Utils.toProxySettings(javaProxy, strategy.toString());
                result.addAll(strategyResult);
            }
        }
        log.debug("Strategy {} yielded {}.", (Object)strategy, result);
        return result;
    }

    private List<ProxySearch.Strategy> getStrategies() {
        ArrayList<ProxySearch.Strategy> result = new ArrayList<ProxySearch.Strategy>();
        result.add(ProxySearch.Strategy.JAVA);
        if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
            result.add(ProxySearch.Strategy.IE);
        }
        result.add(ProxySearch.Strategy.ENV_VAR);
        return result;
    }

    private void configureLogging() {
        com.btr.proxy.util.Logger.setBackend(new Logger.LogBackEnd(){

            @Override
            public void log(Class<?> clazz, Logger.LogLevel loglevel, String msg, Object ... params) {
                log.debug(clazz.getSimpleName() + " " + (Object)((Object)loglevel) + " " + MessageFormat.format(msg, params));
            }

            @Override
            public boolean isLogginEnabled(Logger.LogLevel logLevel) {
                return log.isDebugEnabled();
            }
        });
    }
}

