/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.common.extensions.ps.discovery;

import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOrigin;
import com.vmware.ph.client.common.extensions.ps.ProxySettingsWithOriginProvider;
import com.vmware.ph.client.common.extensions.ps.discovery.Utils;
import com.vmware.ph.client.common.extensions.ps.discovery.WinRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRegistryProxyProvider
implements ProxySettingsWithOriginProvider {
    private static final Logger log = LoggerFactory.getLogger(WinRegistryProxyProvider.class);
    private static final String REG_PROXY_SETTINGS_KEY_REL_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
    private static final String REG_PROXY_SERVER_VALUE_NAME = "ProxyServer";
    public static final int DEFAULT_HTTP_TUNNEL_PROXY_PORT = 443;
    private final WinRegistry registry;

    public WinRegistryProxyProvider(WinRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Collection<ProxySettingsWithOrigin> getOptions() {
        LinkedHashSet<ProxySettingsWithOrigin> result = new LinkedHashSet<ProxySettingsWithOrigin>();
        for (String userHkey : this.registry.getUserHkeys()) {
            String key = userHkey + "\\" + REG_PROXY_SETTINGS_KEY_REL_PATH;
            String proxyServer = this.registry.getHkeyUsersStringValue(key, REG_PROXY_SERVER_VALUE_NAME);
            result.addAll(this.extractHttpsProxySettings(proxyServer));
        }
        if (result.size() == 0) {
            log.info("Didn't find any proxy settings in the HKEY_USERS\\" + Arrays.toString(this.registry.getUserHkeys().toArray()) + "\\" + REG_PROXY_SETTINGS_KEY_REL_PATH + " and value:'" + REG_PROXY_SERVER_VALUE_NAME + "\nHopefully other proxy auto-discovery strategies will find a proxy.");
        }
        log.debug("WinRegistry strategy yielded {}.", result);
        return result;
    }

    private List<ProxySettingsWithOrigin> extractHttpsProxySettings(String proxyServer) {
        ArrayList<ProxySettingsWithOrigin> result = new ArrayList<ProxySettingsWithOrigin>();
        if (StringUtils.isBlank(proxyServer)) {
            return result;
        }
        String[] byProtocolParts = proxyServer.split(";");
        if (byProtocolParts.length == 1 && !byProtocolParts[0].contains("=")) {
            result.addAll(this.toProxySettings(byProtocolParts[0]));
        } else {
            HashMap<String, String> proxyByProtocol = new HashMap<String, String>();
            for (String part : byProtocolParts) {
                String[] protocolAndProxy = part.split("=");
                if (protocolAndProxy.length != 2) continue;
                proxyByProtocol.put(protocolAndProxy[0].trim().toLowerCase(), protocolAndProxy[1]);
            }
            log.debug("Extracted proxies by protocol: {}", proxyByProtocol);
            result.addAll(this.toProxySettings((String)proxyByProtocol.get("https")));
            result.addAll(this.toProxySettings((String)proxyByProtocol.get("http")));
        }
        return result;
    }

    private List<ProxySettingsWithOrigin> toProxySettings(String proxyServer) {
        ArrayList<ProxySettingsWithOrigin> result = new ArrayList<ProxySettingsWithOrigin>();
        if (StringUtils.isBlank(proxyServer)) {
            return result;
        }
        log.debug("Parsing proxy server string '{}' ...", (Object)proxyServer);
        Utils.HostAndPort hap = Utils.parseHost(proxyServer);
        if (hap.getHostname() != null) {
            result.add(new ProxySettingsWithOrigin(hap.getHostname(), hap.getPort(443), null, null, "Registry"));
        }
        log.debug("Converted registry proxy string {} to {}.", (Object)proxyServer, result);
        return result;
    }
}

