/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.extension;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionUtil {
    private static final Logger log = LoggerFactory.getLogger(ExtensionUtil.class);
    private static final ExtensionUtil INSTANCE = new ExtensionUtil();

    private ExtensionUtil() {
    }

    public static ExtensionUtil getInstance() {
        return INSTANCE;
    }

    public <T> T loadExtension(Class<T> extensionClass) {
        log.debug("Loading extension {}", extensionClass);
        ServiceLoader<T> extLoader = ServiceLoader.load(extensionClass);
        Iterator<T> extensionIterator = extLoader.iterator();
        boolean possiblyMoreExtensions = true;
        boolean serviceErrorFound = false;
        int numberOfAttempts = 0;
        do {
            try {
                if (extensionIterator.hasNext()) {
                    log.debug("Extension is loaded successfully and will be used.");
                    return extensionIterator.next();
                }
                possiblyMoreExtensions = false;
            }
            catch (ServiceConfigurationError e) {
                serviceErrorFound = true;
                log.warn("An extension implementation was found, however it couldn't be loaded and won't be used. If there is another extension implementation, it will be used.", (Throwable)e);
            }
        } while (possiblyMoreExtensions && ++numberOfAttempts < 3);
        if (serviceErrorFound) {
            log.warn("While loading the extension, one or more implementations were found, however they couldn't be loaded. This represents a faulty behavior with either the extension usage, or with incorrect extension configuration. Check the preceding exception(s). Returning null.");
        } else {
            log.debug("No extension found. Returning null.");
        }
        return null;
    }
}

