/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    public static final String X_REAL_IP = "X-Real-IP";
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static Set<String> getIpAddressesInRequestPath(HttpServletRequest request) {
        String xForwaredFor = request.getHeader(X_FORWARDED_FOR);
        String xRealIp = request.getHeader(X_REAL_IP);
        String remoteAddr = request.getRemoteAddr();
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(HttpUtil.parseXforwardedFor(xForwaredFor));
        if (!StringUtils.isBlank(xRealIp)) {
            result.add(xRealIp.trim());
        }
        if (!StringUtils.isBlank(remoteAddr)) {
            result.add(remoteAddr);
        }
        return result;
    }

    public static String getExternalIp(Collection<String> ips) {
        String externalIp = null;
        for (String ip : ips) {
            if (HttpUtil.isIpInternal(ip)) continue;
            externalIp = ip;
            break;
        }
        return externalIp;
    }

    public static boolean areAllIpsInternal(Collection<String> ips) {
        return HttpUtil.getExternalIp(ips) == null;
    }

    static boolean isIpInternal(String ip) {
        boolean result = false;
        try {
            result = HttpUtil.isIpInNetwork(ip, "127.0.0.0", "255.0.0.0") || HttpUtil.isIpInNetwork(ip, "10.0.0.0", "255.0.0.0") || HttpUtil.isIpInNetwork(ip, "172.16.0.0", "255.240.0.0") || HttpUtil.isIpInNetwork(ip, "192.168.0.0", "255.255.0.0");
        }
        catch (IllegalArgumentException e) {
            log.error("While determining if the ip: " + ip.substring(0, 3) + " is internal, there was an error parsing it. " + "As a result the method assumes the IP is not internal and will return false. " + "This might not be desirable though. It may also indicate the IP is IPv6 which is not " + "currently supported.", (Throwable)e);
        }
        return result;
    }

    private static boolean isIpInNetwork(String ip, String network, String mask) {
        return new SubnetUtils(network, mask).getInfo().isInRange(ip);
    }

    private static List<String> parseXforwardedFor(String xForwaredFor) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isNotBlank(xForwaredFor)) {
            String[] ips;
            for (String ip : ips = xForwaredFor.split(",")) {
                if (!StringUtils.isNotBlank(ip)) continue;
                result.add(ip.trim());
            }
        }
        return result;
    }
}

