/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.common;

import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class StringUtil {
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String newLine = System.getProperty("line.separator");
    public static final String fileSeparator = System.getProperty("file.separator");
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static boolean equalStrings(String s1, String s2) {
        boolean res = false;
        if (null == s1) {
            if (null == s2) {
                res = true;
            }
        } else {
            res = s1.equals(s2);
        }
        return res;
    }

    public static boolean contains(String s1, String s2) {
        boolean res = false;
        if (null == s1) {
            if (null == s2) {
                res = true;
            }
        } else {
            res = null == s2 ? true : s1.contains(s2);
        }
        return res;
    }

    public static String trimMiddle(String s, int keepLeading, int keepTrailing) {
        String dots;
        String res = s;
        int len = s.length();
        if (len > keepLeading + (dots = "...").length() + keepTrailing) {
            res = s.substring(0, keepLeading) + dots + s.substring(len - keepTrailing, len);
        }
        return res;
    }

    public static String obfuscate(String s) {
        String res = "...";
        int len = s.length();
        int chunkSize = Math.min(5, len / 4);
        if (10 < len) {
            res = StringUtil.trimMiddle(s, chunkSize, chunkSize);
        }
        return res;
    }

    public static String indent(String text, int depth, boolean indentFirstLine) {
        StringBuffer indentBuf = new StringBuffer();
        while (depth-- > 0) {
            indentBuf.append("\t");
        }
        String indent = indentBuf.toString();
        StringBuffer sb = new StringBuffer();
        if (indentFirstLine) {
            sb.append(indent);
        }
        sb.append(null == text ? "null" : text.replace("\n", "\n" + indent));
        return sb.toString();
    }

    public static String toStringUsingReflection(Object o, ToStringStyle style, String ... excludeFields) {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder(o, style);
        reflectionToStringBuilder.setAppendStatics(true);
        reflectionToStringBuilder.setAppendTransients(true);
        reflectionToStringBuilder.setExcludeFieldNames(excludeFields);
        return reflectionToStringBuilder.toString();
    }

    public static String toStringMultilineUsingReflection(Object o, String ... excludeFields) {
        return StringUtil.toStringUsingReflection(o, ToStringStyle.MULTI_LINE_STYLE, excludeFields);
    }

    public static String toStringShortPrefixUsingReflection(Object o, String ... excludeFields) {
        return StringUtil.toStringUsingReflection(o, ToStringStyle.SHORT_PREFIX_STYLE, excludeFields);
    }

    public static String toStringSimpleUsingReflection(Object o, String ... excludeFields) {
        return StringUtil.toStringUsingReflection(o, ToStringStyle.SIMPLE_STYLE, excludeFields);
    }

    public static String toString(Object ... methodArguments) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < methodArguments.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            try {
                sb.append(methodArguments[i]);
                continue;
            }
            catch (Throwable t) {
                sb.append("<failed to evaluate. Is this object a Proxy?>");
            }
        }
        String res = sb.toString();
        return res;
    }

    public static String toHexString(byte b) {
        int high = (b & 0xF0) >>> 4;
        int low = b & 0xF;
        return new String(new char[]{hexChar[high], hexChar[low]}).intern();
    }

    public static String[] toHexString(byte[] b) {
        String[] result = new String[b.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringUtil.toHexString(b[i]);
        }
        return result;
    }

    public static String toTimeInterval(long l) {
        long hr = TimeUnit.MILLISECONDS.toHours(l);
        long min = TimeUnit.MILLISECONDS.toMinutes(l - TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min));
        long ms = TimeUnit.MILLISECONDS.toMillis(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min) - TimeUnit.SECONDS.toMillis(sec));
        return String.format("%02d:%02d:%02d.%03d", hr, min, sec, ms);
    }

    public static boolean isEmptyOrNull(String s) {
        boolean isNull = s == null;
        boolean isEmpty = isNull ? true : s.isEmpty();
        return isNull || isEmpty;
    }

    public static boolean isTrimmedEmptyOrNull(String s) {
        boolean result = StringUtil.isEmptyOrNull(s);
        if (!result) {
            result = s.trim().isEmpty();
        }
        return result;
    }

    public static String afterLast(String subStr, String str) {
        String result = str;
        int lastIndex = str.lastIndexOf(subStr);
        int lenStr = str.length();
        if (-1 != lastIndex && lastIndex != lenStr) {
            result = str.substring(lastIndex + subStr.length());
        }
        return result;
    }

    private static String base64Decode(String base64) {
        if (null == base64) {
            return null;
        }
        byte[] decoded = Base64.decodeBase64(base64.getBytes(UTF8));
        String sDecoded = new String(decoded, UTF8);
        return sDecoded;
    }

    public static String base64DecodeWithCheck(String base64) throws IllegalArgumentException {
        byte[] bytes = base64.getBytes(UTF8);
        if (!Base64.isBase64(bytes)) {
            throw new IllegalArgumentException("Provided string contains non-base64 characters. The string was " + base64);
        }
        return StringUtil.base64Decode(base64);
    }

    public static String base64Encode(String input) {
        if (null == input) {
            return null;
        }
        byte[] bytes = input.getBytes(UTF8);
        byte[] encoded = Base64.encodeBase64(bytes);
        String output = new String(encoded);
        return output;
    }

    public static String periodToString(long start, long end) {
        boolean hasMillis;
        boolean hasSeconds;
        long diff = Math.abs(end - start);
        long diffMillis = diff % 1000L;
        long diffSeconds = diff / 1000L % 60L;
        long diffMinutes = diff / 60000L % 60L;
        long diffHours = diff / 3600000L % 24L;
        long diffDays = diff / 86400000L;
        assert (diffHours < 24L);
        assert (diffMinutes < 60L);
        assert (diffSeconds < 60L);
        assert (diffMillis < 1000L);
        String res = "";
        if (0L < diffDays) {
            res = res + "" + diffDays + "D";
        }
        if (0L < diffHours) {
            res = res + diffHours + "H";
        }
        if (0L < diffMinutes) {
            res = res + diffMinutes + "M";
        }
        boolean bl = hasSeconds = 0L < diffSeconds;
        if (hasSeconds) {
            res = res + diffSeconds;
        }
        boolean bl2 = hasMillis = 0L < diffMillis;
        if (hasMillis) {
            if (!hasSeconds) {
                res = res + "0";
            }
            String sDiffMillis = "000" + diffMillis;
            if ((sDiffMillis = sDiffMillis.substring(sDiffMillis.length() - 3)).endsWith("0")) {
                sDiffMillis = sDiffMillis.substring(0, sDiffMillis.length() - 1);
            }
            if (sDiffMillis.endsWith("0")) {
                sDiffMillis = sDiffMillis.substring(0, sDiffMillis.length() - 1);
            }
            res = res + "." + sDiffMillis;
        }
        if (hasMillis || hasSeconds) {
            res = res + "S";
        }
        if (res.isEmpty()) {
            res = "0.0S";
        }
        return "P" + res;
    }

    public static void throwOnBlankString(String s, String message) {
        if (StringUtils.isBlank(s)) {
            throw new IllegalArgumentException(message);
        }
    }
}

