/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.common.audit;

import com.vmware.ph.common.StringUtil;

public class AuditFileConfig {
    private final String filePath;
    private final boolean enableRotation;
    private final int maxFileSizeBytes;
    private final int maxHistory;

    public AuditFileConfig(String filePath, boolean enableRotation, int maxFileSizeBytes, int maxHistory) {
        StringUtil.throwOnBlankString(filePath, "Please provide not blank path to audit file.");
        this.validateFileSizeBytes(maxFileSizeBytes);
        this.validateMaxHistory(maxHistory);
        this.filePath = filePath;
        this.enableRotation = enableRotation;
        this.maxFileSizeBytes = maxFileSizeBytes;
        this.maxHistory = maxHistory;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isEnableRotation() {
        return this.enableRotation;
    }

    public int getMaxFileSizeBytes() {
        return this.maxFileSizeBytes;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    private void validateMaxHistory(int maxHistory) {
        this.validatePositiveInteger(maxHistory, "The provided maxHistory value " + maxHistory + " is not positive. As a result the audit roration policy is in ivalid state and the audit feature cannot work. Please provide positive value.");
    }

    private void validateFileSizeBytes(int maxFileSizeBytes) {
        this.validatePositiveInteger(maxFileSizeBytes, "The provided maxFileSizeBytes value  " + maxFileSizeBytes + " is not positive. As a result the audit rotation policy is in invalid state and the audit feature cannot work. Please provide positive value.");
    }

    private void validatePositiveInteger(int number, String message) {
        if (number <= 0) {
            throw new IllegalArgumentException(message);
        }
    }
}

