/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.common.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JsonSerializer {
    private JsonSerializer() {
    }

    public static <T> String getObjectAsString(T obj) throws IOException {
        String value = JsonSerializer.getObjectMapperForWrite().writeValueAsString(obj);
        return value;
    }

    public static <T> void writeObject(T obj, File targetFile) throws IOException {
        JsonSerializer.getObjectMapperForWrite().writeValue(targetFile, obj);
    }

    public static <T> void writeObject(T obj, OutputStream outputStream) throws IOException {
        JsonSerializer.getObjectMapperForWrite().writeValue(outputStream, obj);
    }

    public static <T> T readObject(String jsonContent, Class<T> objType) throws IOException {
        T obj = JsonSerializer.getObjectMapperForRead().readValue(jsonContent, objType);
        return obj;
    }

    public static <T> T readObject(InputStream inputStream, Class<T> objType) throws IOException {
        T obj = JsonSerializer.getObjectMapperForRead().readValue(inputStream, objType);
        return obj;
    }

    public static <T> T readObject(File sourceFile, Class<T> objType) throws IOException {
        T obj = JsonSerializer.getObjectMapperForRead().readValue(sourceFile, objType);
        return obj;
    }

    private static ObjectMapper getObjectMapperForWrite() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        return mapper;
    }

    private static ObjectMapper getObjectMapperForRead() {
        ObjectMapper mapper = new ObjectMapper();
        return mapper;
    }
}

