/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.upload;

import com.vmware.ph.common.TlsRestClientBuilderFactory;
import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.pool.ConnPoolControl;

public class HttpClientSetup {
    public static void setupHttpClientBuilder(HttpClientBuilder httpClientBuilder, HttpConnectionConfig connectionConfig, ProxySettings proxySettings, CredentialsProvider credentialsProvider) {
        HttpClientSetup.setupHttpClientBuilder(httpClientBuilder, connectionConfig, proxySettings, credentialsProvider, new TlsRestClientBuilderFactory());
    }

    static void setupHttpClientBuilder(HttpClientBuilder httpClientBuilder, HttpConnectionConfig connectionConfig, ProxySettings proxySettings, CredentialsProvider credentialsProvider, TlsRestClientBuilderFactory connMgrFactory) {
        httpClientBuilder.useSystemProperties();
        HttpClientConnectionManager connManager = HttpClientSetup.configureConnectionManager(connectionConfig, connMgrFactory);
        httpClientBuilder.setConnectionManager(connManager);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (connectionConfig != null) {
            httpClientBuilder.setMaxConnPerRoute(connectionConfig.getMaxConnectionsPerRoute());
            httpClientBuilder.setMaxConnTotal(connectionConfig.getMaxConnectionsTotal());
            requestConfigBuilder.setConnectTimeout(connectionConfig.getConnectionTimeout()).setSocketTimeout(connectionConfig.getConnectionTimeout());
        }
        if (proxySettings != null && !StringUtils.isBlank(proxySettings.getHostname())) {
            HttpHost proxy = new HttpHost(proxySettings.getHostname(), proxySettings.getPort());
            AuthScope proxyAuthScope = new AuthScope(proxy);
            if (!StringUtils.isBlank(proxySettings.getUsername())) {
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(proxySettings.getUsername(), proxySettings.getPassword());
                credentialsProvider.setCredentials(proxyAuthScope, proxyCredentials);
            }
            httpClientBuilder.setProxy(proxy);
            requestConfigBuilder.setProxyPreferredAuthSchemes(proxySettings.getProxyAuthenticationSchemes());
        } else {
            httpClientBuilder.setProxy(null);
        }
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
    }

    private static HttpClientConnectionManager configureConnectionManager(HttpConnectionConfig connectionConfig, TlsRestClientBuilderFactory connMgrFactory) {
        TrustManager[] trustManagers = connectionConfig == null ? null : connectionConfig.getTrustManagers();
        HttpClientConnectionManager connManager = connMgrFactory.createCustomizedConnectionManager(trustManagers);
        if (connManager instanceof ConnPoolControl && connectionConfig != null) {
            if (connectionConfig.getMaxConnectionsPerRoute() > 0) {
                ((ConnPoolControl)((Object)connManager)).setDefaultMaxPerRoute(connectionConfig.getMaxConnectionsPerRoute());
            }
            if (connectionConfig.getMaxConnectionsTotal() > 0) {
                ((ConnPoolControl)((Object)connManager)).setMaxTotal(connectionConfig.getMaxConnectionsTotal());
            }
        }
        return connManager;
    }

    public static HttpClientBuilder createHttpClientBuilder(HttpConnectionConfig connectionConfig, ProxySettings proxySettings, CredentialsProvider credentialsProvider) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        HttpClientSetup.setupHttpClientBuilder(httpClientBuilder, connectionConfig, proxySettings, credentialsProvider);
        return httpClientBuilder;
    }
}

