/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricStatValue;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceTimeIntervalRetriever;
import com.vmware.opsmgmt.client.advperfcharts.util.builder.PerformanceMetricStatValueBuilder;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BasePerformanceStats {
    protected static final String ANY_RELATED_DEVICE_ID = "*";
    protected static final String HOST_REFERENCE = "";
    private static final String STATS_UNIT_PERCENT = "percent";
    private static final int VALUE_MAX_DECIMAL_POSITIONS = 3;
    private static final int DAY_IN_SECONDS = 86400;
    private static final int SECOND_IN_MILLISECONDS = 1000;
    private static final long DEFAULT_INTERVALS_COUNT = 24L;
    private static final Log _logger = LogFactory.getLog(BasePerformanceStats.class);
    protected DataService dataService;
    protected List<PerformanceCounter> availableCounterList;
    protected PerformanceInfoQuerySpec originalParams;
    protected PerformanceManager perfManager;
    protected ManagedObjectReference moRef;

    protected BasePerformanceStats(ManagedObjectReference managedObjectReference, DataService dataService, PerformanceInfoQuerySpec performanceInfoQuerySpec) throws Exception {
        this.moRef = managedObjectReference;
        this.dataService = dataService;
        this.perfManager = this.retrievePerfManager();
        this.originalParams = performanceInfoQuerySpec;
    }

    public List<PerformanceCounterStats> getStats() throws Exception {
        PerformanceManager.QuerySpec querySpec = this.prepareQuerySpec();
        List<PerformanceCounterStats> list = this.executeQuery(querySpec);
        list = this.completeStats(list, querySpec);
        return list;
    }

    protected abstract PerformanceManager.QuerySpec prepareQuerySpec();

    protected abstract List<PerformanceCounterStats> executeQuery(PerformanceManager.QuerySpec var1) throws Exception;

    protected boolean hasMetricIdsItems() {
        return !this.isNullOrEmpty(this.originalParams.metricIds);
    }

    protected boolean hasCoutnerIdsItems() {
        return !this.isNullOrEmpty(this.originalParams.counterIds);
    }

    protected boolean hasRelatedDeviceIdsItems() {
        return !this.isNullOrEmpty(this.originalParams.relatedDeviceIds);
    }

    protected PerformanceManager.QuerySpec initBaseQuerySpec() {
        Integer n;
        Object object;
        PerformanceManager.QuerySpec querySpec = new PerformanceManager.QuerySpec();
        querySpec.entity = this.moRef;
        if (!ArrayUtil.isNullOrEmpty(this.originalParams.availableCounters)) {
            this.availableCounterList = this.originalParams.availableCounters;
        } else {
            object = new PerformanceCounterCollector(this.moRef, this.dataService, this.perfManager);
            this.availableCounterList = ((PerformanceCounterCollector)object).getAvailableCounters();
        }
        object = new PerformanceTimeIntervalRetriever(this.moRef, this.perfManager, this.originalParams);
        if (((PerformanceTimeIntervalRetriever)object).getStartDate() != null) {
            querySpec.startTime = Calendar.getInstance();
            querySpec.startTime.setTime(((PerformanceTimeIntervalRetriever)object).getStartDate());
        }
        if (((PerformanceTimeIntervalRetriever)object).getEndDate() != null) {
            querySpec.endTime = Calendar.getInstance();
            querySpec.endTime.setTime(((PerformanceTimeIntervalRetriever)object).getEndDate());
        }
        if ((n = ((PerformanceTimeIntervalRetriever)object).getSampleInterval()) != null && n != -1) {
            querySpec.intervalId = ((PerformanceTimeIntervalRetriever)object).getSampleInterval();
        }
        if (((PerformanceTimeIntervalRetriever)object).getMaxSample() > -1) {
            querySpec.maxSample = ((PerformanceTimeIntervalRetriever)object).getMaxSample();
        }
        return querySpec;
    }

    protected List<PerformanceManager.MetricId> getAvailableMetricIds(List<Integer> list, List<String> list2, PerformanceMetricTimeIntervals performanceMetricTimeIntervals) {
        ArrayList<PerformanceManager.MetricId> arrayList = new ArrayList<PerformanceManager.MetricId>();
        ArrayList<PerformanceMetricTimeIntervals> arrayList2 = new ArrayList<PerformanceMetricTimeIntervals>();
        if (this.isHistorical(performanceMetricTimeIntervals)) {
            arrayList2.add(PerformanceMetricTimeIntervals.HISTORICAL_STATS);
        } else {
            arrayList2.add(performanceMetricTimeIntervals);
        }
        for (PerformanceCounter performanceCounter : this.availableCounterList) {
            boolean bl;
            boolean bl2 = arrayList2.indexOf((Object)performanceCounter.interval) > -1;
            boolean bl3 = list.contains(performanceCounter.id);
            boolean bl4 = HOST_REFERENCE.equals(performanceCounter.relatedDeviceId) && list2.contains("total_device_id");
            boolean bl5 = bl = list2.contains(performanceCounter.relatedDeviceId) || ANY_RELATED_DEVICE_ID.equals(list2.get(0)) || bl4;
            if (!bl2 || !bl3 || !bl || this.containsMetricId(performanceCounter.metricId, arrayList)) continue;
            arrayList.add(performanceCounter.metricId);
        }
        return arrayList;
    }

    protected PerformanceCounter findCounterInfo(PerformanceManager.MetricId metricId) {
        for (PerformanceCounter performanceCounter : this.availableCounterList) {
            if (performanceCounter.id != metricId.getCounterId() || !performanceCounter.relatedDeviceId.equals(metricId.getInstance())) continue;
            return performanceCounter;
        }
        return null;
    }

    protected PerformanceMetricStatValue[] createPerfMetricStatsValues(PerformanceManager.SampleInfo[] sampleInfoArray, PerformanceManager.IntSeries intSeries, String string, boolean bl) {
        ArrayList<PerformanceMetricStatValue> arrayList = new ArrayList<PerformanceMetricStatValue>();
        if (sampleInfoArray.length == intSeries.value.length) {
            for (int i = 0; i < sampleInfoArray.length; ++i) {
                PerformanceMetricStatValueBuilder performanceMetricStatValueBuilder = new PerformanceMetricStatValueBuilder();
                PerformanceMetricStatValue performanceMetricStatValue = performanceMetricStatValueBuilder.build(sampleInfoArray[i].timestamp.getTime(), this.formatMetricValue(intSeries.value[i], string, bl));
                arrayList.add(performanceMetricStatValue);
            }
        }
        return arrayList.toArray(new PerformanceMetricStatValue[0]);
    }

    protected float formatMetricValue(long l, String string, boolean bl) {
        double d = l;
        if (STATS_UNIT_PERCENT.equals(string)) {
            d = (double)l / 100.0;
        }
        if (bl) {
            d = (double)l / 86400.0;
        }
        float f = 0.0f;
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal.setScale(3, 4);
        f = bigDecimal.floatValue();
        return f;
    }

    private List<PerformanceCounterStats> completeStats(List<PerformanceCounterStats> list, PerformanceManager.QuerySpec querySpec) {
        if (PerformanceMetricTimeIntervals.REALTIME.equals((Object)this.originalParams.interval)) {
            return list;
        }
        for (PerformanceCounterStats performanceCounterStats : list) {
            performanceCounterStats.statistics = this.populateMissingSamples(performanceCounterStats.statistics, querySpec);
        }
        return list;
    }

    private PerformanceMetricStatValue[] populateMissingSamples(PerformanceMetricStatValue[] performanceMetricStatValueArray, PerformanceManager.QuerySpec querySpec) {
        Object object;
        long l;
        if (this.isNullOrEmpty(performanceMetricStatValueArray)) {
            return performanceMetricStatValueArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        long l2 = querySpec.getStartTime().getTimeInMillis();
        long l3 = querySpec.getEndTime().getTimeInMillis();
        long l4 = performanceMetricStatValueArray[0].timestamp.getTime();
        long l5 = this.calculateSampleInterval(performanceMetricStatValueArray, querySpec);
        for (l = l4 - l5; l > l2; l -= l5) {
            object = new PerformanceMetricStatValueBuilder();
            PerformanceMetricStatValue performanceMetricStatValue = object.buildEmptyStatValueForDate(new Date(l));
            arrayList.add(0, (Object)performanceMetricStatValue);
        }
        for (l = l4; l <= l3; l += l5) {
            object = this.getSampleForTimestamp(l, performanceMetricStatValueArray);
            arrayList.add(object);
        }
        return arrayList.toArray(new PerformanceMetricStatValue[0]);
    }

    private PerformanceMetricStatValue getSampleForTimestamp(long l, PerformanceMetricStatValue[] performanceMetricStatValueArray) {
        for (PerformanceMetricStatValue performanceMetricStatValue : performanceMetricStatValueArray) {
            if (performanceMetricStatValue.timestamp.getTime() != l) continue;
            return performanceMetricStatValue;
        }
        PerformanceMetricStatValueBuilder performanceMetricStatValueBuilder = new PerformanceMetricStatValueBuilder();
        return performanceMetricStatValueBuilder.buildEmptyStatValueForDate(new Date(l));
    }

    private PerformanceManager retrievePerfManager() throws Exception {
        String string = this.moRef.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)string);
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        return (PerformanceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceInstanceContent.perfManager);
    }

    private long calculateSampleInterval(PerformanceMetricStatValue[] performanceMetricStatValueArray, PerformanceManager.QuerySpec querySpec) {
        if (!this.isNullOrEmpty(querySpec.intervalId) && querySpec.intervalId != -1) {
            return querySpec.intervalId * 1000;
        }
        if (!this.isNullOrEmpty(performanceMetricStatValueArray) && performanceMetricStatValueArray.length >= 2) {
            long l = performanceMetricStatValueArray[0].timestamp.getTime();
            long l2 = performanceMetricStatValueArray[1].timestamp.getTime();
            return l2 - l;
        }
        long l = querySpec.getStartTime().getTimeInMillis();
        long l3 = querySpec.getEndTime().getTimeInMillis();
        return (l3 - l) / 24L;
    }

    private boolean containsMetricId(PerformanceManager.MetricId metricId, List<PerformanceManager.MetricId> list) {
        for (PerformanceManager.MetricId metricId2 : list) {
            boolean bl;
            boolean bl2 = metricId2.instance.equals(metricId.instance);
            boolean bl3 = bl = metricId2.counterId == metricId.counterId;
            if (!bl2 || !bl) continue;
            return true;
        }
        return false;
    }

    private boolean isHistorical(PerformanceMetricTimeIntervals performanceMetricTimeIntervals) {
        return PerformanceMetricTimeIntervals.CUSTOM.equals((Object)performanceMetricTimeIntervals) || PerformanceMetricTimeIntervals.LAST_DAY.equals((Object)performanceMetricTimeIntervals) || PerformanceMetricTimeIntervals.LAST_WEEK.equals((Object)performanceMetricTimeIntervals) || PerformanceMetricTimeIntervals.LAST_MONTH.equals((Object)performanceMetricTimeIntervals) || PerformanceMetricTimeIntervals.LAST_YEAR.equals((Object)performanceMetricTimeIntervals);
    }

    private boolean isNullOrEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof List) {
            return ((List)object).size() == 0;
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length == 0;
        }
        return true;
    }
}

