/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceMetricIdInfoCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceTimeIntervalRetriever;
import com.vmware.opsmgmt.client.advperfcharts.util.comparator.PerformanceCountersComparator;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceCounterCollector {
    private static final Log _logger = LogFactory.getLog(PerformanceCounterCollector.class);
    private DataService _dataService;
    private ManagedObjectReference _moRef;
    private PerformanceManager _perfManager;
    private int _sampleInterval;
    private Calendar _startDate;
    private Calendar _endDate;

    public PerformanceCounterCollector(ManagedObjectReference managedObjectReference, DataService dataService) throws Exception {
        this._moRef = managedObjectReference;
        this._dataService = dataService;
        this._perfManager = this.retrievePerfManager();
    }

    public PerformanceCounterCollector(ManagedObjectReference managedObjectReference, DataService dataService, PerformanceManager performanceManager) {
        this._moRef = managedObjectReference;
        this._dataService = dataService;
        this._perfManager = performanceManager;
    }

    public ManagedObjectReference getMoRef() {
        return this._moRef;
    }

    public PerformanceManager getPerformanceManager() {
        return this._perfManager;
    }

    public int getSampleInterval() {
        return this._sampleInterval;
    }

    public Date getStartDate() {
        return this._startDate.getTime();
    }

    public Date getEndDate() {
        return this._endDate.getTime();
    }

    public List<PerformanceCounter> getAvailableCounters() {
        List<PerformanceCounter> list = this.getCountersForTimeInterval(PerformanceMetricTimeIntervals.REALTIME);
        List<PerformanceCounter> list2 = this.retrieveAvailableHistoricalCounters();
        ArrayList<PerformanceCounter> arrayList = new ArrayList<PerformanceCounter>();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public List<PerformanceCounter> getAvailableCountersSorted() {
        List<PerformanceCounter> list = this.getAvailableCounters();
        Collections.sort(list, new PerformanceCountersComparator());
        return list;
    }

    private List<PerformanceCounter> getCountersForTimeInterval(PerformanceMetricTimeIntervals performanceMetricTimeIntervals) {
        PerformanceInfoQuerySpec performanceInfoQuerySpec = new PerformanceInfoQuerySpec();
        performanceInfoQuerySpec.interval = performanceMetricTimeIntervals;
        PerformanceTimeIntervalRetriever performanceTimeIntervalRetriever = new PerformanceTimeIntervalRetriever(this._moRef, this._perfManager, performanceInfoQuerySpec);
        if (!performanceTimeIntervalRetriever.isAvailable()) {
            return new ArrayList<PerformanceCounter>();
        }
        _logger.debug((Object)("Calling PerformanceManager.queryAvailableMetric(<" + this._moRef + ">, null, null, " + performanceTimeIntervalRetriever.getSampleInterval() + ") "));
        PerformanceManager.MetricId[] metricIdArray = this._perfManager.queryAvailableMetric(this._moRef, null, null, performanceTimeIntervalRetriever.getSampleInterval());
        if (metricIdArray == null) {
            return new ArrayList<PerformanceCounter>();
        }
        PerformanceMetricIdInfoCollector performanceMetricIdInfoCollector = new PerformanceMetricIdInfoCollector(this._moRef, this._perfManager, this._dataService, metricIdArray, performanceMetricTimeIntervals);
        return performanceMetricIdInfoCollector.getPerformanceCounters();
    }

    private List<PerformanceCounter> retrieveAvailableHistoricalCounters() {
        return this.getCountersForTimeInterval(PerformanceMetricTimeIntervals.HISTORICAL_STATS);
    }

    private PerformanceManager retrievePerfManager() throws Exception {
        String string = this._moRef.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)string);
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        this._perfManager = (PerformanceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceInstanceContent.perfManager);
        return this._perfManager;
    }
}

